package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConsumedAmount invokes the cloudcallcenter.GetConsumedAmount API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconsumedamount.html
func (client *Client) GetConsumedAmount(request *GetConsumedAmountRequest) (response *GetConsumedAmountResponse, err error) {
	response = CreateGetConsumedAmountResponse()
	err = client.DoAction(request, response)
	return
}

// GetConsumedAmountWithChan invokes the cloudcallcenter.GetConsumedAmount API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconsumedamount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetConsumedAmountWithChan(request *GetConsumedAmountRequest) (<-chan *GetConsumedAmountResponse, <-chan error) {
	responseChan := make(chan *GetConsumedAmountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConsumedAmount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConsumedAmountWithCallback invokes the cloudcallcenter.GetConsumedAmount API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getconsumedamount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetConsumedAmountWithCallback(request *GetConsumedAmountRequest, callback func(response *GetConsumedAmountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConsumedAmountResponse
		var err error
		defer close(result)
		response, err = client.GetConsumedAmount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConsumedAmountRequest is the request struct for api GetConsumedAmount
type GetConsumedAmountRequest struct {
	*requests.RpcRequest
	Phone         string           `position:"Query" name:"phone"`
	TaobaoMainUid requests.Integer `position:"Query" name:"taobaoMainUid"`
	EndTime       requests.Integer `position:"Query" name:"endTime"`
	StartTime     requests.Integer `position:"Query" name:"startTime"`
	TaobaoUid     requests.Integer `position:"Query" name:"taobaoUid"`
	MainRamId     requests.Integer `position:"Query" name:"mainRamId"`
	RamId         requests.Integer `position:"Query" name:"ramId"`
}

// GetConsumedAmountResponse is the response struct for api GetConsumedAmount
type GetConsumedAmountResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Success         bool   `json:"Success" xml:"Success"`
	Code            string `json:"Code" xml:"Code"`
	Message         string `json:"Message" xml:"Message"`
	HttpStatusCode  int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	OutcomingAmount int64  `json:"outcomingAmount" xml:"outcomingAmount"`
	OutcomingCount  int    `json:"outcomingCount" xml:"outcomingCount"`
	IncomingAmount  int64  `json:"incomingAmount" xml:"incomingAmount"`
	IncomingCount   int    `json:"incomingCount" xml:"incomingCount"`
}

// CreateGetConsumedAmountRequest creates a request to invoke GetConsumedAmount API
func CreateGetConsumedAmountRequest() (request *GetConsumedAmountRequest) {
	request = &GetConsumedAmountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetConsumedAmount", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConsumedAmountResponse creates a response to parse from GetConsumedAmount response
func CreateGetConsumedAmountResponse() (response *GetConsumedAmountResponse) {
	response = &GetConsumedAmountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
