package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEthereumDeletable invokes the baas.DescribeEthereumDeletable API synchronously
// api document: https://help.aliyun.com/api/baas/describeethereumdeletable.html
func (client *Client) DescribeEthereumDeletable(request *DescribeEthereumDeletableRequest) (response *DescribeEthereumDeletableResponse, err error) {
	response = CreateDescribeEthereumDeletableResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEthereumDeletableWithChan invokes the baas.DescribeEthereumDeletable API asynchronously
// api document: https://help.aliyun.com/api/baas/describeethereumdeletable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEthereumDeletableWithChan(request *DescribeEthereumDeletableRequest) (<-chan *DescribeEthereumDeletableResponse, <-chan error) {
	responseChan := make(chan *DescribeEthereumDeletableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEthereumDeletable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEthereumDeletableWithCallback invokes the baas.DescribeEthereumDeletable API asynchronously
// api document: https://help.aliyun.com/api/baas/describeethereumdeletable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEthereumDeletableWithCallback(request *DescribeEthereumDeletableRequest, callback func(response *DescribeEthereumDeletableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEthereumDeletableResponse
		var err error
		defer close(result)
		response, err = client.DescribeEthereumDeletable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEthereumDeletableRequest is the request struct for api DescribeEthereumDeletable
type DescribeEthereumDeletableRequest struct {
	*requests.RpcRequest
	EthereumId string `position:"Body" name:"EthereumId"`
}

// DescribeEthereumDeletableResponse is the response struct for api DescribeEthereumDeletable
type DescribeEthereumDeletableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeEthereumDeletableRequest creates a request to invoke DescribeEthereumDeletable API
func CreateDescribeEthereumDeletableRequest() (request *DescribeEthereumDeletableRequest) {
	request = &DescribeEthereumDeletableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeEthereumDeletable", "baas", "openAPI")
	return
}

// CreateDescribeEthereumDeletableResponse creates a response to parse from DescribeEthereumDeletable response
func CreateDescribeEthereumDeletableResponse() (response *DescribeEthereumDeletableResponse) {
	response = &DescribeEthereumDeletableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
