package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClusterResourcePoolPerformance invokes the adb.DescribeDBClusterResourcePoolPerformance API synchronously
func (client *Client) DescribeDBClusterResourcePoolPerformance(request *DescribeDBClusterResourcePoolPerformanceRequest) (response *DescribeDBClusterResourcePoolPerformanceResponse, err error) {
	response = CreateDescribeDBClusterResourcePoolPerformanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClusterResourcePoolPerformanceWithChan invokes the adb.DescribeDBClusterResourcePoolPerformance API asynchronously
func (client *Client) DescribeDBClusterResourcePoolPerformanceWithChan(request *DescribeDBClusterResourcePoolPerformanceRequest) (<-chan *DescribeDBClusterResourcePoolPerformanceResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClusterResourcePoolPerformanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClusterResourcePoolPerformance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClusterResourcePoolPerformanceWithCallback invokes the adb.DescribeDBClusterResourcePoolPerformance API asynchronously
func (client *Client) DescribeDBClusterResourcePoolPerformanceWithCallback(request *DescribeDBClusterResourcePoolPerformanceRequest, callback func(response *DescribeDBClusterResourcePoolPerformanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClusterResourcePoolPerformanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClusterResourcePoolPerformance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClusterResourcePoolPerformanceRequest is the request struct for api DescribeDBClusterResourcePoolPerformance
type DescribeDBClusterResourcePoolPerformanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	ResourcePools        string           `position:"Query" name:"ResourcePools"`
	Key                  string           `position:"Query" name:"Key"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBClusterResourcePoolPerformanceResponse is the response struct for api DescribeDBClusterResourcePoolPerformance
type DescribeDBClusterResourcePoolPerformanceResponse struct {
	*responses.BaseResponse
	RequestId    string            `json:"RequestId" xml:"RequestId"`
	DBClusterId  string            `json:"DBClusterId" xml:"DBClusterId"`
	StartTime    string            `json:"StartTime" xml:"StartTime"`
	EndTime      string            `json:"EndTime" xml:"EndTime"`
	Performances []PerformanceItem `json:"Performances" xml:"Performances"`
}

// CreateDescribeDBClusterResourcePoolPerformanceRequest creates a request to invoke DescribeDBClusterResourcePoolPerformance API
func CreateDescribeDBClusterResourcePoolPerformanceRequest() (request *DescribeDBClusterResourcePoolPerformanceRequest) {
	request = &DescribeDBClusterResourcePoolPerformanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeDBClusterResourcePoolPerformance", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClusterResourcePoolPerformanceResponse creates a response to parse from DescribeDBClusterResourcePoolPerformance response
func CreateDescribeDBClusterResourcePoolPerformanceResponse() (response *DescribeDBClusterResourcePoolPerformanceResponse) {
	response = &DescribeDBClusterResourcePoolPerformanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
