/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.util.StringHelper;

public class InExpression
extends Expression {
    private final String propertyName;
    private final Object[] values;

    InExpression(String propertyName, Object[] values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        String params = StringHelper.repeat("?, ", this.values.length - 1);
        if (this.values.length > 0) {
            params = params + "?";
        }
        String condition = " in (" + params + ')';
        return StringHelper.join(" and ", StringHelper.suffix(Expression.getColumns(sessionFactory, persistentClass, this.propertyName, alias), condition));
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        TypedValue[] tvs = new TypedValue[this.values.length];
        int i = 0;
        while (i < tvs.length) {
            tvs[i] = Expression.getTypedValue(sessionFactory, persistentClass, this.propertyName, this.values[i]);
            ++i;
        }
        return tvs;
    }

    public String toString() {
        return this.propertyName + " in (" + StringHelper.toString(this.values) + ')';
    }
}

