// Code generated by smithy-go-codegen DO NOT EDIT.

package codecommit

import (
	"bytes"
	"context"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/restjson"
	"github.com/aws/aws-sdk-go-v2/service/codecommit/types"
	smithy "github.com/aws/smithy-go"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strings"
	"time"
)

func deserializeS3Expires(v string) (*time.Time, error) {
	t, err := smithytime.ParseHTTPDate(v)
	if err != nil {
		return nil, nil
	}
	return &t, nil
}

type awsAwsjson11_deserializeOpAssociateApprovalRuleTemplateWithRepository struct {
}

func (*awsAwsjson11_deserializeOpAssociateApprovalRuleTemplateWithRepository) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpAssociateApprovalRuleTemplateWithRepository) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorAssociateApprovalRuleTemplateWithRepository(response, &metadata)
	}
	output := &AssociateApprovalRuleTemplateWithRepositoryOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorAssociateApprovalRuleTemplateWithRepository(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("MaximumRuleTemplatesAssociatedWithRepositoryException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumRuleTemplatesAssociatedWithRepositoryException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpBatchAssociateApprovalRuleTemplateWithRepositories struct {
}

func (*awsAwsjson11_deserializeOpBatchAssociateApprovalRuleTemplateWithRepositories) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpBatchAssociateApprovalRuleTemplateWithRepositories) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorBatchAssociateApprovalRuleTemplateWithRepositories(response, &metadata)
	}
	output := &BatchAssociateApprovalRuleTemplateWithRepositoriesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentBatchAssociateApprovalRuleTemplateWithRepositoriesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorBatchAssociateApprovalRuleTemplateWithRepositories(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	case strings.EqualFold("MaximumRepositoryNamesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumRepositoryNamesExceededException(response, errorBody)

	case strings.EqualFold("RepositoryNamesRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNamesRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpBatchDescribeMergeConflicts struct {
}

func (*awsAwsjson11_deserializeOpBatchDescribeMergeConflicts) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpBatchDescribeMergeConflicts) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorBatchDescribeMergeConflicts(response, &metadata)
	}
	output := &BatchDescribeMergeConflictsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentBatchDescribeMergeConflictsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorBatchDescribeMergeConflicts(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxConflictFilesException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxConflictFilesException(response, errorBody)

	case strings.EqualFold("InvalidMaxMergeHunksException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxMergeHunksException(response, errorBody)

	case strings.EqualFold("InvalidMergeOptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMergeOptionException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("MergeOptionRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorMergeOptionRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpBatchDisassociateApprovalRuleTemplateFromRepositories struct {
}

func (*awsAwsjson11_deserializeOpBatchDisassociateApprovalRuleTemplateFromRepositories) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpBatchDisassociateApprovalRuleTemplateFromRepositories) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorBatchDisassociateApprovalRuleTemplateFromRepositories(response, &metadata)
	}
	output := &BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentBatchDisassociateApprovalRuleTemplateFromRepositoriesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorBatchDisassociateApprovalRuleTemplateFromRepositories(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	case strings.EqualFold("MaximumRepositoryNamesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumRepositoryNamesExceededException(response, errorBody)

	case strings.EqualFold("RepositoryNamesRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNamesRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpBatchGetCommits struct {
}

func (*awsAwsjson11_deserializeOpBatchGetCommits) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpBatchGetCommits) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorBatchGetCommits(response, &metadata)
	}
	output := &BatchGetCommitsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentBatchGetCommitsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorBatchGetCommits(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitIdsLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdsLimitExceededException(response, errorBody)

	case strings.EqualFold("CommitIdsListRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdsListRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpBatchGetRepositories struct {
}

func (*awsAwsjson11_deserializeOpBatchGetRepositories) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpBatchGetRepositories) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorBatchGetRepositories(response, &metadata)
	}
	output := &BatchGetRepositoriesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentBatchGetRepositoriesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorBatchGetRepositories(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("MaximumRepositoryNamesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumRepositoryNamesExceededException(response, errorBody)

	case strings.EqualFold("RepositoryNamesRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNamesRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpCreateApprovalRuleTemplate struct {
}

func (*awsAwsjson11_deserializeOpCreateApprovalRuleTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpCreateApprovalRuleTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorCreateApprovalRuleTemplate(response, &metadata)
	}
	output := &CreateApprovalRuleTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentCreateApprovalRuleTemplateOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorCreateApprovalRuleTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateContentRequiredException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameAlreadyExistsException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameAlreadyExistsException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateContentException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateDescriptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateDescriptionException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	case strings.EqualFold("NumberOfRuleTemplatesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNumberOfRuleTemplatesExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpCreateBranch struct {
}

func (*awsAwsjson11_deserializeOpCreateBranch) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpCreateBranch) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorCreateBranch(response, &metadata)
	}
	output := &CreateBranchOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorCreateBranch(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchNameExistsException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameExistsException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpCreateCommit struct {
}

func (*awsAwsjson11_deserializeOpCreateCommit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpCreateCommit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorCreateCommit(response, &metadata)
	}
	output := &CreateCommitOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentCreateCommitOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorCreateCommit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBranchDoesNotExistException(response, errorBody)

	case strings.EqualFold("BranchNameIsTagNameException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameIsTagNameException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("CommitMessageLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response, errorBody)

	case strings.EqualFold("DirectoryNameConflictsWithFileNameException", errorCode):
		return awsAwsjson11_deserializeErrorDirectoryNameConflictsWithFileNameException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileContentAndSourceFileSpecifiedException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentAndSourceFileSpecifiedException(response, errorBody)

	case strings.EqualFold("FileContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("FileDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorFileDoesNotExistException(response, errorBody)

	case strings.EqualFold("FileEntryRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorFileEntryRequiredException(response, errorBody)

	case strings.EqualFold("FileModeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorFileModeRequiredException(response, errorBody)

	case strings.EqualFold("FileNameConflictsWithDirectoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorFileNameConflictsWithDirectoryNameException(response, errorBody)

	case strings.EqualFold("FilePathConflictsWithSubmodulePathException", errorCode):
		return awsAwsjson11_deserializeErrorFilePathConflictsWithSubmodulePathException(response, errorBody)

	case strings.EqualFold("FolderContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFolderContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidDeletionParameterException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidDeletionParameterException(response, errorBody)

	case strings.EqualFold("InvalidEmailException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidEmailException(response, errorBody)

	case strings.EqualFold("InvalidFileModeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileModeException(response, errorBody)

	case strings.EqualFold("InvalidParentCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidParentCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("MaximumFileEntriesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileEntriesExceededException(response, errorBody)

	case strings.EqualFold("NameLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNameLengthExceededException(response, errorBody)

	case strings.EqualFold("NoChangeException", errorCode):
		return awsAwsjson11_deserializeErrorNoChangeException(response, errorBody)

	case strings.EqualFold("ParentCommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("ParentCommitIdOutdatedException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitIdOutdatedException(response, errorBody)

	case strings.EqualFold("ParentCommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("PutFileEntryConflictException", errorCode):
		return awsAwsjson11_deserializeErrorPutFileEntryConflictException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("RestrictedSourceFileException", errorCode):
		return awsAwsjson11_deserializeErrorRestrictedSourceFileException(response, errorBody)

	case strings.EqualFold("SamePathRequestException", errorCode):
		return awsAwsjson11_deserializeErrorSamePathRequestException(response, errorBody)

	case strings.EqualFold("SourceFileOrContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorSourceFileOrContentRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpCreatePullRequest struct {
}

func (*awsAwsjson11_deserializeOpCreatePullRequest) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpCreatePullRequest) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorCreatePullRequest(response, &metadata)
	}
	output := &CreatePullRequestOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentCreatePullRequestOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorCreatePullRequest(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ClientRequestTokenRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorClientRequestTokenRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("IdempotencyParameterMismatchException", errorCode):
		return awsAwsjson11_deserializeErrorIdempotencyParameterMismatchException(response, errorBody)

	case strings.EqualFold("InvalidClientRequestTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidClientRequestTokenException(response, errorBody)

	case strings.EqualFold("InvalidDescriptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidDescriptionException(response, errorBody)

	case strings.EqualFold("InvalidReferenceNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReferenceNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidTargetException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTargetException(response, errorBody)

	case strings.EqualFold("InvalidTargetsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTargetsException(response, errorBody)

	case strings.EqualFold("InvalidTitleException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTitleException(response, errorBody)

	case strings.EqualFold("MaximumOpenPullRequestsExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumOpenPullRequestsExceededException(response, errorBody)

	case strings.EqualFold("MultipleRepositoriesInPullRequestException", errorCode):
		return awsAwsjson11_deserializeErrorMultipleRepositoriesInPullRequestException(response, errorBody)

	case strings.EqualFold("ReferenceDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorReferenceDoesNotExistException(response, errorBody)

	case strings.EqualFold("ReferenceNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReferenceNameRequiredException(response, errorBody)

	case strings.EqualFold("ReferenceTypeNotSupportedException", errorCode):
		return awsAwsjson11_deserializeErrorReferenceTypeNotSupportedException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("SourceAndDestinationAreSameException", errorCode):
		return awsAwsjson11_deserializeErrorSourceAndDestinationAreSameException(response, errorBody)

	case strings.EqualFold("TargetRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorTargetRequiredException(response, errorBody)

	case strings.EqualFold("TargetsRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorTargetsRequiredException(response, errorBody)

	case strings.EqualFold("TitleRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorTitleRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpCreatePullRequestApprovalRule struct {
}

func (*awsAwsjson11_deserializeOpCreatePullRequestApprovalRule) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpCreatePullRequestApprovalRule) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorCreatePullRequestApprovalRule(response, &metadata)
	}
	output := &CreatePullRequestApprovalRuleOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentCreatePullRequestApprovalRuleOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorCreatePullRequestApprovalRule(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleContentRequiredException(response, errorBody)

	case strings.EqualFold("ApprovalRuleNameAlreadyExistsException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleNameAlreadyExistsException(response, errorBody)

	case strings.EqualFold("ApprovalRuleNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleNameRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleContentException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleNameException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("NumberOfRulesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNumberOfRulesExceededException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpCreateRepository struct {
}

func (*awsAwsjson11_deserializeOpCreateRepository) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpCreateRepository) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorCreateRepository(response, &metadata)
	}
	output := &CreateRepositoryOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentCreateRepositoryOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorCreateRepository(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyInvalidIdException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyInvalidIdException(response, errorBody)

	case strings.EqualFold("EncryptionKeyInvalidUsageException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyInvalidUsageException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryDescriptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryDescriptionException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidSystemTagUsageException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidSystemTagUsageException(response, errorBody)

	case strings.EqualFold("InvalidTagsMapException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTagsMapException(response, errorBody)

	case strings.EqualFold("OperationNotAllowedException", errorCode):
		return awsAwsjson11_deserializeErrorOperationNotAllowedException(response, errorBody)

	case strings.EqualFold("RepositoryLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryLimitExceededException(response, errorBody)

	case strings.EqualFold("RepositoryNameExistsException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameExistsException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TagPolicyException", errorCode):
		return awsAwsjson11_deserializeErrorTagPolicyException(response, errorBody)

	case strings.EqualFold("TooManyTagsException", errorCode):
		return awsAwsjson11_deserializeErrorTooManyTagsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpCreateUnreferencedMergeCommit struct {
}

func (*awsAwsjson11_deserializeOpCreateUnreferencedMergeCommit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpCreateUnreferencedMergeCommit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorCreateUnreferencedMergeCommit(response, &metadata)
	}
	output := &CreateUnreferencedMergeCommitOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentCreateUnreferencedMergeCommitOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorCreateUnreferencedMergeCommit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitMessageLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("ConcurrentReferenceUpdateException", errorCode):
		return awsAwsjson11_deserializeErrorConcurrentReferenceUpdateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("FileModeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorFileModeRequiredException(response, errorBody)

	case strings.EqualFold("FolderContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFolderContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidEmailException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidEmailException(response, errorBody)

	case strings.EqualFold("InvalidFileModeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileModeException(response, errorBody)

	case strings.EqualFold("InvalidMergeOptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMergeOptionException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidReplacementContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementContentException(response, errorBody)

	case strings.EqualFold("InvalidReplacementTypeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementTypeException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("ManualMergeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorManualMergeRequiredException(response, errorBody)

	case strings.EqualFold("MaximumConflictResolutionEntriesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumConflictResolutionEntriesExceededException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("MergeOptionRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorMergeOptionRequiredException(response, errorBody)

	case strings.EqualFold("MultipleConflictResolutionEntriesException", errorCode):
		return awsAwsjson11_deserializeErrorMultipleConflictResolutionEntriesException(response, errorBody)

	case strings.EqualFold("NameLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNameLengthExceededException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementContentRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementTypeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementTypeRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDeleteApprovalRuleTemplate struct {
}

func (*awsAwsjson11_deserializeOpDeleteApprovalRuleTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDeleteApprovalRuleTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDeleteApprovalRuleTemplate(response, &metadata)
	}
	output := &DeleteApprovalRuleTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentDeleteApprovalRuleTemplateOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDeleteApprovalRuleTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateInUseException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateInUseException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDeleteBranch struct {
}

func (*awsAwsjson11_deserializeOpDeleteBranch) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDeleteBranch) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDeleteBranch(response, &metadata)
	}
	output := &DeleteBranchOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentDeleteBranchOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDeleteBranch(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("DefaultBranchCannotBeDeletedException", errorCode):
		return awsAwsjson11_deserializeErrorDefaultBranchCannotBeDeletedException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDeleteCommentContent struct {
}

func (*awsAwsjson11_deserializeOpDeleteCommentContent) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDeleteCommentContent) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDeleteCommentContent(response, &metadata)
	}
	output := &DeleteCommentContentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentDeleteCommentContentOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDeleteCommentContent(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommentDeletedException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDeletedException(response, errorBody)

	case strings.EqualFold("CommentDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommentIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentIdRequiredException(response, errorBody)

	case strings.EqualFold("InvalidCommentIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommentIdException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDeleteFile struct {
}

func (*awsAwsjson11_deserializeOpDeleteFile) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDeleteFile) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDeleteFile(response, &metadata)
	}
	output := &DeleteFileOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentDeleteFileOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDeleteFile(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBranchDoesNotExistException(response, errorBody)

	case strings.EqualFold("BranchNameIsTagNameException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameIsTagNameException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("CommitMessageLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorFileDoesNotExistException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidEmailException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidEmailException(response, errorBody)

	case strings.EqualFold("InvalidParentCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidParentCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("NameLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNameLengthExceededException(response, errorBody)

	case strings.EqualFold("ParentCommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("ParentCommitIdOutdatedException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitIdOutdatedException(response, errorBody)

	case strings.EqualFold("ParentCommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDeletePullRequestApprovalRule struct {
}

func (*awsAwsjson11_deserializeOpDeletePullRequestApprovalRule) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDeletePullRequestApprovalRule) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDeletePullRequestApprovalRule(response, &metadata)
	}
	output := &DeletePullRequestApprovalRuleOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentDeletePullRequestApprovalRuleOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDeletePullRequestApprovalRule(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleNameRequiredException(response, errorBody)

	case strings.EqualFold("CannotDeleteApprovalRuleFromTemplateException", errorCode):
		return awsAwsjson11_deserializeErrorCannotDeleteApprovalRuleFromTemplateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleNameException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDeleteRepository struct {
}

func (*awsAwsjson11_deserializeOpDeleteRepository) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDeleteRepository) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDeleteRepository(response, &metadata)
	}
	output := &DeleteRepositoryOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentDeleteRepositoryOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDeleteRepository(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDescribeMergeConflicts struct {
}

func (*awsAwsjson11_deserializeOpDescribeMergeConflicts) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDescribeMergeConflicts) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDescribeMergeConflicts(response, &metadata)
	}
	output := &DescribeMergeConflictsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentDescribeMergeConflictsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDescribeMergeConflicts(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorFileDoesNotExistException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxMergeHunksException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxMergeHunksException(response, errorBody)

	case strings.EqualFold("InvalidMergeOptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMergeOptionException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("MergeOptionRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorMergeOptionRequiredException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDescribePullRequestEvents struct {
}

func (*awsAwsjson11_deserializeOpDescribePullRequestEvents) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDescribePullRequestEvents) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDescribePullRequestEvents(response, &metadata)
	}
	output := &DescribePullRequestEventsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentDescribePullRequestEventsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDescribePullRequestEvents(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ActorDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorActorDoesNotExistException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidActorArnException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidActorArnException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestEventTypeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestEventTypeException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpDisassociateApprovalRuleTemplateFromRepository struct {
}

func (*awsAwsjson11_deserializeOpDisassociateApprovalRuleTemplateFromRepository) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpDisassociateApprovalRuleTemplateFromRepository) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorDisassociateApprovalRuleTemplateFromRepository(response, &metadata)
	}
	output := &DisassociateApprovalRuleTemplateFromRepositoryOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorDisassociateApprovalRuleTemplateFromRepository(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpEvaluatePullRequestApprovalRules struct {
}

func (*awsAwsjson11_deserializeOpEvaluatePullRequestApprovalRules) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpEvaluatePullRequestApprovalRules) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorEvaluatePullRequestApprovalRules(response, &metadata)
	}
	output := &EvaluatePullRequestApprovalRulesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentEvaluatePullRequestApprovalRulesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorEvaluatePullRequestApprovalRules(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRevisionIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRevisionIdException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("RevisionIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRevisionIdRequiredException(response, errorBody)

	case strings.EqualFold("RevisionNotCurrentException", errorCode):
		return awsAwsjson11_deserializeErrorRevisionNotCurrentException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetApprovalRuleTemplate struct {
}

func (*awsAwsjson11_deserializeOpGetApprovalRuleTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetApprovalRuleTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetApprovalRuleTemplate(response, &metadata)
	}
	output := &GetApprovalRuleTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetApprovalRuleTemplateOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetApprovalRuleTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetBlob struct {
}

func (*awsAwsjson11_deserializeOpGetBlob) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetBlob) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetBlob(response, &metadata)
	}
	output := &GetBlobOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetBlobOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetBlob(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BlobIdDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBlobIdDoesNotExistException(response, errorBody)

	case strings.EqualFold("BlobIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBlobIdRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileTooLargeException", errorCode):
		return awsAwsjson11_deserializeErrorFileTooLargeException(response, errorBody)

	case strings.EqualFold("InvalidBlobIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBlobIdException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetBranch struct {
}

func (*awsAwsjson11_deserializeOpGetBranch) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetBranch) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetBranch(response, &metadata)
	}
	output := &GetBranchOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetBranchOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetBranch(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBranchDoesNotExistException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetComment struct {
}

func (*awsAwsjson11_deserializeOpGetComment) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetComment) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetComment(response, &metadata)
	}
	output := &GetCommentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetCommentOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetComment(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommentDeletedException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDeletedException(response, errorBody)

	case strings.EqualFold("CommentDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommentIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentIdRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommentIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommentIdException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetCommentReactions struct {
}

func (*awsAwsjson11_deserializeOpGetCommentReactions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetCommentReactions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetCommentReactions(response, &metadata)
	}
	output := &GetCommentReactionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetCommentReactionsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetCommentReactions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommentDeletedException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDeletedException(response, errorBody)

	case strings.EqualFold("CommentDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommentIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentIdRequiredException(response, errorBody)

	case strings.EqualFold("InvalidCommentIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommentIdException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	case strings.EqualFold("InvalidReactionUserArnException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReactionUserArnException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetCommentsForComparedCommit struct {
}

func (*awsAwsjson11_deserializeOpGetCommentsForComparedCommit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetCommentsForComparedCommit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetCommentsForComparedCommit(response, &metadata)
	}
	output := &GetCommentsForComparedCommitOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetCommentsForComparedCommitOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetCommentsForComparedCommit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetCommentsForPullRequest struct {
}

func (*awsAwsjson11_deserializeOpGetCommentsForPullRequest) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetCommentsForPullRequest) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetCommentsForPullRequest(response, &metadata)
	}
	output := &GetCommentsForPullRequestOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetCommentsForPullRequestOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetCommentsForPullRequest(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryNotAssociatedWithPullRequestException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNotAssociatedWithPullRequestException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetCommit struct {
}

func (*awsAwsjson11_deserializeOpGetCommit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetCommit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetCommit(response, &metadata)
	}
	output := &GetCommitOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetCommitOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetCommit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitIdDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetDifferences struct {
}

func (*awsAwsjson11_deserializeOpGetDifferences) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetDifferences) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetDifferences(response, &metadata)
	}
	output := &GetDifferencesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetDifferencesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetDifferences(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("PathDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPathDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetFile struct {
}

func (*awsAwsjson11_deserializeOpGetFile) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetFile) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetFile(response, &metadata)
	}
	output := &GetFileOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetFileOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetFile(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorFileDoesNotExistException(response, errorBody)

	case strings.EqualFold("FileTooLargeException", errorCode):
		return awsAwsjson11_deserializeErrorFileTooLargeException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetFolder struct {
}

func (*awsAwsjson11_deserializeOpGetFolder) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetFolder) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetFolder(response, &metadata)
	}
	output := &GetFolderOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetFolderOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetFolder(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FolderDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorFolderDoesNotExistException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetMergeCommit struct {
}

func (*awsAwsjson11_deserializeOpGetMergeCommit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetMergeCommit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetMergeCommit(response, &metadata)
	}
	output := &GetMergeCommitOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetMergeCommitOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetMergeCommit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetMergeConflicts struct {
}

func (*awsAwsjson11_deserializeOpGetMergeConflicts) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetMergeConflicts) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetMergeConflicts(response, &metadata)
	}
	output := &GetMergeConflictsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetMergeConflictsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetMergeConflicts(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidDestinationCommitSpecifierException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidDestinationCommitSpecifierException(response, errorBody)

	case strings.EqualFold("InvalidMaxConflictFilesException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxConflictFilesException(response, errorBody)

	case strings.EqualFold("InvalidMergeOptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMergeOptionException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidSourceCommitSpecifierException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidSourceCommitSpecifierException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("MergeOptionRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorMergeOptionRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetMergeOptions struct {
}

func (*awsAwsjson11_deserializeOpGetMergeOptions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetMergeOptions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetMergeOptions(response, &metadata)
	}
	output := &GetMergeOptionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetMergeOptionsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetMergeOptions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetPullRequest struct {
}

func (*awsAwsjson11_deserializeOpGetPullRequest) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetPullRequest) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetPullRequest(response, &metadata)
	}
	output := &GetPullRequestOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetPullRequestOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetPullRequest(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetPullRequestApprovalStates struct {
}

func (*awsAwsjson11_deserializeOpGetPullRequestApprovalStates) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetPullRequestApprovalStates) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetPullRequestApprovalStates(response, &metadata)
	}
	output := &GetPullRequestApprovalStatesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetPullRequestApprovalStatesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetPullRequestApprovalStates(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRevisionIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRevisionIdException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("RevisionIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRevisionIdRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetPullRequestOverrideState struct {
}

func (*awsAwsjson11_deserializeOpGetPullRequestOverrideState) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetPullRequestOverrideState) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetPullRequestOverrideState(response, &metadata)
	}
	output := &GetPullRequestOverrideStateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetPullRequestOverrideStateOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetPullRequestOverrideState(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRevisionIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRevisionIdException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("RevisionIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRevisionIdRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetRepository struct {
}

func (*awsAwsjson11_deserializeOpGetRepository) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetRepository) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetRepository(response, &metadata)
	}
	output := &GetRepositoryOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetRepositoryOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetRepository(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpGetRepositoryTriggers struct {
}

func (*awsAwsjson11_deserializeOpGetRepositoryTriggers) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpGetRepositoryTriggers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorGetRepositoryTriggers(response, &metadata)
	}
	output := &GetRepositoryTriggersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentGetRepositoryTriggersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorGetRepositoryTriggers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpListApprovalRuleTemplates struct {
}

func (*awsAwsjson11_deserializeOpListApprovalRuleTemplates) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpListApprovalRuleTemplates) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorListApprovalRuleTemplates(response, &metadata)
	}
	output := &ListApprovalRuleTemplatesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentListApprovalRuleTemplatesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorListApprovalRuleTemplates(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpListAssociatedApprovalRuleTemplatesForRepository struct {
}

func (*awsAwsjson11_deserializeOpListAssociatedApprovalRuleTemplatesForRepository) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpListAssociatedApprovalRuleTemplatesForRepository) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorListAssociatedApprovalRuleTemplatesForRepository(response, &metadata)
	}
	output := &ListAssociatedApprovalRuleTemplatesForRepositoryOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentListAssociatedApprovalRuleTemplatesForRepositoryOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorListAssociatedApprovalRuleTemplatesForRepository(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpListBranches struct {
}

func (*awsAwsjson11_deserializeOpListBranches) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpListBranches) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorListBranches(response, &metadata)
	}
	output := &ListBranchesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentListBranchesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorListBranches(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpListFileCommitHistory struct {
}

func (*awsAwsjson11_deserializeOpListFileCommitHistory) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpListFileCommitHistory) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorListFileCommitHistory(response, &metadata)
	}
	output := &ListFileCommitHistoryOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentListFileCommitHistoryOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorListFileCommitHistory(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpListPullRequests struct {
}

func (*awsAwsjson11_deserializeOpListPullRequests) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpListPullRequests) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorListPullRequests(response, &metadata)
	}
	output := &ListPullRequestsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentListPullRequestsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorListPullRequests(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("AuthorDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorAuthorDoesNotExistException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidAuthorArnException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidAuthorArnException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestStatusException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestStatusException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpListRepositories struct {
}

func (*awsAwsjson11_deserializeOpListRepositories) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpListRepositories) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorListRepositories(response, &metadata)
	}
	output := &ListRepositoriesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentListRepositoriesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorListRepositories(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidOrderException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidOrderException(response, errorBody)

	case strings.EqualFold("InvalidSortByException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidSortByException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpListRepositoriesForApprovalRuleTemplate struct {
}

func (*awsAwsjson11_deserializeOpListRepositoriesForApprovalRuleTemplate) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpListRepositoriesForApprovalRuleTemplate) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorListRepositoriesForApprovalRuleTemplate(response, &metadata)
	}
	output := &ListRepositoriesForApprovalRuleTemplateOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentListRepositoriesForApprovalRuleTemplateOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorListRepositoriesForApprovalRuleTemplate(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	case strings.EqualFold("InvalidContinuationTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response, errorBody)

	case strings.EqualFold("InvalidMaxResultsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidMaxResultsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpListTagsForResource struct {
}

func (*awsAwsjson11_deserializeOpListTagsForResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpListTagsForResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorListTagsForResource(response, &metadata)
	}
	output := &ListTagsForResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentListTagsForResourceOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorListTagsForResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidResourceArnException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidResourceArnException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("ResourceArnRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorResourceArnRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpMergeBranchesByFastForward struct {
}

func (*awsAwsjson11_deserializeOpMergeBranchesByFastForward) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpMergeBranchesByFastForward) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorMergeBranchesByFastForward(response, &metadata)
	}
	output := &MergeBranchesByFastForwardOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentMergeBranchesByFastForwardOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorMergeBranchesByFastForward(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBranchDoesNotExistException(response, errorBody)

	case strings.EqualFold("BranchNameIsTagNameException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameIsTagNameException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("ConcurrentReferenceUpdateException", errorCode):
		return awsAwsjson11_deserializeErrorConcurrentReferenceUpdateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidTargetBranchException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTargetBranchException(response, errorBody)

	case strings.EqualFold("ManualMergeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorManualMergeRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpMergeBranchesBySquash struct {
}

func (*awsAwsjson11_deserializeOpMergeBranchesBySquash) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpMergeBranchesBySquash) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorMergeBranchesBySquash(response, &metadata)
	}
	output := &MergeBranchesBySquashOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentMergeBranchesBySquashOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorMergeBranchesBySquash(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBranchDoesNotExistException(response, errorBody)

	case strings.EqualFold("BranchNameIsTagNameException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameIsTagNameException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitMessageLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("ConcurrentReferenceUpdateException", errorCode):
		return awsAwsjson11_deserializeErrorConcurrentReferenceUpdateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("FileModeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorFileModeRequiredException(response, errorBody)

	case strings.EqualFold("FolderContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFolderContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidEmailException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidEmailException(response, errorBody)

	case strings.EqualFold("InvalidFileModeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileModeException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidReplacementContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementContentException(response, errorBody)

	case strings.EqualFold("InvalidReplacementTypeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementTypeException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidTargetBranchException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTargetBranchException(response, errorBody)

	case strings.EqualFold("ManualMergeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorManualMergeRequiredException(response, errorBody)

	case strings.EqualFold("MaximumConflictResolutionEntriesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumConflictResolutionEntriesExceededException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("MultipleConflictResolutionEntriesException", errorCode):
		return awsAwsjson11_deserializeErrorMultipleConflictResolutionEntriesException(response, errorBody)

	case strings.EqualFold("NameLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNameLengthExceededException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementContentRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementTypeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementTypeRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpMergeBranchesByThreeWay struct {
}

func (*awsAwsjson11_deserializeOpMergeBranchesByThreeWay) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpMergeBranchesByThreeWay) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorMergeBranchesByThreeWay(response, &metadata)
	}
	output := &MergeBranchesByThreeWayOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentMergeBranchesByThreeWayOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorMergeBranchesByThreeWay(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBranchDoesNotExistException(response, errorBody)

	case strings.EqualFold("BranchNameIsTagNameException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameIsTagNameException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitMessageLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response, errorBody)

	case strings.EqualFold("CommitRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitRequiredException(response, errorBody)

	case strings.EqualFold("ConcurrentReferenceUpdateException", errorCode):
		return awsAwsjson11_deserializeErrorConcurrentReferenceUpdateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("FileModeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorFileModeRequiredException(response, errorBody)

	case strings.EqualFold("FolderContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFolderContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidCommitException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidEmailException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidEmailException(response, errorBody)

	case strings.EqualFold("InvalidFileModeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileModeException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidReplacementContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementContentException(response, errorBody)

	case strings.EqualFold("InvalidReplacementTypeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementTypeException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidTargetBranchException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTargetBranchException(response, errorBody)

	case strings.EqualFold("ManualMergeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorManualMergeRequiredException(response, errorBody)

	case strings.EqualFold("MaximumConflictResolutionEntriesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumConflictResolutionEntriesExceededException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("MultipleConflictResolutionEntriesException", errorCode):
		return awsAwsjson11_deserializeErrorMultipleConflictResolutionEntriesException(response, errorBody)

	case strings.EqualFold("NameLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNameLengthExceededException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementContentRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementTypeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementTypeRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpMergePullRequestByFastForward struct {
}

func (*awsAwsjson11_deserializeOpMergePullRequestByFastForward) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpMergePullRequestByFastForward) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorMergePullRequestByFastForward(response, &metadata)
	}
	output := &MergePullRequestByFastForwardOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentMergePullRequestByFastForwardOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorMergePullRequestByFastForward(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ConcurrentReferenceUpdateException", errorCode):
		return awsAwsjson11_deserializeErrorConcurrentReferenceUpdateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("ManualMergeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorManualMergeRequiredException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestApprovalRulesNotSatisfiedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestApprovalRulesNotSatisfiedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("ReferenceDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorReferenceDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryNotAssociatedWithPullRequestException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNotAssociatedWithPullRequestException(response, errorBody)

	case strings.EqualFold("TipOfSourceReferenceIsDifferentException", errorCode):
		return awsAwsjson11_deserializeErrorTipOfSourceReferenceIsDifferentException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpMergePullRequestBySquash struct {
}

func (*awsAwsjson11_deserializeOpMergePullRequestBySquash) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpMergePullRequestBySquash) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorMergePullRequestBySquash(response, &metadata)
	}
	output := &MergePullRequestBySquashOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentMergePullRequestBySquashOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorMergePullRequestBySquash(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitMessageLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response, errorBody)

	case strings.EqualFold("ConcurrentReferenceUpdateException", errorCode):
		return awsAwsjson11_deserializeErrorConcurrentReferenceUpdateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("FolderContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFolderContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidEmailException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidEmailException(response, errorBody)

	case strings.EqualFold("InvalidFileModeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileModeException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidReplacementContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementContentException(response, errorBody)

	case strings.EqualFold("InvalidReplacementTypeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementTypeException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("ManualMergeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorManualMergeRequiredException(response, errorBody)

	case strings.EqualFold("MaximumConflictResolutionEntriesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumConflictResolutionEntriesExceededException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("MultipleConflictResolutionEntriesException", errorCode):
		return awsAwsjson11_deserializeErrorMultipleConflictResolutionEntriesException(response, errorBody)

	case strings.EqualFold("NameLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNameLengthExceededException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestApprovalRulesNotSatisfiedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestApprovalRulesNotSatisfiedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementContentRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementTypeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementTypeRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryNotAssociatedWithPullRequestException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNotAssociatedWithPullRequestException(response, errorBody)

	case strings.EqualFold("TipOfSourceReferenceIsDifferentException", errorCode):
		return awsAwsjson11_deserializeErrorTipOfSourceReferenceIsDifferentException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpMergePullRequestByThreeWay struct {
}

func (*awsAwsjson11_deserializeOpMergePullRequestByThreeWay) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpMergePullRequestByThreeWay) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorMergePullRequestByThreeWay(response, &metadata)
	}
	output := &MergePullRequestByThreeWayOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentMergePullRequestByThreeWayOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorMergePullRequestByThreeWay(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommitMessageLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response, errorBody)

	case strings.EqualFold("ConcurrentReferenceUpdateException", errorCode):
		return awsAwsjson11_deserializeErrorConcurrentReferenceUpdateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("FolderContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFolderContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidConflictDetailLevelException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionException(response, errorBody)

	case strings.EqualFold("InvalidConflictResolutionStrategyException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response, errorBody)

	case strings.EqualFold("InvalidEmailException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidEmailException(response, errorBody)

	case strings.EqualFold("InvalidFileModeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileModeException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidReplacementContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementContentException(response, errorBody)

	case strings.EqualFold("InvalidReplacementTypeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReplacementTypeException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("ManualMergeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorManualMergeRequiredException(response, errorBody)

	case strings.EqualFold("MaximumConflictResolutionEntriesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumConflictResolutionEntriesExceededException(response, errorBody)

	case strings.EqualFold("MaximumFileContentToLoadExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response, errorBody)

	case strings.EqualFold("MaximumItemsToCompareExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response, errorBody)

	case strings.EqualFold("MultipleConflictResolutionEntriesException", errorCode):
		return awsAwsjson11_deserializeErrorMultipleConflictResolutionEntriesException(response, errorBody)

	case strings.EqualFold("NameLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNameLengthExceededException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestApprovalRulesNotSatisfiedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestApprovalRulesNotSatisfiedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementContentRequiredException(response, errorBody)

	case strings.EqualFold("ReplacementTypeRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReplacementTypeRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryNotAssociatedWithPullRequestException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNotAssociatedWithPullRequestException(response, errorBody)

	case strings.EqualFold("TipOfSourceReferenceIsDifferentException", errorCode):
		return awsAwsjson11_deserializeErrorTipOfSourceReferenceIsDifferentException(response, errorBody)

	case strings.EqualFold("TipsDivergenceExceededException", errorCode):
		return awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpOverridePullRequestApprovalRules struct {
}

func (*awsAwsjson11_deserializeOpOverridePullRequestApprovalRules) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpOverridePullRequestApprovalRules) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorOverridePullRequestApprovalRules(response, &metadata)
	}
	output := &OverridePullRequestApprovalRulesOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorOverridePullRequestApprovalRules(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidOverrideStatusException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidOverrideStatusException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRevisionIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRevisionIdException(response, errorBody)

	case strings.EqualFold("OverrideAlreadySetException", errorCode):
		return awsAwsjson11_deserializeErrorOverrideAlreadySetException(response, errorBody)

	case strings.EqualFold("OverrideStatusRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorOverrideStatusRequiredException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("RevisionIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRevisionIdRequiredException(response, errorBody)

	case strings.EqualFold("RevisionNotCurrentException", errorCode):
		return awsAwsjson11_deserializeErrorRevisionNotCurrentException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpPostCommentForComparedCommit struct {
}

func (*awsAwsjson11_deserializeOpPostCommentForComparedCommit) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpPostCommentForComparedCommit) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorPostCommentForComparedCommit(response, &metadata)
	}
	output := &PostCommentForComparedCommitOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentPostCommentForComparedCommitOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorPostCommentForComparedCommit(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BeforeCommitIdAndAfterCommitIdAreSameException", errorCode):
		return awsAwsjson11_deserializeErrorBeforeCommitIdAndAfterCommitIdAreSameException(response, errorBody)

	case strings.EqualFold("ClientRequestTokenRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorClientRequestTokenRequiredException(response, errorBody)

	case strings.EqualFold("CommentContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentContentRequiredException(response, errorBody)

	case strings.EqualFold("CommentContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommentContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("IdempotencyParameterMismatchException", errorCode):
		return awsAwsjson11_deserializeErrorIdempotencyParameterMismatchException(response, errorBody)

	case strings.EqualFold("InvalidClientRequestTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidClientRequestTokenException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidFileLocationException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileLocationException(response, errorBody)

	case strings.EqualFold("InvalidFilePositionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFilePositionException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidRelativeFileVersionEnumException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRelativeFileVersionEnumException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("PathDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPathDoesNotExistException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpPostCommentForPullRequest struct {
}

func (*awsAwsjson11_deserializeOpPostCommentForPullRequest) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpPostCommentForPullRequest) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorPostCommentForPullRequest(response, &metadata)
	}
	output := &PostCommentForPullRequestOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentPostCommentForPullRequestOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorPostCommentForPullRequest(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BeforeCommitIdAndAfterCommitIdAreSameException", errorCode):
		return awsAwsjson11_deserializeErrorBeforeCommitIdAndAfterCommitIdAreSameException(response, errorBody)

	case strings.EqualFold("ClientRequestTokenRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorClientRequestTokenRequiredException(response, errorBody)

	case strings.EqualFold("CommentContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentContentRequiredException(response, errorBody)

	case strings.EqualFold("CommentContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommentContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("CommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("IdempotencyParameterMismatchException", errorCode):
		return awsAwsjson11_deserializeErrorIdempotencyParameterMismatchException(response, errorBody)

	case strings.EqualFold("InvalidClientRequestTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidClientRequestTokenException(response, errorBody)

	case strings.EqualFold("InvalidCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidFileLocationException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileLocationException(response, errorBody)

	case strings.EqualFold("InvalidFilePositionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFilePositionException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRelativeFileVersionEnumException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRelativeFileVersionEnumException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("PathDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPathDoesNotExistException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryNotAssociatedWithPullRequestException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNotAssociatedWithPullRequestException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpPostCommentReply struct {
}

func (*awsAwsjson11_deserializeOpPostCommentReply) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpPostCommentReply) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorPostCommentReply(response, &metadata)
	}
	output := &PostCommentReplyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentPostCommentReplyOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorPostCommentReply(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ClientRequestTokenRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorClientRequestTokenRequiredException(response, errorBody)

	case strings.EqualFold("CommentContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentContentRequiredException(response, errorBody)

	case strings.EqualFold("CommentContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommentContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("CommentDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommentIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentIdRequiredException(response, errorBody)

	case strings.EqualFold("IdempotencyParameterMismatchException", errorCode):
		return awsAwsjson11_deserializeErrorIdempotencyParameterMismatchException(response, errorBody)

	case strings.EqualFold("InvalidClientRequestTokenException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidClientRequestTokenException(response, errorBody)

	case strings.EqualFold("InvalidCommentIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommentIdException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpPutCommentReaction struct {
}

func (*awsAwsjson11_deserializeOpPutCommentReaction) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpPutCommentReaction) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorPutCommentReaction(response, &metadata)
	}
	output := &PutCommentReactionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorPutCommentReaction(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommentDeletedException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDeletedException(response, errorBody)

	case strings.EqualFold("CommentDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommentIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentIdRequiredException(response, errorBody)

	case strings.EqualFold("InvalidCommentIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommentIdException(response, errorBody)

	case strings.EqualFold("InvalidReactionValueException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidReactionValueException(response, errorBody)

	case strings.EqualFold("ReactionLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorReactionLimitExceededException(response, errorBody)

	case strings.EqualFold("ReactionValueRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorReactionValueRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpPutFile struct {
}

func (*awsAwsjson11_deserializeOpPutFile) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpPutFile) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorPutFile(response, &metadata)
	}
	output := &PutFileOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentPutFileOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorPutFile(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBranchDoesNotExistException(response, errorBody)

	case strings.EqualFold("BranchNameIsTagNameException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameIsTagNameException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("CommitMessageLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response, errorBody)

	case strings.EqualFold("DirectoryNameConflictsWithFileNameException", errorCode):
		return awsAwsjson11_deserializeErrorDirectoryNameConflictsWithFileNameException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("FileContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentRequiredException(response, errorBody)

	case strings.EqualFold("FileContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFileContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("FileNameConflictsWithDirectoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorFileNameConflictsWithDirectoryNameException(response, errorBody)

	case strings.EqualFold("FilePathConflictsWithSubmodulePathException", errorCode):
		return awsAwsjson11_deserializeErrorFilePathConflictsWithSubmodulePathException(response, errorBody)

	case strings.EqualFold("FolderContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorFolderContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidDeletionParameterException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidDeletionParameterException(response, errorBody)

	case strings.EqualFold("InvalidEmailException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidEmailException(response, errorBody)

	case strings.EqualFold("InvalidFileModeException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidFileModeException(response, errorBody)

	case strings.EqualFold("InvalidParentCommitIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidParentCommitIdException(response, errorBody)

	case strings.EqualFold("InvalidPathException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPathException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("NameLengthExceededException", errorCode):
		return awsAwsjson11_deserializeErrorNameLengthExceededException(response, errorBody)

	case strings.EqualFold("ParentCommitDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitDoesNotExistException(response, errorBody)

	case strings.EqualFold("ParentCommitIdOutdatedException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitIdOutdatedException(response, errorBody)

	case strings.EqualFold("ParentCommitIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorParentCommitIdRequiredException(response, errorBody)

	case strings.EqualFold("PathRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPathRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("SameFileContentException", errorCode):
		return awsAwsjson11_deserializeErrorSameFileContentException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpPutRepositoryTriggers struct {
}

func (*awsAwsjson11_deserializeOpPutRepositoryTriggers) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpPutRepositoryTriggers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorPutRepositoryTriggers(response, &metadata)
	}
	output := &PutRepositoryTriggersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentPutRepositoryTriggersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorPutRepositoryTriggers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerCustomDataException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerCustomDataException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerDestinationArnException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerDestinationArnException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerEventsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerEventsException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerRegionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerRegionException(response, errorBody)

	case strings.EqualFold("MaximumBranchesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumBranchesExceededException(response, errorBody)

	case strings.EqualFold("MaximumRepositoryTriggersExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumRepositoryTriggersExceededException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggerBranchNameListRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggerBranchNameListRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggerDestinationArnRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggerDestinationArnRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggerEventsListRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggerEventsListRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggerNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggerNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggersListRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggersListRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpTagResource struct {
}

func (*awsAwsjson11_deserializeOpTagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpTagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorTagResource(response, &metadata)
	}
	output := &TagResourceOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorTagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidResourceArnException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidResourceArnException(response, errorBody)

	case strings.EqualFold("InvalidSystemTagUsageException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidSystemTagUsageException(response, errorBody)

	case strings.EqualFold("InvalidTagsMapException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTagsMapException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("ResourceArnRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorResourceArnRequiredException(response, errorBody)

	case strings.EqualFold("TagPolicyException", errorCode):
		return awsAwsjson11_deserializeErrorTagPolicyException(response, errorBody)

	case strings.EqualFold("TagsMapRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorTagsMapRequiredException(response, errorBody)

	case strings.EqualFold("TooManyTagsException", errorCode):
		return awsAwsjson11_deserializeErrorTooManyTagsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpTestRepositoryTriggers struct {
}

func (*awsAwsjson11_deserializeOpTestRepositoryTriggers) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpTestRepositoryTriggers) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorTestRepositoryTriggers(response, &metadata)
	}
	output := &TestRepositoryTriggersOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentTestRepositoryTriggersOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorTestRepositoryTriggers(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerCustomDataException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerCustomDataException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerDestinationArnException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerDestinationArnException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerEventsException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerEventsException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryTriggerRegionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryTriggerRegionException(response, errorBody)

	case strings.EqualFold("MaximumBranchesExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumBranchesExceededException(response, errorBody)

	case strings.EqualFold("MaximumRepositoryTriggersExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumRepositoryTriggersExceededException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggerBranchNameListRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggerBranchNameListRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggerDestinationArnRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggerDestinationArnRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggerEventsListRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggerEventsListRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggerNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggerNameRequiredException(response, errorBody)

	case strings.EqualFold("RepositoryTriggersListRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryTriggersListRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUntagResource struct {
}

func (*awsAwsjson11_deserializeOpUntagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUntagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUntagResource(response, &metadata)
	}
	output := &UntagResourceOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUntagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("InvalidResourceArnException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidResourceArnException(response, errorBody)

	case strings.EqualFold("InvalidSystemTagUsageException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidSystemTagUsageException(response, errorBody)

	case strings.EqualFold("InvalidTagKeysListException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTagKeysListException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("ResourceArnRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorResourceArnRequiredException(response, errorBody)

	case strings.EqualFold("TagKeysListRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorTagKeysListRequiredException(response, errorBody)

	case strings.EqualFold("TagPolicyException", errorCode):
		return awsAwsjson11_deserializeErrorTagPolicyException(response, errorBody)

	case strings.EqualFold("TooManyTagsException", errorCode):
		return awsAwsjson11_deserializeErrorTooManyTagsException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateContent struct {
}

func (*awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateContent) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateContent) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdateApprovalRuleTemplateContent(response, &metadata)
	}
	output := &UpdateApprovalRuleTemplateContentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdateApprovalRuleTemplateContentOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdateApprovalRuleTemplateContent(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateContentRequiredException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateContentException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	case strings.EqualFold("InvalidRuleContentSha256Exception", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRuleContentSha256Exception(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateDescription struct {
}

func (*awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateDescription) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateDescription) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdateApprovalRuleTemplateDescription(response, &metadata)
	}
	output := &UpdateApprovalRuleTemplateDescriptionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdateApprovalRuleTemplateDescriptionOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdateApprovalRuleTemplateDescription(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateDescriptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateDescriptionException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateName struct {
}

func (*awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateName) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdateApprovalRuleTemplateName) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdateApprovalRuleTemplateName(response, &metadata)
	}
	output := &UpdateApprovalRuleTemplateNameOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdateApprovalRuleTemplateNameOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdateApprovalRuleTemplateName(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleTemplateDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameAlreadyExistsException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameAlreadyExistsException(response, errorBody)

	case strings.EqualFold("ApprovalRuleTemplateNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleTemplateNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdateComment struct {
}

func (*awsAwsjson11_deserializeOpUpdateComment) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdateComment) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdateComment(response, &metadata)
	}
	output := &UpdateCommentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdateCommentOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdateComment(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("CommentContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentContentRequiredException(response, errorBody)

	case strings.EqualFold("CommentContentSizeLimitExceededException", errorCode):
		return awsAwsjson11_deserializeErrorCommentContentSizeLimitExceededException(response, errorBody)

	case strings.EqualFold("CommentDeletedException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDeletedException(response, errorBody)

	case strings.EqualFold("CommentDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorCommentDoesNotExistException(response, errorBody)

	case strings.EqualFold("CommentIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorCommentIdRequiredException(response, errorBody)

	case strings.EqualFold("CommentNotCreatedByCallerException", errorCode):
		return awsAwsjson11_deserializeErrorCommentNotCreatedByCallerException(response, errorBody)

	case strings.EqualFold("InvalidCommentIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidCommentIdException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdateDefaultBranch struct {
}

func (*awsAwsjson11_deserializeOpUpdateDefaultBranch) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdateDefaultBranch) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdateDefaultBranch(response, &metadata)
	}
	output := &UpdateDefaultBranchOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdateDefaultBranch(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("BranchDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorBranchDoesNotExistException(response, errorBody)

	case strings.EqualFold("BranchNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorBranchNameRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidBranchNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidBranchNameException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdatePullRequestApprovalRuleContent struct {
}

func (*awsAwsjson11_deserializeOpUpdatePullRequestApprovalRuleContent) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdatePullRequestApprovalRuleContent) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdatePullRequestApprovalRuleContent(response, &metadata)
	}
	output := &UpdatePullRequestApprovalRuleContentOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdatePullRequestApprovalRuleContentOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdatePullRequestApprovalRuleContent(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalRuleContentRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleContentRequiredException(response, errorBody)

	case strings.EqualFold("ApprovalRuleDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleDoesNotExistException(response, errorBody)

	case strings.EqualFold("ApprovalRuleNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalRuleNameRequiredException(response, errorBody)

	case strings.EqualFold("CannotModifyApprovalRuleFromTemplateException", errorCode):
		return awsAwsjson11_deserializeErrorCannotModifyApprovalRuleFromTemplateException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleContentException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleContentException(response, errorBody)

	case strings.EqualFold("InvalidApprovalRuleNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalRuleNameException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRuleContentSha256Exception", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRuleContentSha256Exception(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdatePullRequestApprovalState struct {
}

func (*awsAwsjson11_deserializeOpUpdatePullRequestApprovalState) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdatePullRequestApprovalState) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdatePullRequestApprovalState(response, &metadata)
	}
	output := &UpdatePullRequestApprovalStateOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdatePullRequestApprovalState(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("ApprovalStateRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorApprovalStateRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidApprovalStateException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidApprovalStateException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidRevisionIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRevisionIdException(response, errorBody)

	case strings.EqualFold("MaximumNumberOfApprovalsExceededException", errorCode):
		return awsAwsjson11_deserializeErrorMaximumNumberOfApprovalsExceededException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestCannotBeApprovedByAuthorException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestCannotBeApprovedByAuthorException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("RevisionIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRevisionIdRequiredException(response, errorBody)

	case strings.EqualFold("RevisionNotCurrentException", errorCode):
		return awsAwsjson11_deserializeErrorRevisionNotCurrentException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdatePullRequestDescription struct {
}

func (*awsAwsjson11_deserializeOpUpdatePullRequestDescription) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdatePullRequestDescription) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdatePullRequestDescription(response, &metadata)
	}
	output := &UpdatePullRequestDescriptionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdatePullRequestDescriptionOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdatePullRequestDescription(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("InvalidDescriptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidDescriptionException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdatePullRequestStatus struct {
}

func (*awsAwsjson11_deserializeOpUpdatePullRequestStatus) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdatePullRequestStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdatePullRequestStatus(response, &metadata)
	}
	output := &UpdatePullRequestStatusOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdatePullRequestStatusOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdatePullRequestStatus(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestStatusException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestStatusException(response, errorBody)

	case strings.EqualFold("InvalidPullRequestStatusUpdateException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestStatusUpdateException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("PullRequestStatusRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestStatusRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdatePullRequestTitle struct {
}

func (*awsAwsjson11_deserializeOpUpdatePullRequestTitle) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdatePullRequestTitle) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdatePullRequestTitle(response, &metadata)
	}
	output := &UpdatePullRequestTitleOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdatePullRequestTitleOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdatePullRequestTitle(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("InvalidPullRequestIdException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response, errorBody)

	case strings.EqualFold("InvalidTitleException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidTitleException(response, errorBody)

	case strings.EqualFold("PullRequestAlreadyClosedException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response, errorBody)

	case strings.EqualFold("PullRequestDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response, errorBody)

	case strings.EqualFold("PullRequestIdRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response, errorBody)

	case strings.EqualFold("TitleRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorTitleRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdateRepositoryDescription struct {
}

func (*awsAwsjson11_deserializeOpUpdateRepositoryDescription) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdateRepositoryDescription) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdateRepositoryDescription(response, &metadata)
	}
	output := &UpdateRepositoryDescriptionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdateRepositoryDescription(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryDescriptionException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryDescriptionException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdateRepositoryEncryptionKey struct {
}

func (*awsAwsjson11_deserializeOpUpdateRepositoryEncryptionKey) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdateRepositoryEncryptionKey) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdateRepositoryEncryptionKey(response, &metadata)
	}
	output := &UpdateRepositoryEncryptionKeyOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson11_deserializeOpDocumentUpdateRepositoryEncryptionKeyOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdateRepositoryEncryptionKey(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("EncryptionIntegrityChecksFailedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyAccessDeniedException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response, errorBody)

	case strings.EqualFold("EncryptionKeyDisabledException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response, errorBody)

	case strings.EqualFold("EncryptionKeyInvalidIdException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyInvalidIdException(response, errorBody)

	case strings.EqualFold("EncryptionKeyInvalidUsageException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyInvalidUsageException(response, errorBody)

	case strings.EqualFold("EncryptionKeyNotFoundException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response, errorBody)

	case strings.EqualFold("EncryptionKeyRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyRequiredException(response, errorBody)

	case strings.EqualFold("EncryptionKeyUnavailableException", errorCode):
		return awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response, errorBody)

	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson11_deserializeOpUpdateRepositoryName struct {
}

func (*awsAwsjson11_deserializeOpUpdateRepositoryName) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson11_deserializeOpUpdateRepositoryName) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()
	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson11_deserializeOpErrorUpdateRepositoryName(response, &metadata)
	}
	output := &UpdateRepositoryNameOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson11_deserializeOpErrorUpdateRepositoryName(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("InvalidRepositoryNameException", errorCode):
		return awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response, errorBody)

	case strings.EqualFold("RepositoryDoesNotExistException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response, errorBody)

	case strings.EqualFold("RepositoryNameExistsException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameExistsException(response, errorBody)

	case strings.EqualFold("RepositoryNameRequiredException", errorCode):
		return awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsAwsjson11_deserializeErrorActorDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ActorDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentActorDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleContentRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleContentRequiredException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleContentRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleNameAlreadyExistsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleNameAlreadyExistsException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleNameAlreadyExistsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleNameRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleNameRequiredException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleNameRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleTemplateContentRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleTemplateContentRequiredException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleTemplateContentRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleTemplateDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleTemplateDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleTemplateDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleTemplateInUseException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleTemplateInUseException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleTemplateInUseException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleTemplateNameAlreadyExistsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleTemplateNameAlreadyExistsException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleTemplateNameAlreadyExistsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalRuleTemplateNameRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalRuleTemplateNameRequiredException{}
	err := awsAwsjson11_deserializeDocumentApprovalRuleTemplateNameRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorApprovalStateRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ApprovalStateRequiredException{}
	err := awsAwsjson11_deserializeDocumentApprovalStateRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorAuthorDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.AuthorDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentAuthorDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorBeforeCommitIdAndAfterCommitIdAreSameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.BeforeCommitIdAndAfterCommitIdAreSameException{}
	err := awsAwsjson11_deserializeDocumentBeforeCommitIdAndAfterCommitIdAreSameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorBlobIdDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.BlobIdDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentBlobIdDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorBlobIdRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.BlobIdRequiredException{}
	err := awsAwsjson11_deserializeDocumentBlobIdRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorBranchDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.BranchDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentBranchDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorBranchNameExistsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.BranchNameExistsException{}
	err := awsAwsjson11_deserializeDocumentBranchNameExistsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorBranchNameIsTagNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.BranchNameIsTagNameException{}
	err := awsAwsjson11_deserializeDocumentBranchNameIsTagNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorBranchNameRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.BranchNameRequiredException{}
	err := awsAwsjson11_deserializeDocumentBranchNameRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCannotDeleteApprovalRuleFromTemplateException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CannotDeleteApprovalRuleFromTemplateException{}
	err := awsAwsjson11_deserializeDocumentCannotDeleteApprovalRuleFromTemplateException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCannotModifyApprovalRuleFromTemplateException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CannotModifyApprovalRuleFromTemplateException{}
	err := awsAwsjson11_deserializeDocumentCannotModifyApprovalRuleFromTemplateException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorClientRequestTokenRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ClientRequestTokenRequiredException{}
	err := awsAwsjson11_deserializeDocumentClientRequestTokenRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommentContentRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommentContentRequiredException{}
	err := awsAwsjson11_deserializeDocumentCommentContentRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommentContentSizeLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommentContentSizeLimitExceededException{}
	err := awsAwsjson11_deserializeDocumentCommentContentSizeLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommentDeletedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommentDeletedException{}
	err := awsAwsjson11_deserializeDocumentCommentDeletedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommentDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommentDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentCommentDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommentIdRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommentIdRequiredException{}
	err := awsAwsjson11_deserializeDocumentCommentIdRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommentNotCreatedByCallerException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommentNotCreatedByCallerException{}
	err := awsAwsjson11_deserializeDocumentCommentNotCreatedByCallerException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommitDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommitDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentCommitDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommitIdDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommitIdDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentCommitIdDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommitIdRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommitIdRequiredException{}
	err := awsAwsjson11_deserializeDocumentCommitIdRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommitIdsLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommitIdsLimitExceededException{}
	err := awsAwsjson11_deserializeDocumentCommitIdsLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommitIdsListRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommitIdsListRequiredException{}
	err := awsAwsjson11_deserializeDocumentCommitIdsListRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommitMessageLengthExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommitMessageLengthExceededException{}
	err := awsAwsjson11_deserializeDocumentCommitMessageLengthExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorCommitRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.CommitRequiredException{}
	err := awsAwsjson11_deserializeDocumentCommitRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorConcurrentReferenceUpdateException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ConcurrentReferenceUpdateException{}
	err := awsAwsjson11_deserializeDocumentConcurrentReferenceUpdateException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorDefaultBranchCannotBeDeletedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.DefaultBranchCannotBeDeletedException{}
	err := awsAwsjson11_deserializeDocumentDefaultBranchCannotBeDeletedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorDirectoryNameConflictsWithFileNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.DirectoryNameConflictsWithFileNameException{}
	err := awsAwsjson11_deserializeDocumentDirectoryNameConflictsWithFileNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorEncryptionIntegrityChecksFailedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.EncryptionIntegrityChecksFailedException{}
	err := awsAwsjson11_deserializeDocumentEncryptionIntegrityChecksFailedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorEncryptionKeyAccessDeniedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.EncryptionKeyAccessDeniedException{}
	err := awsAwsjson11_deserializeDocumentEncryptionKeyAccessDeniedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorEncryptionKeyDisabledException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.EncryptionKeyDisabledException{}
	err := awsAwsjson11_deserializeDocumentEncryptionKeyDisabledException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorEncryptionKeyInvalidIdException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.EncryptionKeyInvalidIdException{}
	err := awsAwsjson11_deserializeDocumentEncryptionKeyInvalidIdException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorEncryptionKeyInvalidUsageException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.EncryptionKeyInvalidUsageException{}
	err := awsAwsjson11_deserializeDocumentEncryptionKeyInvalidUsageException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorEncryptionKeyNotFoundException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.EncryptionKeyNotFoundException{}
	err := awsAwsjson11_deserializeDocumentEncryptionKeyNotFoundException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorEncryptionKeyRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.EncryptionKeyRequiredException{}
	err := awsAwsjson11_deserializeDocumentEncryptionKeyRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorEncryptionKeyUnavailableException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.EncryptionKeyUnavailableException{}
	err := awsAwsjson11_deserializeDocumentEncryptionKeyUnavailableException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFileContentAndSourceFileSpecifiedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FileContentAndSourceFileSpecifiedException{}
	err := awsAwsjson11_deserializeDocumentFileContentAndSourceFileSpecifiedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFileContentRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FileContentRequiredException{}
	err := awsAwsjson11_deserializeDocumentFileContentRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFileContentSizeLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FileContentSizeLimitExceededException{}
	err := awsAwsjson11_deserializeDocumentFileContentSizeLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFileDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FileDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentFileDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFileEntryRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FileEntryRequiredException{}
	err := awsAwsjson11_deserializeDocumentFileEntryRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFileModeRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FileModeRequiredException{}
	err := awsAwsjson11_deserializeDocumentFileModeRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFileNameConflictsWithDirectoryNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FileNameConflictsWithDirectoryNameException{}
	err := awsAwsjson11_deserializeDocumentFileNameConflictsWithDirectoryNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFilePathConflictsWithSubmodulePathException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FilePathConflictsWithSubmodulePathException{}
	err := awsAwsjson11_deserializeDocumentFilePathConflictsWithSubmodulePathException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFileTooLargeException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FileTooLargeException{}
	err := awsAwsjson11_deserializeDocumentFileTooLargeException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFolderContentSizeLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FolderContentSizeLimitExceededException{}
	err := awsAwsjson11_deserializeDocumentFolderContentSizeLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorFolderDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.FolderDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentFolderDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorIdempotencyParameterMismatchException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.IdempotencyParameterMismatchException{}
	err := awsAwsjson11_deserializeDocumentIdempotencyParameterMismatchException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidActorArnException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidActorArnException{}
	err := awsAwsjson11_deserializeDocumentInvalidActorArnException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidApprovalRuleContentException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidApprovalRuleContentException{}
	err := awsAwsjson11_deserializeDocumentInvalidApprovalRuleContentException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidApprovalRuleNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidApprovalRuleNameException{}
	err := awsAwsjson11_deserializeDocumentInvalidApprovalRuleNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateContentException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidApprovalRuleTemplateContentException{}
	err := awsAwsjson11_deserializeDocumentInvalidApprovalRuleTemplateContentException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateDescriptionException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidApprovalRuleTemplateDescriptionException{}
	err := awsAwsjson11_deserializeDocumentInvalidApprovalRuleTemplateDescriptionException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidApprovalRuleTemplateNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidApprovalRuleTemplateNameException{}
	err := awsAwsjson11_deserializeDocumentInvalidApprovalRuleTemplateNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidApprovalStateException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidApprovalStateException{}
	err := awsAwsjson11_deserializeDocumentInvalidApprovalStateException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidAuthorArnException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidAuthorArnException{}
	err := awsAwsjson11_deserializeDocumentInvalidAuthorArnException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidBlobIdException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidBlobIdException{}
	err := awsAwsjson11_deserializeDocumentInvalidBlobIdException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidBranchNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidBranchNameException{}
	err := awsAwsjson11_deserializeDocumentInvalidBranchNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidClientRequestTokenException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidClientRequestTokenException{}
	err := awsAwsjson11_deserializeDocumentInvalidClientRequestTokenException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidCommentIdException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidCommentIdException{}
	err := awsAwsjson11_deserializeDocumentInvalidCommentIdException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidCommitException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidCommitException{}
	err := awsAwsjson11_deserializeDocumentInvalidCommitException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidCommitIdException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidCommitIdException{}
	err := awsAwsjson11_deserializeDocumentInvalidCommitIdException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidConflictDetailLevelException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidConflictDetailLevelException{}
	err := awsAwsjson11_deserializeDocumentInvalidConflictDetailLevelException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidConflictResolutionException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidConflictResolutionException{}
	err := awsAwsjson11_deserializeDocumentInvalidConflictResolutionException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidConflictResolutionStrategyException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidConflictResolutionStrategyException{}
	err := awsAwsjson11_deserializeDocumentInvalidConflictResolutionStrategyException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidContinuationTokenException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidContinuationTokenException{}
	err := awsAwsjson11_deserializeDocumentInvalidContinuationTokenException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidDeletionParameterException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidDeletionParameterException{}
	err := awsAwsjson11_deserializeDocumentInvalidDeletionParameterException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidDescriptionException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidDescriptionException{}
	err := awsAwsjson11_deserializeDocumentInvalidDescriptionException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidDestinationCommitSpecifierException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidDestinationCommitSpecifierException{}
	err := awsAwsjson11_deserializeDocumentInvalidDestinationCommitSpecifierException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidEmailException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidEmailException{}
	err := awsAwsjson11_deserializeDocumentInvalidEmailException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidFileLocationException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidFileLocationException{}
	err := awsAwsjson11_deserializeDocumentInvalidFileLocationException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidFileModeException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidFileModeException{}
	err := awsAwsjson11_deserializeDocumentInvalidFileModeException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidFilePositionException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidFilePositionException{}
	err := awsAwsjson11_deserializeDocumentInvalidFilePositionException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidMaxConflictFilesException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidMaxConflictFilesException{}
	err := awsAwsjson11_deserializeDocumentInvalidMaxConflictFilesException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidMaxMergeHunksException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidMaxMergeHunksException{}
	err := awsAwsjson11_deserializeDocumentInvalidMaxMergeHunksException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidMaxResultsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidMaxResultsException{}
	err := awsAwsjson11_deserializeDocumentInvalidMaxResultsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidMergeOptionException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidMergeOptionException{}
	err := awsAwsjson11_deserializeDocumentInvalidMergeOptionException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidOrderException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidOrderException{}
	err := awsAwsjson11_deserializeDocumentInvalidOrderException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidOverrideStatusException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidOverrideStatusException{}
	err := awsAwsjson11_deserializeDocumentInvalidOverrideStatusException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidParentCommitIdException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidParentCommitIdException{}
	err := awsAwsjson11_deserializeDocumentInvalidParentCommitIdException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidPathException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidPathException{}
	err := awsAwsjson11_deserializeDocumentInvalidPathException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidPullRequestEventTypeException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidPullRequestEventTypeException{}
	err := awsAwsjson11_deserializeDocumentInvalidPullRequestEventTypeException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidPullRequestIdException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidPullRequestIdException{}
	err := awsAwsjson11_deserializeDocumentInvalidPullRequestIdException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidPullRequestStatusException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidPullRequestStatusException{}
	err := awsAwsjson11_deserializeDocumentInvalidPullRequestStatusException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidPullRequestStatusUpdateException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidPullRequestStatusUpdateException{}
	err := awsAwsjson11_deserializeDocumentInvalidPullRequestStatusUpdateException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidReactionUserArnException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidReactionUserArnException{}
	err := awsAwsjson11_deserializeDocumentInvalidReactionUserArnException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidReactionValueException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidReactionValueException{}
	err := awsAwsjson11_deserializeDocumentInvalidReactionValueException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidReferenceNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidReferenceNameException{}
	err := awsAwsjson11_deserializeDocumentInvalidReferenceNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRelativeFileVersionEnumException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRelativeFileVersionEnumException{}
	err := awsAwsjson11_deserializeDocumentInvalidRelativeFileVersionEnumException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidReplacementContentException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidReplacementContentException{}
	err := awsAwsjson11_deserializeDocumentInvalidReplacementContentException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidReplacementTypeException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidReplacementTypeException{}
	err := awsAwsjson11_deserializeDocumentInvalidReplacementTypeException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRepositoryDescriptionException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRepositoryDescriptionException{}
	err := awsAwsjson11_deserializeDocumentInvalidRepositoryDescriptionException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRepositoryNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRepositoryNameException{}
	err := awsAwsjson11_deserializeDocumentInvalidRepositoryNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRepositoryTriggerBranchNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRepositoryTriggerBranchNameException{}
	err := awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerBranchNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRepositoryTriggerCustomDataException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRepositoryTriggerCustomDataException{}
	err := awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerCustomDataException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRepositoryTriggerDestinationArnException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRepositoryTriggerDestinationArnException{}
	err := awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerDestinationArnException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRepositoryTriggerEventsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRepositoryTriggerEventsException{}
	err := awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerEventsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRepositoryTriggerNameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRepositoryTriggerNameException{}
	err := awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerNameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRepositoryTriggerRegionException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRepositoryTriggerRegionException{}
	err := awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerRegionException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidResourceArnException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidResourceArnException{}
	err := awsAwsjson11_deserializeDocumentInvalidResourceArnException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRevisionIdException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRevisionIdException{}
	err := awsAwsjson11_deserializeDocumentInvalidRevisionIdException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidRuleContentSha256Exception(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidRuleContentSha256Exception{}
	err := awsAwsjson11_deserializeDocumentInvalidRuleContentSha256Exception(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidSortByException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidSortByException{}
	err := awsAwsjson11_deserializeDocumentInvalidSortByException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidSourceCommitSpecifierException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidSourceCommitSpecifierException{}
	err := awsAwsjson11_deserializeDocumentInvalidSourceCommitSpecifierException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidSystemTagUsageException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidSystemTagUsageException{}
	err := awsAwsjson11_deserializeDocumentInvalidSystemTagUsageException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidTagKeysListException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidTagKeysListException{}
	err := awsAwsjson11_deserializeDocumentInvalidTagKeysListException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidTagsMapException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidTagsMapException{}
	err := awsAwsjson11_deserializeDocumentInvalidTagsMapException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidTargetBranchException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidTargetBranchException{}
	err := awsAwsjson11_deserializeDocumentInvalidTargetBranchException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidTargetException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidTargetException{}
	err := awsAwsjson11_deserializeDocumentInvalidTargetException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidTargetsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidTargetsException{}
	err := awsAwsjson11_deserializeDocumentInvalidTargetsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorInvalidTitleException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.InvalidTitleException{}
	err := awsAwsjson11_deserializeDocumentInvalidTitleException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorManualMergeRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ManualMergeRequiredException{}
	err := awsAwsjson11_deserializeDocumentManualMergeRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumBranchesExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumBranchesExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumBranchesExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumConflictResolutionEntriesExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumConflictResolutionEntriesExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumConflictResolutionEntriesExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumFileContentToLoadExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumFileContentToLoadExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumFileContentToLoadExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumFileEntriesExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumFileEntriesExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumFileEntriesExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumItemsToCompareExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumItemsToCompareExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumItemsToCompareExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumNumberOfApprovalsExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumNumberOfApprovalsExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumNumberOfApprovalsExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumOpenPullRequestsExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumOpenPullRequestsExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumOpenPullRequestsExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumRepositoryNamesExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumRepositoryNamesExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumRepositoryNamesExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumRepositoryTriggersExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumRepositoryTriggersExceededException{}
	err := awsAwsjson11_deserializeDocumentMaximumRepositoryTriggersExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMaximumRuleTemplatesAssociatedWithRepositoryException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MaximumRuleTemplatesAssociatedWithRepositoryException{}
	err := awsAwsjson11_deserializeDocumentMaximumRuleTemplatesAssociatedWithRepositoryException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMergeOptionRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MergeOptionRequiredException{}
	err := awsAwsjson11_deserializeDocumentMergeOptionRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMultipleConflictResolutionEntriesException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MultipleConflictResolutionEntriesException{}
	err := awsAwsjson11_deserializeDocumentMultipleConflictResolutionEntriesException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorMultipleRepositoriesInPullRequestException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.MultipleRepositoriesInPullRequestException{}
	err := awsAwsjson11_deserializeDocumentMultipleRepositoriesInPullRequestException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorNameLengthExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.NameLengthExceededException{}
	err := awsAwsjson11_deserializeDocumentNameLengthExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorNoChangeException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.NoChangeException{}
	err := awsAwsjson11_deserializeDocumentNoChangeException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorNumberOfRulesExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.NumberOfRulesExceededException{}
	err := awsAwsjson11_deserializeDocumentNumberOfRulesExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorNumberOfRuleTemplatesExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.NumberOfRuleTemplatesExceededException{}
	err := awsAwsjson11_deserializeDocumentNumberOfRuleTemplatesExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorOperationNotAllowedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.OperationNotAllowedException{}
	err := awsAwsjson11_deserializeDocumentOperationNotAllowedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorOverrideAlreadySetException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.OverrideAlreadySetException{}
	err := awsAwsjson11_deserializeDocumentOverrideAlreadySetException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorOverrideStatusRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.OverrideStatusRequiredException{}
	err := awsAwsjson11_deserializeDocumentOverrideStatusRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorParentCommitDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ParentCommitDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentParentCommitDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorParentCommitIdOutdatedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ParentCommitIdOutdatedException{}
	err := awsAwsjson11_deserializeDocumentParentCommitIdOutdatedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorParentCommitIdRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ParentCommitIdRequiredException{}
	err := awsAwsjson11_deserializeDocumentParentCommitIdRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPathDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PathDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentPathDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPathRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PathRequiredException{}
	err := awsAwsjson11_deserializeDocumentPathRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPullRequestAlreadyClosedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PullRequestAlreadyClosedException{}
	err := awsAwsjson11_deserializeDocumentPullRequestAlreadyClosedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPullRequestApprovalRulesNotSatisfiedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PullRequestApprovalRulesNotSatisfiedException{}
	err := awsAwsjson11_deserializeDocumentPullRequestApprovalRulesNotSatisfiedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPullRequestCannotBeApprovedByAuthorException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PullRequestCannotBeApprovedByAuthorException{}
	err := awsAwsjson11_deserializeDocumentPullRequestCannotBeApprovedByAuthorException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPullRequestDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PullRequestDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentPullRequestDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPullRequestIdRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PullRequestIdRequiredException{}
	err := awsAwsjson11_deserializeDocumentPullRequestIdRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPullRequestStatusRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PullRequestStatusRequiredException{}
	err := awsAwsjson11_deserializeDocumentPullRequestStatusRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorPutFileEntryConflictException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.PutFileEntryConflictException{}
	err := awsAwsjson11_deserializeDocumentPutFileEntryConflictException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorReactionLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ReactionLimitExceededException{}
	err := awsAwsjson11_deserializeDocumentReactionLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorReactionValueRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ReactionValueRequiredException{}
	err := awsAwsjson11_deserializeDocumentReactionValueRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorReferenceDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ReferenceDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentReferenceDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorReferenceNameRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ReferenceNameRequiredException{}
	err := awsAwsjson11_deserializeDocumentReferenceNameRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorReferenceTypeNotSupportedException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ReferenceTypeNotSupportedException{}
	err := awsAwsjson11_deserializeDocumentReferenceTypeNotSupportedException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorReplacementContentRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ReplacementContentRequiredException{}
	err := awsAwsjson11_deserializeDocumentReplacementContentRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorReplacementTypeRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ReplacementTypeRequiredException{}
	err := awsAwsjson11_deserializeDocumentReplacementTypeRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryDoesNotExistException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryDoesNotExistException{}
	err := awsAwsjson11_deserializeDocumentRepositoryDoesNotExistException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryLimitExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryLimitExceededException{}
	err := awsAwsjson11_deserializeDocumentRepositoryLimitExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryNameExistsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryNameExistsException{}
	err := awsAwsjson11_deserializeDocumentRepositoryNameExistsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryNameRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryNameRequiredException{}
	err := awsAwsjson11_deserializeDocumentRepositoryNameRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryNamesRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryNamesRequiredException{}
	err := awsAwsjson11_deserializeDocumentRepositoryNamesRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryNotAssociatedWithPullRequestException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryNotAssociatedWithPullRequestException{}
	err := awsAwsjson11_deserializeDocumentRepositoryNotAssociatedWithPullRequestException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryTriggerBranchNameListRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryTriggerBranchNameListRequiredException{}
	err := awsAwsjson11_deserializeDocumentRepositoryTriggerBranchNameListRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryTriggerDestinationArnRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryTriggerDestinationArnRequiredException{}
	err := awsAwsjson11_deserializeDocumentRepositoryTriggerDestinationArnRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryTriggerEventsListRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryTriggerEventsListRequiredException{}
	err := awsAwsjson11_deserializeDocumentRepositoryTriggerEventsListRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryTriggerNameRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryTriggerNameRequiredException{}
	err := awsAwsjson11_deserializeDocumentRepositoryTriggerNameRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRepositoryTriggersListRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RepositoryTriggersListRequiredException{}
	err := awsAwsjson11_deserializeDocumentRepositoryTriggersListRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorResourceArnRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.ResourceArnRequiredException{}
	err := awsAwsjson11_deserializeDocumentResourceArnRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRestrictedSourceFileException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RestrictedSourceFileException{}
	err := awsAwsjson11_deserializeDocumentRestrictedSourceFileException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRevisionIdRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RevisionIdRequiredException{}
	err := awsAwsjson11_deserializeDocumentRevisionIdRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorRevisionNotCurrentException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.RevisionNotCurrentException{}
	err := awsAwsjson11_deserializeDocumentRevisionNotCurrentException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorSameFileContentException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.SameFileContentException{}
	err := awsAwsjson11_deserializeDocumentSameFileContentException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorSamePathRequestException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.SamePathRequestException{}
	err := awsAwsjson11_deserializeDocumentSamePathRequestException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorSourceAndDestinationAreSameException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.SourceAndDestinationAreSameException{}
	err := awsAwsjson11_deserializeDocumentSourceAndDestinationAreSameException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorSourceFileOrContentRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.SourceFileOrContentRequiredException{}
	err := awsAwsjson11_deserializeDocumentSourceFileOrContentRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTagKeysListRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TagKeysListRequiredException{}
	err := awsAwsjson11_deserializeDocumentTagKeysListRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTagPolicyException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TagPolicyException{}
	err := awsAwsjson11_deserializeDocumentTagPolicyException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTagsMapRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TagsMapRequiredException{}
	err := awsAwsjson11_deserializeDocumentTagsMapRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTargetRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TargetRequiredException{}
	err := awsAwsjson11_deserializeDocumentTargetRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTargetsRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TargetsRequiredException{}
	err := awsAwsjson11_deserializeDocumentTargetsRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTipOfSourceReferenceIsDifferentException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TipOfSourceReferenceIsDifferentException{}
	err := awsAwsjson11_deserializeDocumentTipOfSourceReferenceIsDifferentException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTipsDivergenceExceededException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TipsDivergenceExceededException{}
	err := awsAwsjson11_deserializeDocumentTipsDivergenceExceededException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTitleRequiredException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TitleRequiredException{}
	err := awsAwsjson11_deserializeDocumentTitleRequiredException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeErrorTooManyTagsException(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TooManyTagsException{}
	err := awsAwsjson11_deserializeDocumentTooManyTagsException(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson11_deserializeDocumentActorDoesNotExistException(v **types.ActorDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActorDoesNotExistException
	if *v == nil {
		sv = &types.ActorDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApproval(v **types.Approval, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Approval
	if *v == nil {
		sv = &types.Approval{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalState":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalState to be of type string, got %T instead", value)
				}
				sv.ApprovalState = types.ApprovalState(jtv)
			}

		case "userArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.UserArn = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalList(v *[]types.Approval, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Approval
	if *v == nil {
		cv = []types.Approval{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Approval
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentApproval(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRule(v **types.ApprovalRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRule
	if *v == nil {
		sv = &types.ApprovalRule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleContent":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleContent to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleContent = ptr.String(jtv)
			}

		case "approvalRuleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleId to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleId = ptr.String(jtv)
			}

		case "approvalRuleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleName to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleName = ptr.String(jtv)
			}

		case "creationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected CreationDate to be a JSON Number, got %T instead", value)

				}
			}

		case "lastModifiedDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastModifiedDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastModifiedDate to be a JSON Number, got %T instead", value)

				}
			}

		case "lastModifiedUser":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.LastModifiedUser = ptr.String(jtv)
			}

		case "originApprovalRuleTemplate":
			if err := awsAwsjson11_deserializeDocumentOriginApprovalRuleTemplate(&sv.OriginApprovalRuleTemplate, value); err != nil {
				return err
			}

		case "ruleContentSha256":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RuleContentSha256 to be of type string, got %T instead", value)
				}
				sv.RuleContentSha256 = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleContentRequiredException(v **types.ApprovalRuleContentRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleContentRequiredException
	if *v == nil {
		sv = &types.ApprovalRuleContentRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleDoesNotExistException(v **types.ApprovalRuleDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleDoesNotExistException
	if *v == nil {
		sv = &types.ApprovalRuleDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleEventMetadata(v **types.ApprovalRuleEventMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleEventMetadata
	if *v == nil {
		sv = &types.ApprovalRuleEventMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleContent":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleContent to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleContent = ptr.String(jtv)
			}

		case "approvalRuleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleId to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleId = ptr.String(jtv)
			}

		case "approvalRuleName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleName to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleNameAlreadyExistsException(v **types.ApprovalRuleNameAlreadyExistsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleNameAlreadyExistsException
	if *v == nil {
		sv = &types.ApprovalRuleNameAlreadyExistsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleNameRequiredException(v **types.ApprovalRuleNameRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleNameRequiredException
	if *v == nil {
		sv = &types.ApprovalRuleNameRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleOverriddenEventMetadata(v **types.ApprovalRuleOverriddenEventMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleOverriddenEventMetadata
	if *v == nil {
		sv = &types.ApprovalRuleOverriddenEventMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "overrideStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected OverrideStatus to be of type string, got %T instead", value)
				}
				sv.OverrideStatus = types.OverrideStatus(jtv)
			}

		case "revisionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RevisionId to be of type string, got %T instead", value)
				}
				sv.RevisionId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRulesList(v *[]types.ApprovalRule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ApprovalRule
	if *v == nil {
		cv = []types.ApprovalRule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ApprovalRule
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentApprovalRule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRulesNotSatisfiedList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected ApprovalRuleName to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRulesSatisfiedList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected ApprovalRuleName to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleTemplate(v **types.ApprovalRuleTemplate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleTemplate
	if *v == nil {
		sv = &types.ApprovalRuleTemplate{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplateContent":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleTemplateContent to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleTemplateContent = ptr.String(jtv)
			}

		case "approvalRuleTemplateDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleTemplateDescription to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleTemplateDescription = ptr.String(jtv)
			}

		case "approvalRuleTemplateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleTemplateId to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleTemplateId = ptr.String(jtv)
			}

		case "approvalRuleTemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleTemplateName to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleTemplateName = ptr.String(jtv)
			}

		case "creationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected CreationDate to be a JSON Number, got %T instead", value)

				}
			}

		case "lastModifiedDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastModifiedDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastModifiedDate to be a JSON Number, got %T instead", value)

				}
			}

		case "lastModifiedUser":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.LastModifiedUser = ptr.String(jtv)
			}

		case "ruleContentSha256":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RuleContentSha256 to be of type string, got %T instead", value)
				}
				sv.RuleContentSha256 = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleTemplateContentRequiredException(v **types.ApprovalRuleTemplateContentRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleTemplateContentRequiredException
	if *v == nil {
		sv = &types.ApprovalRuleTemplateContentRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleTemplateDoesNotExistException(v **types.ApprovalRuleTemplateDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleTemplateDoesNotExistException
	if *v == nil {
		sv = &types.ApprovalRuleTemplateDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleTemplateInUseException(v **types.ApprovalRuleTemplateInUseException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleTemplateInUseException
	if *v == nil {
		sv = &types.ApprovalRuleTemplateInUseException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleTemplateNameAlreadyExistsException(v **types.ApprovalRuleTemplateNameAlreadyExistsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleTemplateNameAlreadyExistsException
	if *v == nil {
		sv = &types.ApprovalRuleTemplateNameAlreadyExistsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleTemplateNameList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected ApprovalRuleTemplateName to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalRuleTemplateNameRequiredException(v **types.ApprovalRuleTemplateNameRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalRuleTemplateNameRequiredException
	if *v == nil {
		sv = &types.ApprovalRuleTemplateNameRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalStateChangedEventMetadata(v **types.ApprovalStateChangedEventMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalStateChangedEventMetadata
	if *v == nil {
		sv = &types.ApprovalStateChangedEventMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalState to be of type string, got %T instead", value)
				}
				sv.ApprovalStatus = types.ApprovalState(jtv)
			}

		case "revisionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RevisionId to be of type string, got %T instead", value)
				}
				sv.RevisionId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentApprovalStateRequiredException(v **types.ApprovalStateRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ApprovalStateRequiredException
	if *v == nil {
		sv = &types.ApprovalStateRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentAuthorDoesNotExistException(v **types.AuthorDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.AuthorDoesNotExistException
	if *v == nil {
		sv = &types.AuthorDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchAssociateApprovalRuleTemplateWithRepositoriesError(v **types.BatchAssociateApprovalRuleTemplateWithRepositoriesError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BatchAssociateApprovalRuleTemplateWithRepositoriesError
	if *v == nil {
		sv = &types.BatchAssociateApprovalRuleTemplateWithRepositoriesError{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "errorCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorCode to be of type string, got %T instead", value)
				}
				sv.ErrorCode = ptr.String(jtv)
			}

		case "errorMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.ErrorMessage = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchAssociateApprovalRuleTemplateWithRepositoriesErrorsList(v *[]types.BatchAssociateApprovalRuleTemplateWithRepositoriesError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.BatchAssociateApprovalRuleTemplateWithRepositoriesError
	if *v == nil {
		cv = []types.BatchAssociateApprovalRuleTemplateWithRepositoriesError{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.BatchAssociateApprovalRuleTemplateWithRepositoriesError
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentBatchAssociateApprovalRuleTemplateWithRepositoriesError(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchDescribeMergeConflictsError(v **types.BatchDescribeMergeConflictsError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BatchDescribeMergeConflictsError
	if *v == nil {
		sv = &types.BatchDescribeMergeConflictsError{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "exceptionName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ExceptionName to be of type string, got %T instead", value)
				}
				sv.ExceptionName = ptr.String(jtv)
			}

		case "filePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.FilePath = ptr.String(jtv)
			}

		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchDescribeMergeConflictsErrors(v *[]types.BatchDescribeMergeConflictsError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.BatchDescribeMergeConflictsError
	if *v == nil {
		cv = []types.BatchDescribeMergeConflictsError{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.BatchDescribeMergeConflictsError
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentBatchDescribeMergeConflictsError(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchDisassociateApprovalRuleTemplateFromRepositoriesError(v **types.BatchDisassociateApprovalRuleTemplateFromRepositoriesError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
	if *v == nil {
		sv = &types.BatchDisassociateApprovalRuleTemplateFromRepositoriesError{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "errorCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorCode to be of type string, got %T instead", value)
				}
				sv.ErrorCode = ptr.String(jtv)
			}

		case "errorMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.ErrorMessage = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsList(v *[]types.BatchDisassociateApprovalRuleTemplateFromRepositoriesError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
	if *v == nil {
		cv = []types.BatchDisassociateApprovalRuleTemplateFromRepositoriesError{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.BatchDisassociateApprovalRuleTemplateFromRepositoriesError
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentBatchDisassociateApprovalRuleTemplateFromRepositoriesError(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchGetCommitsError(v **types.BatchGetCommitsError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BatchGetCommitsError
	if *v == nil {
		sv = &types.BatchGetCommitsError{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "errorCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorCode to be of type string, got %T instead", value)
				}
				sv.ErrorCode = ptr.String(jtv)
			}

		case "errorMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.ErrorMessage = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchGetCommitsErrorsList(v *[]types.BatchGetCommitsError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.BatchGetCommitsError
	if *v == nil {
		cv = []types.BatchGetCommitsError{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.BatchGetCommitsError
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentBatchGetCommitsError(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchGetRepositoriesError(v **types.BatchGetRepositoriesError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BatchGetRepositoriesError
	if *v == nil {
		sv = &types.BatchGetRepositoriesError{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "errorCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected BatchGetRepositoriesErrorCodeEnum to be of type string, got %T instead", value)
				}
				sv.ErrorCode = types.BatchGetRepositoriesErrorCodeEnum(jtv)
			}

		case "errorMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.ErrorMessage = ptr.String(jtv)
			}

		case "repositoryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryId to be of type string, got %T instead", value)
				}
				sv.RepositoryId = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBatchGetRepositoriesErrorsList(v *[]types.BatchGetRepositoriesError, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.BatchGetRepositoriesError
	if *v == nil {
		cv = []types.BatchGetRepositoriesError{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.BatchGetRepositoriesError
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentBatchGetRepositoriesError(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentBeforeCommitIdAndAfterCommitIdAreSameException(v **types.BeforeCommitIdAndAfterCommitIdAreSameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BeforeCommitIdAndAfterCommitIdAreSameException
	if *v == nil {
		sv = &types.BeforeCommitIdAndAfterCommitIdAreSameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBlobIdDoesNotExistException(v **types.BlobIdDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BlobIdDoesNotExistException
	if *v == nil {
		sv = &types.BlobIdDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBlobIdRequiredException(v **types.BlobIdRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BlobIdRequiredException
	if *v == nil {
		sv = &types.BlobIdRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBlobMetadata(v **types.BlobMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BlobMetadata
	if *v == nil {
		sv = &types.BlobMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "blobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BlobId = ptr.String(jtv)
			}

		case "mode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Mode to be of type string, got %T instead", value)
				}
				sv.Mode = ptr.String(jtv)
			}

		case "path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBranchDoesNotExistException(v **types.BranchDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BranchDoesNotExistException
	if *v == nil {
		sv = &types.BranchDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBranchInfo(v **types.BranchInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BranchInfo
	if *v == nil {
		sv = &types.BranchInfo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "branchName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected BranchName to be of type string, got %T instead", value)
				}
				sv.BranchName = ptr.String(jtv)
			}

		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBranchNameExistsException(v **types.BranchNameExistsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BranchNameExistsException
	if *v == nil {
		sv = &types.BranchNameExistsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBranchNameIsTagNameException(v **types.BranchNameIsTagNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BranchNameIsTagNameException
	if *v == nil {
		sv = &types.BranchNameIsTagNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentBranchNameList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected BranchName to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentBranchNameRequiredException(v **types.BranchNameRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.BranchNameRequiredException
	if *v == nil {
		sv = &types.BranchNameRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCallerReactions(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected ReactionValue to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentCannotDeleteApprovalRuleFromTemplateException(v **types.CannotDeleteApprovalRuleFromTemplateException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CannotDeleteApprovalRuleFromTemplateException
	if *v == nil {
		sv = &types.CannotDeleteApprovalRuleFromTemplateException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCannotModifyApprovalRuleFromTemplateException(v **types.CannotModifyApprovalRuleFromTemplateException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CannotModifyApprovalRuleFromTemplateException
	if *v == nil {
		sv = &types.CannotModifyApprovalRuleFromTemplateException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentClientRequestTokenRequiredException(v **types.ClientRequestTokenRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ClientRequestTokenRequiredException
	if *v == nil {
		sv = &types.ClientRequestTokenRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentComment(v **types.Comment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Comment
	if *v == nil {
		sv = &types.Comment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "authorArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.AuthorArn = ptr.String(jtv)
			}

		case "callerReactions":
			if err := awsAwsjson11_deserializeDocumentCallerReactions(&sv.CallerReactions, value); err != nil {
				return err
			}

		case "clientRequestToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ClientRequestToken to be of type string, got %T instead", value)
				}
				sv.ClientRequestToken = ptr.String(jtv)
			}

		case "commentId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommentId to be of type string, got %T instead", value)
				}
				sv.CommentId = ptr.String(jtv)
			}

		case "content":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Content to be of type string, got %T instead", value)
				}
				sv.Content = ptr.String(jtv)
			}

		case "creationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected CreationDate to be a JSON Number, got %T instead", value)

				}
			}

		case "deleted":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected IsCommentDeleted to be of type *bool, got %T instead", value)
				}
				sv.Deleted = jtv
			}

		case "inReplyTo":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommentId to be of type string, got %T instead", value)
				}
				sv.InReplyTo = ptr.String(jtv)
			}

		case "lastModifiedDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastModifiedDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastModifiedDate to be a JSON Number, got %T instead", value)

				}
			}

		case "reactionCounts":
			if err := awsAwsjson11_deserializeDocumentReactionCountsMap(&sv.ReactionCounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentContentRequiredException(v **types.CommentContentRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommentContentRequiredException
	if *v == nil {
		sv = &types.CommentContentRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentContentSizeLimitExceededException(v **types.CommentContentSizeLimitExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommentContentSizeLimitExceededException
	if *v == nil {
		sv = &types.CommentContentSizeLimitExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentDeletedException(v **types.CommentDeletedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommentDeletedException
	if *v == nil {
		sv = &types.CommentDeletedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentDoesNotExistException(v **types.CommentDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommentDoesNotExistException
	if *v == nil {
		sv = &types.CommentDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentIdRequiredException(v **types.CommentIdRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommentIdRequiredException
	if *v == nil {
		sv = &types.CommentIdRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentNotCreatedByCallerException(v **types.CommentNotCreatedByCallerException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommentNotCreatedByCallerException
	if *v == nil {
		sv = &types.CommentNotCreatedByCallerException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentComments(v *[]types.Comment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Comment
	if *v == nil {
		cv = []types.Comment{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Comment
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentComment(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentsForComparedCommit(v **types.CommentsForComparedCommit, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommentsForComparedCommit
	if *v == nil {
		sv = &types.CommentsForComparedCommit{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "afterBlobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.AfterBlobId = ptr.String(jtv)
			}

		case "afterCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.AfterCommitId = ptr.String(jtv)
			}

		case "beforeBlobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BeforeBlobId = ptr.String(jtv)
			}

		case "beforeCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.BeforeCommitId = ptr.String(jtv)
			}

		case "comments":
			if err := awsAwsjson11_deserializeDocumentComments(&sv.Comments, value); err != nil {
				return err
			}

		case "location":
			if err := awsAwsjson11_deserializeDocumentLocation(&sv.Location, value); err != nil {
				return err
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentsForComparedCommitData(v *[]types.CommentsForComparedCommit, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.CommentsForComparedCommit
	if *v == nil {
		cv = []types.CommentsForComparedCommit{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.CommentsForComparedCommit
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentCommentsForComparedCommit(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentsForPullRequest(v **types.CommentsForPullRequest, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommentsForPullRequest
	if *v == nil {
		sv = &types.CommentsForPullRequest{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "afterBlobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.AfterBlobId = ptr.String(jtv)
			}

		case "afterCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.AfterCommitId = ptr.String(jtv)
			}

		case "beforeBlobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BeforeBlobId = ptr.String(jtv)
			}

		case "beforeCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.BeforeCommitId = ptr.String(jtv)
			}

		case "comments":
			if err := awsAwsjson11_deserializeDocumentComments(&sv.Comments, value); err != nil {
				return err
			}

		case "location":
			if err := awsAwsjson11_deserializeDocumentLocation(&sv.Location, value); err != nil {
				return err
			}

		case "pullRequestId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PullRequestId to be of type string, got %T instead", value)
				}
				sv.PullRequestId = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommentsForPullRequestData(v *[]types.CommentsForPullRequest, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.CommentsForPullRequest
	if *v == nil {
		cv = []types.CommentsForPullRequest{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.CommentsForPullRequest
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentCommentsForPullRequest(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentCommit(v **types.Commit, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Commit
	if *v == nil {
		sv = &types.Commit{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "additionalData":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AdditionalData to be of type string, got %T instead", value)
				}
				sv.AdditionalData = ptr.String(jtv)
			}

		case "author":
			if err := awsAwsjson11_deserializeDocumentUserInfo(&sv.Author, value); err != nil {
				return err
			}

		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "committer":
			if err := awsAwsjson11_deserializeDocumentUserInfo(&sv.Committer, value); err != nil {
				return err
			}

		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "parents":
			if err := awsAwsjson11_deserializeDocumentParentList(&sv.Parents, value); err != nil {
				return err
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommitDoesNotExistException(v **types.CommitDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommitDoesNotExistException
	if *v == nil {
		sv = &types.CommitDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommitIdDoesNotExistException(v **types.CommitIdDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommitIdDoesNotExistException
	if *v == nil {
		sv = &types.CommitIdDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommitIdRequiredException(v **types.CommitIdRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommitIdRequiredException
	if *v == nil {
		sv = &types.CommitIdRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommitIdsLimitExceededException(v **types.CommitIdsLimitExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommitIdsLimitExceededException
	if *v == nil {
		sv = &types.CommitIdsLimitExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommitIdsListRequiredException(v **types.CommitIdsListRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommitIdsListRequiredException
	if *v == nil {
		sv = &types.CommitIdsListRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommitMessageLengthExceededException(v **types.CommitMessageLengthExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommitMessageLengthExceededException
	if *v == nil {
		sv = &types.CommitMessageLengthExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentCommitObjectsList(v *[]types.Commit, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Commit
	if *v == nil {
		cv = []types.Commit{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Commit
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentCommit(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentCommitRequiredException(v **types.CommitRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CommitRequiredException
	if *v == nil {
		sv = &types.CommitRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentConcurrentReferenceUpdateException(v **types.ConcurrentReferenceUpdateException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConcurrentReferenceUpdateException
	if *v == nil {
		sv = &types.ConcurrentReferenceUpdateException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentConflict(v **types.Conflict, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Conflict
	if *v == nil {
		sv = &types.Conflict{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "conflictMetadata":
			if err := awsAwsjson11_deserializeDocumentConflictMetadata(&sv.ConflictMetadata, value); err != nil {
				return err
			}

		case "mergeHunks":
			if err := awsAwsjson11_deserializeDocumentMergeHunks(&sv.MergeHunks, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentConflictMetadata(v **types.ConflictMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ConflictMetadata
	if *v == nil {
		sv = &types.ConflictMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "contentConflict":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected IsContentConflict to be of type *bool, got %T instead", value)
				}
				sv.ContentConflict = jtv
			}

		case "fileModeConflict":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected IsFileModeConflict to be of type *bool, got %T instead", value)
				}
				sv.FileModeConflict = jtv
			}

		case "fileModes":
			if err := awsAwsjson11_deserializeDocumentFileModes(&sv.FileModes, value); err != nil {
				return err
			}

		case "filePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.FilePath = ptr.String(jtv)
			}

		case "fileSizes":
			if err := awsAwsjson11_deserializeDocumentFileSizes(&sv.FileSizes, value); err != nil {
				return err
			}

		case "isBinaryFile":
			if err := awsAwsjson11_deserializeDocumentIsBinaryFile(&sv.IsBinaryFile, value); err != nil {
				return err
			}

		case "mergeOperations":
			if err := awsAwsjson11_deserializeDocumentMergeOperations(&sv.MergeOperations, value); err != nil {
				return err
			}

		case "numberOfConflicts":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected NumberOfConflicts to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.NumberOfConflicts = int32(i64)
			}

		case "objectTypeConflict":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected IsObjectTypeConflict to be of type *bool, got %T instead", value)
				}
				sv.ObjectTypeConflict = jtv
			}

		case "objectTypes":
			if err := awsAwsjson11_deserializeDocumentObjectTypes(&sv.ObjectTypes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentConflictMetadataList(v *[]types.ConflictMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ConflictMetadata
	if *v == nil {
		cv = []types.ConflictMetadata{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ConflictMetadata
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentConflictMetadata(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentConflicts(v *[]types.Conflict, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Conflict
	if *v == nil {
		cv = []types.Conflict{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Conflict
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentConflict(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentDefaultBranchCannotBeDeletedException(v **types.DefaultBranchCannotBeDeletedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DefaultBranchCannotBeDeletedException
	if *v == nil {
		sv = &types.DefaultBranchCannotBeDeletedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentDifference(v **types.Difference, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Difference
	if *v == nil {
		sv = &types.Difference{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "afterBlob":
			if err := awsAwsjson11_deserializeDocumentBlobMetadata(&sv.AfterBlob, value); err != nil {
				return err
			}

		case "beforeBlob":
			if err := awsAwsjson11_deserializeDocumentBlobMetadata(&sv.BeforeBlob, value); err != nil {
				return err
			}

		case "changeType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChangeTypeEnum to be of type string, got %T instead", value)
				}
				sv.ChangeType = types.ChangeTypeEnum(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentDifferenceList(v *[]types.Difference, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Difference
	if *v == nil {
		cv = []types.Difference{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Difference
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentDifference(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentDirectoryNameConflictsWithFileNameException(v **types.DirectoryNameConflictsWithFileNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DirectoryNameConflictsWithFileNameException
	if *v == nil {
		sv = &types.DirectoryNameConflictsWithFileNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEncryptionIntegrityChecksFailedException(v **types.EncryptionIntegrityChecksFailedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EncryptionIntegrityChecksFailedException
	if *v == nil {
		sv = &types.EncryptionIntegrityChecksFailedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEncryptionKeyAccessDeniedException(v **types.EncryptionKeyAccessDeniedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EncryptionKeyAccessDeniedException
	if *v == nil {
		sv = &types.EncryptionKeyAccessDeniedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEncryptionKeyDisabledException(v **types.EncryptionKeyDisabledException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EncryptionKeyDisabledException
	if *v == nil {
		sv = &types.EncryptionKeyDisabledException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEncryptionKeyInvalidIdException(v **types.EncryptionKeyInvalidIdException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EncryptionKeyInvalidIdException
	if *v == nil {
		sv = &types.EncryptionKeyInvalidIdException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEncryptionKeyInvalidUsageException(v **types.EncryptionKeyInvalidUsageException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EncryptionKeyInvalidUsageException
	if *v == nil {
		sv = &types.EncryptionKeyInvalidUsageException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEncryptionKeyNotFoundException(v **types.EncryptionKeyNotFoundException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EncryptionKeyNotFoundException
	if *v == nil {
		sv = &types.EncryptionKeyNotFoundException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEncryptionKeyRequiredException(v **types.EncryptionKeyRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EncryptionKeyRequiredException
	if *v == nil {
		sv = &types.EncryptionKeyRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEncryptionKeyUnavailableException(v **types.EncryptionKeyUnavailableException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.EncryptionKeyUnavailableException
	if *v == nil {
		sv = &types.EncryptionKeyUnavailableException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentEvaluation(v **types.Evaluation, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Evaluation
	if *v == nil {
		sv = &types.Evaluation{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRulesNotSatisfied":
			if err := awsAwsjson11_deserializeDocumentApprovalRulesNotSatisfiedList(&sv.ApprovalRulesNotSatisfied, value); err != nil {
				return err
			}

		case "approvalRulesSatisfied":
			if err := awsAwsjson11_deserializeDocumentApprovalRulesSatisfiedList(&sv.ApprovalRulesSatisfied, value); err != nil {
				return err
			}

		case "approved":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Approved to be of type *bool, got %T instead", value)
				}
				sv.Approved = jtv
			}

		case "overridden":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Overridden to be of type *bool, got %T instead", value)
				}
				sv.Overridden = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFile(v **types.File, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.File
	if *v == nil {
		sv = &types.File{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "absolutePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.AbsolutePath = ptr.String(jtv)
			}

		case "blobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BlobId = ptr.String(jtv)
			}

		case "fileMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FileModeTypeEnum to be of type string, got %T instead", value)
				}
				sv.FileMode = types.FileModeTypeEnum(jtv)
			}

		case "relativePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.RelativePath = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileContentAndSourceFileSpecifiedException(v **types.FileContentAndSourceFileSpecifiedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileContentAndSourceFileSpecifiedException
	if *v == nil {
		sv = &types.FileContentAndSourceFileSpecifiedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileContentRequiredException(v **types.FileContentRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileContentRequiredException
	if *v == nil {
		sv = &types.FileContentRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileContentSizeLimitExceededException(v **types.FileContentSizeLimitExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileContentSizeLimitExceededException
	if *v == nil {
		sv = &types.FileContentSizeLimitExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileDoesNotExistException(v **types.FileDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileDoesNotExistException
	if *v == nil {
		sv = &types.FileDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileEntryRequiredException(v **types.FileEntryRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileEntryRequiredException
	if *v == nil {
		sv = &types.FileEntryRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileList(v *[]types.File, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.File
	if *v == nil {
		cv = []types.File{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.File
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentFile(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentFileMetadata(v **types.FileMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileMetadata
	if *v == nil {
		sv = &types.FileMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "absolutePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.AbsolutePath = ptr.String(jtv)
			}

		case "blobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BlobId = ptr.String(jtv)
			}

		case "fileMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FileModeTypeEnum to be of type string, got %T instead", value)
				}
				sv.FileMode = types.FileModeTypeEnum(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileModeRequiredException(v **types.FileModeRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileModeRequiredException
	if *v == nil {
		sv = &types.FileModeRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileModes(v **types.FileModes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileModes
	if *v == nil {
		sv = &types.FileModes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "base":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FileModeTypeEnum to be of type string, got %T instead", value)
				}
				sv.Base = types.FileModeTypeEnum(jtv)
			}

		case "destination":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FileModeTypeEnum to be of type string, got %T instead", value)
				}
				sv.Destination = types.FileModeTypeEnum(jtv)
			}

		case "source":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FileModeTypeEnum to be of type string, got %T instead", value)
				}
				sv.Source = types.FileModeTypeEnum(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileNameConflictsWithDirectoryNameException(v **types.FileNameConflictsWithDirectoryNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileNameConflictsWithDirectoryNameException
	if *v == nil {
		sv = &types.FileNameConflictsWithDirectoryNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFilePathConflictsWithSubmodulePathException(v **types.FilePathConflictsWithSubmodulePathException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FilePathConflictsWithSubmodulePathException
	if *v == nil {
		sv = &types.FilePathConflictsWithSubmodulePathException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileSizes(v **types.FileSizes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileSizes
	if *v == nil {
		sv = &types.FileSizes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "base":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected FileSize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Base = i64
			}

		case "destination":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected FileSize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Destination = i64
			}

		case "source":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected FileSize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Source = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFilesMetadata(v *[]types.FileMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.FileMetadata
	if *v == nil {
		cv = []types.FileMetadata{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.FileMetadata
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentFileMetadata(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentFileTooLargeException(v **types.FileTooLargeException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileTooLargeException
	if *v == nil {
		sv = &types.FileTooLargeException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFileVersion(v **types.FileVersion, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FileVersion
	if *v == nil {
		sv = &types.FileVersion{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "blobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BlobId = ptr.String(jtv)
			}

		case "commit":
			if err := awsAwsjson11_deserializeDocumentCommit(&sv.Commit, value); err != nil {
				return err
			}

		case "path":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.Path = ptr.String(jtv)
			}

		case "revisionChildren":
			if err := awsAwsjson11_deserializeDocumentRevisionChildren(&sv.RevisionChildren, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFolder(v **types.Folder, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Folder
	if *v == nil {
		sv = &types.Folder{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "absolutePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.AbsolutePath = ptr.String(jtv)
			}

		case "relativePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.RelativePath = ptr.String(jtv)
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFolderContentSizeLimitExceededException(v **types.FolderContentSizeLimitExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FolderContentSizeLimitExceededException
	if *v == nil {
		sv = &types.FolderContentSizeLimitExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFolderDoesNotExistException(v **types.FolderDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FolderDoesNotExistException
	if *v == nil {
		sv = &types.FolderDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentFolderList(v *[]types.Folder, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.Folder
	if *v == nil {
		cv = []types.Folder{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.Folder
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentFolder(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentIdempotencyParameterMismatchException(v **types.IdempotencyParameterMismatchException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.IdempotencyParameterMismatchException
	if *v == nil {
		sv = &types.IdempotencyParameterMismatchException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidActorArnException(v **types.InvalidActorArnException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidActorArnException
	if *v == nil {
		sv = &types.InvalidActorArnException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidApprovalRuleContentException(v **types.InvalidApprovalRuleContentException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidApprovalRuleContentException
	if *v == nil {
		sv = &types.InvalidApprovalRuleContentException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidApprovalRuleNameException(v **types.InvalidApprovalRuleNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidApprovalRuleNameException
	if *v == nil {
		sv = &types.InvalidApprovalRuleNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidApprovalRuleTemplateContentException(v **types.InvalidApprovalRuleTemplateContentException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidApprovalRuleTemplateContentException
	if *v == nil {
		sv = &types.InvalidApprovalRuleTemplateContentException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidApprovalRuleTemplateDescriptionException(v **types.InvalidApprovalRuleTemplateDescriptionException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidApprovalRuleTemplateDescriptionException
	if *v == nil {
		sv = &types.InvalidApprovalRuleTemplateDescriptionException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidApprovalRuleTemplateNameException(v **types.InvalidApprovalRuleTemplateNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidApprovalRuleTemplateNameException
	if *v == nil {
		sv = &types.InvalidApprovalRuleTemplateNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidApprovalStateException(v **types.InvalidApprovalStateException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidApprovalStateException
	if *v == nil {
		sv = &types.InvalidApprovalStateException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidAuthorArnException(v **types.InvalidAuthorArnException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidAuthorArnException
	if *v == nil {
		sv = &types.InvalidAuthorArnException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidBlobIdException(v **types.InvalidBlobIdException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidBlobIdException
	if *v == nil {
		sv = &types.InvalidBlobIdException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidBranchNameException(v **types.InvalidBranchNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidBranchNameException
	if *v == nil {
		sv = &types.InvalidBranchNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidClientRequestTokenException(v **types.InvalidClientRequestTokenException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidClientRequestTokenException
	if *v == nil {
		sv = &types.InvalidClientRequestTokenException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidCommentIdException(v **types.InvalidCommentIdException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidCommentIdException
	if *v == nil {
		sv = &types.InvalidCommentIdException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidCommitException(v **types.InvalidCommitException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidCommitException
	if *v == nil {
		sv = &types.InvalidCommitException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidCommitIdException(v **types.InvalidCommitIdException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidCommitIdException
	if *v == nil {
		sv = &types.InvalidCommitIdException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidConflictDetailLevelException(v **types.InvalidConflictDetailLevelException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidConflictDetailLevelException
	if *v == nil {
		sv = &types.InvalidConflictDetailLevelException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidConflictResolutionException(v **types.InvalidConflictResolutionException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidConflictResolutionException
	if *v == nil {
		sv = &types.InvalidConflictResolutionException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidConflictResolutionStrategyException(v **types.InvalidConflictResolutionStrategyException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidConflictResolutionStrategyException
	if *v == nil {
		sv = &types.InvalidConflictResolutionStrategyException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidContinuationTokenException(v **types.InvalidContinuationTokenException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidContinuationTokenException
	if *v == nil {
		sv = &types.InvalidContinuationTokenException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidDeletionParameterException(v **types.InvalidDeletionParameterException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidDeletionParameterException
	if *v == nil {
		sv = &types.InvalidDeletionParameterException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidDescriptionException(v **types.InvalidDescriptionException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidDescriptionException
	if *v == nil {
		sv = &types.InvalidDescriptionException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidDestinationCommitSpecifierException(v **types.InvalidDestinationCommitSpecifierException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidDestinationCommitSpecifierException
	if *v == nil {
		sv = &types.InvalidDestinationCommitSpecifierException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidEmailException(v **types.InvalidEmailException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidEmailException
	if *v == nil {
		sv = &types.InvalidEmailException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidFileLocationException(v **types.InvalidFileLocationException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidFileLocationException
	if *v == nil {
		sv = &types.InvalidFileLocationException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidFileModeException(v **types.InvalidFileModeException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidFileModeException
	if *v == nil {
		sv = &types.InvalidFileModeException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidFilePositionException(v **types.InvalidFilePositionException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidFilePositionException
	if *v == nil {
		sv = &types.InvalidFilePositionException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidMaxConflictFilesException(v **types.InvalidMaxConflictFilesException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidMaxConflictFilesException
	if *v == nil {
		sv = &types.InvalidMaxConflictFilesException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidMaxMergeHunksException(v **types.InvalidMaxMergeHunksException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidMaxMergeHunksException
	if *v == nil {
		sv = &types.InvalidMaxMergeHunksException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidMaxResultsException(v **types.InvalidMaxResultsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidMaxResultsException
	if *v == nil {
		sv = &types.InvalidMaxResultsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidMergeOptionException(v **types.InvalidMergeOptionException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidMergeOptionException
	if *v == nil {
		sv = &types.InvalidMergeOptionException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidOrderException(v **types.InvalidOrderException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidOrderException
	if *v == nil {
		sv = &types.InvalidOrderException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidOverrideStatusException(v **types.InvalidOverrideStatusException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidOverrideStatusException
	if *v == nil {
		sv = &types.InvalidOverrideStatusException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidParentCommitIdException(v **types.InvalidParentCommitIdException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidParentCommitIdException
	if *v == nil {
		sv = &types.InvalidParentCommitIdException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidPathException(v **types.InvalidPathException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidPathException
	if *v == nil {
		sv = &types.InvalidPathException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidPullRequestEventTypeException(v **types.InvalidPullRequestEventTypeException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidPullRequestEventTypeException
	if *v == nil {
		sv = &types.InvalidPullRequestEventTypeException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidPullRequestIdException(v **types.InvalidPullRequestIdException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidPullRequestIdException
	if *v == nil {
		sv = &types.InvalidPullRequestIdException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidPullRequestStatusException(v **types.InvalidPullRequestStatusException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidPullRequestStatusException
	if *v == nil {
		sv = &types.InvalidPullRequestStatusException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidPullRequestStatusUpdateException(v **types.InvalidPullRequestStatusUpdateException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidPullRequestStatusUpdateException
	if *v == nil {
		sv = &types.InvalidPullRequestStatusUpdateException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidReactionUserArnException(v **types.InvalidReactionUserArnException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidReactionUserArnException
	if *v == nil {
		sv = &types.InvalidReactionUserArnException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidReactionValueException(v **types.InvalidReactionValueException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidReactionValueException
	if *v == nil {
		sv = &types.InvalidReactionValueException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidReferenceNameException(v **types.InvalidReferenceNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidReferenceNameException
	if *v == nil {
		sv = &types.InvalidReferenceNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRelativeFileVersionEnumException(v **types.InvalidRelativeFileVersionEnumException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRelativeFileVersionEnumException
	if *v == nil {
		sv = &types.InvalidRelativeFileVersionEnumException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidReplacementContentException(v **types.InvalidReplacementContentException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidReplacementContentException
	if *v == nil {
		sv = &types.InvalidReplacementContentException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidReplacementTypeException(v **types.InvalidReplacementTypeException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidReplacementTypeException
	if *v == nil {
		sv = &types.InvalidReplacementTypeException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRepositoryDescriptionException(v **types.InvalidRepositoryDescriptionException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRepositoryDescriptionException
	if *v == nil {
		sv = &types.InvalidRepositoryDescriptionException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRepositoryNameException(v **types.InvalidRepositoryNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRepositoryNameException
	if *v == nil {
		sv = &types.InvalidRepositoryNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerBranchNameException(v **types.InvalidRepositoryTriggerBranchNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRepositoryTriggerBranchNameException
	if *v == nil {
		sv = &types.InvalidRepositoryTriggerBranchNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerCustomDataException(v **types.InvalidRepositoryTriggerCustomDataException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRepositoryTriggerCustomDataException
	if *v == nil {
		sv = &types.InvalidRepositoryTriggerCustomDataException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerDestinationArnException(v **types.InvalidRepositoryTriggerDestinationArnException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRepositoryTriggerDestinationArnException
	if *v == nil {
		sv = &types.InvalidRepositoryTriggerDestinationArnException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerEventsException(v **types.InvalidRepositoryTriggerEventsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRepositoryTriggerEventsException
	if *v == nil {
		sv = &types.InvalidRepositoryTriggerEventsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerNameException(v **types.InvalidRepositoryTriggerNameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRepositoryTriggerNameException
	if *v == nil {
		sv = &types.InvalidRepositoryTriggerNameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRepositoryTriggerRegionException(v **types.InvalidRepositoryTriggerRegionException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRepositoryTriggerRegionException
	if *v == nil {
		sv = &types.InvalidRepositoryTriggerRegionException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidResourceArnException(v **types.InvalidResourceArnException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidResourceArnException
	if *v == nil {
		sv = &types.InvalidResourceArnException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRevisionIdException(v **types.InvalidRevisionIdException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRevisionIdException
	if *v == nil {
		sv = &types.InvalidRevisionIdException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidRuleContentSha256Exception(v **types.InvalidRuleContentSha256Exception, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidRuleContentSha256Exception
	if *v == nil {
		sv = &types.InvalidRuleContentSha256Exception{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidSortByException(v **types.InvalidSortByException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidSortByException
	if *v == nil {
		sv = &types.InvalidSortByException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidSourceCommitSpecifierException(v **types.InvalidSourceCommitSpecifierException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidSourceCommitSpecifierException
	if *v == nil {
		sv = &types.InvalidSourceCommitSpecifierException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidSystemTagUsageException(v **types.InvalidSystemTagUsageException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidSystemTagUsageException
	if *v == nil {
		sv = &types.InvalidSystemTagUsageException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidTagKeysListException(v **types.InvalidTagKeysListException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidTagKeysListException
	if *v == nil {
		sv = &types.InvalidTagKeysListException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidTagsMapException(v **types.InvalidTagsMapException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidTagsMapException
	if *v == nil {
		sv = &types.InvalidTagsMapException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidTargetBranchException(v **types.InvalidTargetBranchException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidTargetBranchException
	if *v == nil {
		sv = &types.InvalidTargetBranchException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidTargetException(v **types.InvalidTargetException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidTargetException
	if *v == nil {
		sv = &types.InvalidTargetException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidTargetsException(v **types.InvalidTargetsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidTargetsException
	if *v == nil {
		sv = &types.InvalidTargetsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentInvalidTitleException(v **types.InvalidTitleException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.InvalidTitleException
	if *v == nil {
		sv = &types.InvalidTitleException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentIsBinaryFile(v **types.IsBinaryFile, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.IsBinaryFile
	if *v == nil {
		sv = &types.IsBinaryFile{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "base":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected CapitalBoolean to be of type *bool, got %T instead", value)
				}
				sv.Base = ptr.Bool(jtv)
			}

		case "destination":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected CapitalBoolean to be of type *bool, got %T instead", value)
				}
				sv.Destination = ptr.Bool(jtv)
			}

		case "source":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected CapitalBoolean to be of type *bool, got %T instead", value)
				}
				sv.Source = ptr.Bool(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentLocation(v **types.Location, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.Location
	if *v == nil {
		sv = &types.Location{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "filePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.FilePath = ptr.String(jtv)
			}

		case "filePosition":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Position to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FilePosition = ptr.Int64(i64)
			}

		case "relativeFileVersion":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RelativeFileVersionEnum to be of type string, got %T instead", value)
				}
				sv.RelativeFileVersion = types.RelativeFileVersionEnum(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentManualMergeRequiredException(v **types.ManualMergeRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ManualMergeRequiredException
	if *v == nil {
		sv = &types.ManualMergeRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumBranchesExceededException(v **types.MaximumBranchesExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumBranchesExceededException
	if *v == nil {
		sv = &types.MaximumBranchesExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumConflictResolutionEntriesExceededException(v **types.MaximumConflictResolutionEntriesExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumConflictResolutionEntriesExceededException
	if *v == nil {
		sv = &types.MaximumConflictResolutionEntriesExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumFileContentToLoadExceededException(v **types.MaximumFileContentToLoadExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumFileContentToLoadExceededException
	if *v == nil {
		sv = &types.MaximumFileContentToLoadExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumFileEntriesExceededException(v **types.MaximumFileEntriesExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumFileEntriesExceededException
	if *v == nil {
		sv = &types.MaximumFileEntriesExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumItemsToCompareExceededException(v **types.MaximumItemsToCompareExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumItemsToCompareExceededException
	if *v == nil {
		sv = &types.MaximumItemsToCompareExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumNumberOfApprovalsExceededException(v **types.MaximumNumberOfApprovalsExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumNumberOfApprovalsExceededException
	if *v == nil {
		sv = &types.MaximumNumberOfApprovalsExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumOpenPullRequestsExceededException(v **types.MaximumOpenPullRequestsExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumOpenPullRequestsExceededException
	if *v == nil {
		sv = &types.MaximumOpenPullRequestsExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumRepositoryNamesExceededException(v **types.MaximumRepositoryNamesExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumRepositoryNamesExceededException
	if *v == nil {
		sv = &types.MaximumRepositoryNamesExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumRepositoryTriggersExceededException(v **types.MaximumRepositoryTriggersExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumRepositoryTriggersExceededException
	if *v == nil {
		sv = &types.MaximumRepositoryTriggersExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMaximumRuleTemplatesAssociatedWithRepositoryException(v **types.MaximumRuleTemplatesAssociatedWithRepositoryException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MaximumRuleTemplatesAssociatedWithRepositoryException
	if *v == nil {
		sv = &types.MaximumRuleTemplatesAssociatedWithRepositoryException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMergeHunk(v **types.MergeHunk, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MergeHunk
	if *v == nil {
		sv = &types.MergeHunk{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "base":
			if err := awsAwsjson11_deserializeDocumentMergeHunkDetail(&sv.Base, value); err != nil {
				return err
			}

		case "destination":
			if err := awsAwsjson11_deserializeDocumentMergeHunkDetail(&sv.Destination, value); err != nil {
				return err
			}

		case "isConflict":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected IsHunkConflict to be of type *bool, got %T instead", value)
				}
				sv.IsConflict = jtv
			}

		case "source":
			if err := awsAwsjson11_deserializeDocumentMergeHunkDetail(&sv.Source, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMergeHunkDetail(v **types.MergeHunkDetail, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MergeHunkDetail
	if *v == nil {
		sv = &types.MergeHunkDetail{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "endLine":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected LineNumber to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.EndLine = ptr.Int32(int32(i64))
			}

		case "hunkContent":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected HunkContent to be of type string, got %T instead", value)
				}
				sv.HunkContent = ptr.String(jtv)
			}

		case "startLine":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected LineNumber to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartLine = ptr.Int32(int32(i64))
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMergeHunks(v *[]types.MergeHunk, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.MergeHunk
	if *v == nil {
		cv = []types.MergeHunk{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.MergeHunk
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentMergeHunk(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentMergeMetadata(v **types.MergeMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MergeMetadata
	if *v == nil {
		sv = &types.MergeMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "isMerged":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected IsMerged to be of type *bool, got %T instead", value)
				}
				sv.IsMerged = jtv
			}

		case "mergeCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.MergeCommitId = ptr.String(jtv)
			}

		case "mergedBy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.MergedBy = ptr.String(jtv)
			}

		case "mergeOption":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MergeOptionTypeEnum to be of type string, got %T instead", value)
				}
				sv.MergeOption = types.MergeOptionTypeEnum(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMergeOperations(v **types.MergeOperations, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MergeOperations
	if *v == nil {
		sv = &types.MergeOperations{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "destination":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChangeTypeEnum to be of type string, got %T instead", value)
				}
				sv.Destination = types.ChangeTypeEnum(jtv)
			}

		case "source":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChangeTypeEnum to be of type string, got %T instead", value)
				}
				sv.Source = types.ChangeTypeEnum(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMergeOptionRequiredException(v **types.MergeOptionRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MergeOptionRequiredException
	if *v == nil {
		sv = &types.MergeOptionRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMergeOptions(v *[]types.MergeOptionTypeEnum, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.MergeOptionTypeEnum
	if *v == nil {
		cv = []types.MergeOptionTypeEnum{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.MergeOptionTypeEnum
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected MergeOptionTypeEnum to be of type string, got %T instead", value)
			}
			col = types.MergeOptionTypeEnum(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentMultipleConflictResolutionEntriesException(v **types.MultipleConflictResolutionEntriesException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MultipleConflictResolutionEntriesException
	if *v == nil {
		sv = &types.MultipleConflictResolutionEntriesException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentMultipleRepositoriesInPullRequestException(v **types.MultipleRepositoriesInPullRequestException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MultipleRepositoriesInPullRequestException
	if *v == nil {
		sv = &types.MultipleRepositoriesInPullRequestException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentNameLengthExceededException(v **types.NameLengthExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NameLengthExceededException
	if *v == nil {
		sv = &types.NameLengthExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentNoChangeException(v **types.NoChangeException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NoChangeException
	if *v == nil {
		sv = &types.NoChangeException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentNumberOfRulesExceededException(v **types.NumberOfRulesExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NumberOfRulesExceededException
	if *v == nil {
		sv = &types.NumberOfRulesExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentNumberOfRuleTemplatesExceededException(v **types.NumberOfRuleTemplatesExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.NumberOfRuleTemplatesExceededException
	if *v == nil {
		sv = &types.NumberOfRuleTemplatesExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentObjectTypes(v **types.ObjectTypes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ObjectTypes
	if *v == nil {
		sv = &types.ObjectTypes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "base":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectTypeEnum to be of type string, got %T instead", value)
				}
				sv.Base = types.ObjectTypeEnum(jtv)
			}

		case "destination":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectTypeEnum to be of type string, got %T instead", value)
				}
				sv.Destination = types.ObjectTypeEnum(jtv)
			}

		case "source":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectTypeEnum to be of type string, got %T instead", value)
				}
				sv.Source = types.ObjectTypeEnum(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentOperationNotAllowedException(v **types.OperationNotAllowedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OperationNotAllowedException
	if *v == nil {
		sv = &types.OperationNotAllowedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentOriginApprovalRuleTemplate(v **types.OriginApprovalRuleTemplate, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OriginApprovalRuleTemplate
	if *v == nil {
		sv = &types.OriginApprovalRuleTemplate{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleTemplateId to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleTemplateId = ptr.String(jtv)
			}

		case "approvalRuleTemplateName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleTemplateName to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleTemplateName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentOverrideAlreadySetException(v **types.OverrideAlreadySetException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OverrideAlreadySetException
	if *v == nil {
		sv = &types.OverrideAlreadySetException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentOverrideStatusRequiredException(v **types.OverrideStatusRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OverrideStatusRequiredException
	if *v == nil {
		sv = &types.OverrideStatusRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentParentCommitDoesNotExistException(v **types.ParentCommitDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ParentCommitDoesNotExistException
	if *v == nil {
		sv = &types.ParentCommitDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentParentCommitIdOutdatedException(v **types.ParentCommitIdOutdatedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ParentCommitIdOutdatedException
	if *v == nil {
		sv = &types.ParentCommitIdOutdatedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentParentCommitIdRequiredException(v **types.ParentCommitIdRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ParentCommitIdRequiredException
	if *v == nil {
		sv = &types.ParentCommitIdRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentParentList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentPathDoesNotExistException(v **types.PathDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PathDoesNotExistException
	if *v == nil {
		sv = &types.PathDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPathRequiredException(v **types.PathRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PathRequiredException
	if *v == nil {
		sv = &types.PathRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequest(v **types.PullRequest, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequest
	if *v == nil {
		sv = &types.PullRequest{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRules":
			if err := awsAwsjson11_deserializeDocumentApprovalRulesList(&sv.ApprovalRules, value); err != nil {
				return err
			}

		case "authorArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.AuthorArn = ptr.String(jtv)
			}

		case "clientRequestToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ClientRequestToken to be of type string, got %T instead", value)
				}
				sv.ClientRequestToken = ptr.String(jtv)
			}

		case "creationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected CreationDate to be a JSON Number, got %T instead", value)

				}
			}

		case "description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Description to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "lastActivityDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastActivityDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastModifiedDate to be a JSON Number, got %T instead", value)

				}
			}

		case "pullRequestId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PullRequestId to be of type string, got %T instead", value)
				}
				sv.PullRequestId = ptr.String(jtv)
			}

		case "pullRequestStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PullRequestStatusEnum to be of type string, got %T instead", value)
				}
				sv.PullRequestStatus = types.PullRequestStatusEnum(jtv)
			}

		case "pullRequestTargets":
			if err := awsAwsjson11_deserializeDocumentPullRequestTargetList(&sv.PullRequestTargets, value); err != nil {
				return err
			}

		case "revisionId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RevisionId to be of type string, got %T instead", value)
				}
				sv.RevisionId = ptr.String(jtv)
			}

		case "title":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Title to be of type string, got %T instead", value)
				}
				sv.Title = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestAlreadyClosedException(v **types.PullRequestAlreadyClosedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestAlreadyClosedException
	if *v == nil {
		sv = &types.PullRequestAlreadyClosedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestApprovalRulesNotSatisfiedException(v **types.PullRequestApprovalRulesNotSatisfiedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestApprovalRulesNotSatisfiedException
	if *v == nil {
		sv = &types.PullRequestApprovalRulesNotSatisfiedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestCannotBeApprovedByAuthorException(v **types.PullRequestCannotBeApprovedByAuthorException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestCannotBeApprovedByAuthorException
	if *v == nil {
		sv = &types.PullRequestCannotBeApprovedByAuthorException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestCreatedEventMetadata(v **types.PullRequestCreatedEventMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestCreatedEventMetadata
	if *v == nil {
		sv = &types.PullRequestCreatedEventMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "destinationCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.DestinationCommitId = ptr.String(jtv)
			}

		case "mergeBase":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.MergeBase = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		case "sourceCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.SourceCommitId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestDoesNotExistException(v **types.PullRequestDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestDoesNotExistException
	if *v == nil {
		sv = &types.PullRequestDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestEvent(v **types.PullRequestEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestEvent
	if *v == nil {
		sv = &types.PullRequestEvent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "actorArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.ActorArn = ptr.String(jtv)
			}

		case "approvalRuleEventMetadata":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleEventMetadata(&sv.ApprovalRuleEventMetadata, value); err != nil {
				return err
			}

		case "approvalRuleOverriddenEventMetadata":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleOverriddenEventMetadata(&sv.ApprovalRuleOverriddenEventMetadata, value); err != nil {
				return err
			}

		case "approvalStateChangedEventMetadata":
			if err := awsAwsjson11_deserializeDocumentApprovalStateChangedEventMetadata(&sv.ApprovalStateChangedEventMetadata, value); err != nil {
				return err
			}

		case "eventDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.EventDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected EventDate to be a JSON Number, got %T instead", value)

				}
			}

		case "pullRequestCreatedEventMetadata":
			if err := awsAwsjson11_deserializeDocumentPullRequestCreatedEventMetadata(&sv.PullRequestCreatedEventMetadata, value); err != nil {
				return err
			}

		case "pullRequestEventType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PullRequestEventType to be of type string, got %T instead", value)
				}
				sv.PullRequestEventType = types.PullRequestEventType(jtv)
			}

		case "pullRequestId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PullRequestId to be of type string, got %T instead", value)
				}
				sv.PullRequestId = ptr.String(jtv)
			}

		case "pullRequestMergedStateChangedEventMetadata":
			if err := awsAwsjson11_deserializeDocumentPullRequestMergedStateChangedEventMetadata(&sv.PullRequestMergedStateChangedEventMetadata, value); err != nil {
				return err
			}

		case "pullRequestSourceReferenceUpdatedEventMetadata":
			if err := awsAwsjson11_deserializeDocumentPullRequestSourceReferenceUpdatedEventMetadata(&sv.PullRequestSourceReferenceUpdatedEventMetadata, value); err != nil {
				return err
			}

		case "pullRequestStatusChangedEventMetadata":
			if err := awsAwsjson11_deserializeDocumentPullRequestStatusChangedEventMetadata(&sv.PullRequestStatusChangedEventMetadata, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestEventList(v *[]types.PullRequestEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.PullRequestEvent
	if *v == nil {
		cv = []types.PullRequestEvent{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.PullRequestEvent
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentPullRequestEvent(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestIdList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected PullRequestId to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestIdRequiredException(v **types.PullRequestIdRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestIdRequiredException
	if *v == nil {
		sv = &types.PullRequestIdRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestMergedStateChangedEventMetadata(v **types.PullRequestMergedStateChangedEventMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestMergedStateChangedEventMetadata
	if *v == nil {
		sv = &types.PullRequestMergedStateChangedEventMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "destinationReference":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ReferenceName to be of type string, got %T instead", value)
				}
				sv.DestinationReference = ptr.String(jtv)
			}

		case "mergeMetadata":
			if err := awsAwsjson11_deserializeDocumentMergeMetadata(&sv.MergeMetadata, value); err != nil {
				return err
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestSourceReferenceUpdatedEventMetadata(v **types.PullRequestSourceReferenceUpdatedEventMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestSourceReferenceUpdatedEventMetadata
	if *v == nil {
		sv = &types.PullRequestSourceReferenceUpdatedEventMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "afterCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.AfterCommitId = ptr.String(jtv)
			}

		case "beforeCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.BeforeCommitId = ptr.String(jtv)
			}

		case "mergeBase":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.MergeBase = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestStatusChangedEventMetadata(v **types.PullRequestStatusChangedEventMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestStatusChangedEventMetadata
	if *v == nil {
		sv = &types.PullRequestStatusChangedEventMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequestStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PullRequestStatusEnum to be of type string, got %T instead", value)
				}
				sv.PullRequestStatus = types.PullRequestStatusEnum(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestStatusRequiredException(v **types.PullRequestStatusRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestStatusRequiredException
	if *v == nil {
		sv = &types.PullRequestStatusRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestTarget(v **types.PullRequestTarget, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PullRequestTarget
	if *v == nil {
		sv = &types.PullRequestTarget{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "destinationCommit":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.DestinationCommit = ptr.String(jtv)
			}

		case "destinationReference":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ReferenceName to be of type string, got %T instead", value)
				}
				sv.DestinationReference = ptr.String(jtv)
			}

		case "mergeBase":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.MergeBase = ptr.String(jtv)
			}

		case "mergeMetadata":
			if err := awsAwsjson11_deserializeDocumentMergeMetadata(&sv.MergeMetadata, value); err != nil {
				return err
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		case "sourceCommit":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.SourceCommit = ptr.String(jtv)
			}

		case "sourceReference":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ReferenceName to be of type string, got %T instead", value)
				}
				sv.SourceReference = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentPullRequestTargetList(v *[]types.PullRequestTarget, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.PullRequestTarget
	if *v == nil {
		cv = []types.PullRequestTarget{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.PullRequestTarget
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentPullRequestTarget(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentPutFileEntryConflictException(v **types.PutFileEntryConflictException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.PutFileEntryConflictException
	if *v == nil {
		sv = &types.PutFileEntryConflictException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReactionCountsMap(v *map[string]int32, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]int32
	if *v == nil {
		mv = map[string]int32{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal int32
		if value != nil {
			jtv, ok := value.(json.Number)
			if !ok {
				return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
			}
			i64, err := jtv.Int64()
			if err != nil {
				return err
			}
			parsedVal = int32(i64)
		}
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsAwsjson11_deserializeDocumentReactionForComment(v **types.ReactionForComment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReactionForComment
	if *v == nil {
		sv = &types.ReactionForComment{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "reaction":
			if err := awsAwsjson11_deserializeDocumentReactionValueFormats(&sv.Reaction, value); err != nil {
				return err
			}

		case "reactionsFromDeletedUsersCount":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ReactionsFromDeletedUsersCount = ptr.Int32(int32(i64))
			}

		case "reactionUsers":
			if err := awsAwsjson11_deserializeDocumentReactionUsersList(&sv.ReactionUsers, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReactionLimitExceededException(v **types.ReactionLimitExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReactionLimitExceededException
	if *v == nil {
		sv = &types.ReactionLimitExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReactionsForCommentList(v *[]types.ReactionForComment, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ReactionForComment
	if *v == nil {
		cv = []types.ReactionForComment{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ReactionForComment
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentReactionForComment(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentReactionUsersList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentReactionValueFormats(v **types.ReactionValueFormats, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReactionValueFormats
	if *v == nil {
		sv = &types.ReactionValueFormats{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "emoji":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ReactionEmoji to be of type string, got %T instead", value)
				}
				sv.Emoji = ptr.String(jtv)
			}

		case "shortCode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ReactionShortCode to be of type string, got %T instead", value)
				}
				sv.ShortCode = ptr.String(jtv)
			}

		case "unicode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ReactionUnicode to be of type string, got %T instead", value)
				}
				sv.Unicode = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReactionValueRequiredException(v **types.ReactionValueRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReactionValueRequiredException
	if *v == nil {
		sv = &types.ReactionValueRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReferenceDoesNotExistException(v **types.ReferenceDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReferenceDoesNotExistException
	if *v == nil {
		sv = &types.ReferenceDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReferenceNameRequiredException(v **types.ReferenceNameRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReferenceNameRequiredException
	if *v == nil {
		sv = &types.ReferenceNameRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReferenceTypeNotSupportedException(v **types.ReferenceTypeNotSupportedException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReferenceTypeNotSupportedException
	if *v == nil {
		sv = &types.ReferenceTypeNotSupportedException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReplacementContentRequiredException(v **types.ReplacementContentRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReplacementContentRequiredException
	if *v == nil {
		sv = &types.ReplacementContentRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentReplacementTypeRequiredException(v **types.ReplacementTypeRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ReplacementTypeRequiredException
	if *v == nil {
		sv = &types.ReplacementTypeRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryDoesNotExistException(v **types.RepositoryDoesNotExistException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryDoesNotExistException
	if *v == nil {
		sv = &types.RepositoryDoesNotExistException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryLimitExceededException(v **types.RepositoryLimitExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryLimitExceededException
	if *v == nil {
		sv = &types.RepositoryLimitExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryMetadata(v **types.RepositoryMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryMetadata
	if *v == nil {
		sv = &types.RepositoryMetadata{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "accountId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected AccountId to be of type string, got %T instead", value)
				}
				sv.AccountId = ptr.String(jtv)
			}

		case "Arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "cloneUrlHttp":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CloneUrlHttp to be of type string, got %T instead", value)
				}
				sv.CloneUrlHttp = ptr.String(jtv)
			}

		case "cloneUrlSsh":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CloneUrlSsh to be of type string, got %T instead", value)
				}
				sv.CloneUrlSsh = ptr.String(jtv)
			}

		case "creationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected CreationDate to be a JSON Number, got %T instead", value)

				}
			}

		case "defaultBranch":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected BranchName to be of type string, got %T instead", value)
				}
				sv.DefaultBranch = ptr.String(jtv)
			}

		case "kmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected KmsKeyId to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "lastModifiedDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LastModifiedDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected LastModifiedDate to be a JSON Number, got %T instead", value)

				}
			}

		case "repositoryDescription":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryDescription to be of type string, got %T instead", value)
				}
				sv.RepositoryDescription = ptr.String(jtv)
			}

		case "repositoryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryId to be of type string, got %T instead", value)
				}
				sv.RepositoryId = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryMetadataList(v *[]types.RepositoryMetadata, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RepositoryMetadata
	if *v == nil {
		cv = []types.RepositoryMetadata{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RepositoryMetadata
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentRepositoryMetadata(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryNameExistsException(v **types.RepositoryNameExistsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryNameExistsException
	if *v == nil {
		sv = &types.RepositoryNameExistsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryNameIdPair(v **types.RepositoryNameIdPair, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryNameIdPair
	if *v == nil {
		sv = &types.RepositoryNameIdPair{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "repositoryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryId to be of type string, got %T instead", value)
				}
				sv.RepositoryId = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryNameIdPairList(v *[]types.RepositoryNameIdPair, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RepositoryNameIdPair
	if *v == nil {
		cv = []types.RepositoryNameIdPair{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RepositoryNameIdPair
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentRepositoryNameIdPair(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryNameList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryNameRequiredException(v **types.RepositoryNameRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryNameRequiredException
	if *v == nil {
		sv = &types.RepositoryNameRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryNamesRequiredException(v **types.RepositoryNamesRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryNamesRequiredException
	if *v == nil {
		sv = &types.RepositoryNamesRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryNotAssociatedWithPullRequestException(v **types.RepositoryNotAssociatedWithPullRequestException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryNotAssociatedWithPullRequestException
	if *v == nil {
		sv = &types.RepositoryNotAssociatedWithPullRequestException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryNotFoundList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTrigger(v **types.RepositoryTrigger, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryTrigger
	if *v == nil {
		sv = &types.RepositoryTrigger{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "branches":
			if err := awsAwsjson11_deserializeDocumentBranchNameList(&sv.Branches, value); err != nil {
				return err
			}

		case "customData":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryTriggerCustomData to be of type string, got %T instead", value)
				}
				sv.CustomData = ptr.String(jtv)
			}

		case "destinationArn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.DestinationArn = ptr.String(jtv)
			}

		case "events":
			if err := awsAwsjson11_deserializeDocumentRepositoryTriggerEventList(&sv.Events, value); err != nil {
				return err
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryTriggerName to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggerBranchNameListRequiredException(v **types.RepositoryTriggerBranchNameListRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryTriggerBranchNameListRequiredException
	if *v == nil {
		sv = &types.RepositoryTriggerBranchNameListRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggerDestinationArnRequiredException(v **types.RepositoryTriggerDestinationArnRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryTriggerDestinationArnRequiredException
	if *v == nil {
		sv = &types.RepositoryTriggerDestinationArnRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggerEventList(v *[]types.RepositoryTriggerEventEnum, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RepositoryTriggerEventEnum
	if *v == nil {
		cv = []types.RepositoryTriggerEventEnum{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RepositoryTriggerEventEnum
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RepositoryTriggerEventEnum to be of type string, got %T instead", value)
			}
			col = types.RepositoryTriggerEventEnum(jtv)
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggerEventsListRequiredException(v **types.RepositoryTriggerEventsListRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryTriggerEventsListRequiredException
	if *v == nil {
		sv = &types.RepositoryTriggerEventsListRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggerExecutionFailure(v **types.RepositoryTriggerExecutionFailure, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryTriggerExecutionFailure
	if *v == nil {
		sv = &types.RepositoryTriggerExecutionFailure{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "failureMessage":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryTriggerExecutionFailureMessage to be of type string, got %T instead", value)
				}
				sv.FailureMessage = ptr.String(jtv)
			}

		case "trigger":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryTriggerName to be of type string, got %T instead", value)
				}
				sv.Trigger = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggerExecutionFailureList(v *[]types.RepositoryTriggerExecutionFailure, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RepositoryTriggerExecutionFailure
	if *v == nil {
		cv = []types.RepositoryTriggerExecutionFailure{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RepositoryTriggerExecutionFailure
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentRepositoryTriggerExecutionFailure(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggerNameList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RepositoryTriggerName to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggerNameRequiredException(v **types.RepositoryTriggerNameRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryTriggerNameRequiredException
	if *v == nil {
		sv = &types.RepositoryTriggerNameRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggersList(v *[]types.RepositoryTrigger, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.RepositoryTrigger
	if *v == nil {
		cv = []types.RepositoryTrigger{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.RepositoryTrigger
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentRepositoryTrigger(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRepositoryTriggersListRequiredException(v **types.RepositoryTriggersListRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RepositoryTriggersListRequiredException
	if *v == nil {
		sv = &types.RepositoryTriggersListRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentResourceArnRequiredException(v **types.ResourceArnRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResourceArnRequiredException
	if *v == nil {
		sv = &types.ResourceArnRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRestrictedSourceFileException(v **types.RestrictedSourceFileException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RestrictedSourceFileException
	if *v == nil {
		sv = &types.RestrictedSourceFileException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRevisionChildren(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected RevisionId to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRevisionDag(v *[]types.FileVersion, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.FileVersion
	if *v == nil {
		cv = []types.FileVersion{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.FileVersion
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentFileVersion(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentRevisionIdRequiredException(v **types.RevisionIdRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RevisionIdRequiredException
	if *v == nil {
		sv = &types.RevisionIdRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentRevisionNotCurrentException(v **types.RevisionNotCurrentException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RevisionNotCurrentException
	if *v == nil {
		sv = &types.RevisionNotCurrentException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentSameFileContentException(v **types.SameFileContentException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SameFileContentException
	if *v == nil {
		sv = &types.SameFileContentException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentSamePathRequestException(v **types.SamePathRequestException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SamePathRequestException
	if *v == nil {
		sv = &types.SamePathRequestException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentSourceAndDestinationAreSameException(v **types.SourceAndDestinationAreSameException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SourceAndDestinationAreSameException
	if *v == nil {
		sv = &types.SourceAndDestinationAreSameException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentSourceFileOrContentRequiredException(v **types.SourceFileOrContentRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SourceFileOrContentRequiredException
	if *v == nil {
		sv = &types.SourceFileOrContentRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentSubModule(v **types.SubModule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SubModule
	if *v == nil {
		sv = &types.SubModule{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "absolutePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.AbsolutePath = ptr.String(jtv)
			}

		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "relativePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.RelativePath = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentSubModuleList(v *[]types.SubModule, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SubModule
	if *v == nil {
		cv = []types.SubModule{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SubModule
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentSubModule(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentSymbolicLink(v **types.SymbolicLink, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SymbolicLink
	if *v == nil {
		sv = &types.SymbolicLink{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "absolutePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.AbsolutePath = ptr.String(jtv)
			}

		case "blobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BlobId = ptr.String(jtv)
			}

		case "fileMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FileModeTypeEnum to be of type string, got %T instead", value)
				}
				sv.FileMode = types.FileModeTypeEnum(jtv)
			}

		case "relativePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.RelativePath = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentSymbolicLinkList(v *[]types.SymbolicLink, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.SymbolicLink
	if *v == nil {
		cv = []types.SymbolicLink{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.SymbolicLink
		destAddr := &col
		if err := awsAwsjson11_deserializeDocumentSymbolicLink(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson11_deserializeDocumentTagKeysListRequiredException(v **types.TagKeysListRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TagKeysListRequiredException
	if *v == nil {
		sv = &types.TagKeysListRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentTagPolicyException(v **types.TagPolicyException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TagPolicyException
	if *v == nil {
		sv = &types.TagPolicyException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentTagsMap(v *map[string]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var mv map[string]string
	if *v == nil {
		mv = map[string]string{}
	} else {
		mv = *v
	}

	for key, value := range shape {
		var parsedVal string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected TagValue to be of type string, got %T instead", value)
			}
			parsedVal = jtv
		}
		mv[key] = parsedVal

	}
	*v = mv
	return nil
}

func awsAwsjson11_deserializeDocumentTagsMapRequiredException(v **types.TagsMapRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TagsMapRequiredException
	if *v == nil {
		sv = &types.TagsMapRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentTargetRequiredException(v **types.TargetRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TargetRequiredException
	if *v == nil {
		sv = &types.TargetRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentTargetsRequiredException(v **types.TargetsRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TargetsRequiredException
	if *v == nil {
		sv = &types.TargetsRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentTipOfSourceReferenceIsDifferentException(v **types.TipOfSourceReferenceIsDifferentException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TipOfSourceReferenceIsDifferentException
	if *v == nil {
		sv = &types.TipOfSourceReferenceIsDifferentException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentTipsDivergenceExceededException(v **types.TipsDivergenceExceededException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TipsDivergenceExceededException
	if *v == nil {
		sv = &types.TipsDivergenceExceededException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentTitleRequiredException(v **types.TitleRequiredException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TitleRequiredException
	if *v == nil {
		sv = &types.TitleRequiredException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentTooManyTagsException(v **types.TooManyTagsException, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TooManyTagsException
	if *v == nil {
		sv = &types.TooManyTagsException{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message", "Message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Message to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeDocumentUserInfo(v **types.UserInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.UserInfo
	if *v == nil {
		sv = &types.UserInfo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "date":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Date to be of type string, got %T instead", value)
				}
				sv.Date = ptr.String(jtv)
			}

		case "email":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Email to be of type string, got %T instead", value)
				}
				sv.Email = ptr.String(jtv)
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Name to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentBatchAssociateApprovalRuleTemplateWithRepositoriesOutput(v **BatchAssociateApprovalRuleTemplateWithRepositoriesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchAssociateApprovalRuleTemplateWithRepositoriesOutput
	if *v == nil {
		sv = &BatchAssociateApprovalRuleTemplateWithRepositoriesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "associatedRepositoryNames":
			if err := awsAwsjson11_deserializeDocumentRepositoryNameList(&sv.AssociatedRepositoryNames, value); err != nil {
				return err
			}

		case "errors":
			if err := awsAwsjson11_deserializeDocumentBatchAssociateApprovalRuleTemplateWithRepositoriesErrorsList(&sv.Errors, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentBatchDescribeMergeConflictsOutput(v **BatchDescribeMergeConflictsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchDescribeMergeConflictsOutput
	if *v == nil {
		sv = &BatchDescribeMergeConflictsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "baseCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BaseCommitId = ptr.String(jtv)
			}

		case "conflicts":
			if err := awsAwsjson11_deserializeDocumentConflicts(&sv.Conflicts, value); err != nil {
				return err
			}

		case "destinationCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.DestinationCommitId = ptr.String(jtv)
			}

		case "errors":
			if err := awsAwsjson11_deserializeDocumentBatchDescribeMergeConflictsErrors(&sv.Errors, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "sourceCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.SourceCommitId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentBatchDisassociateApprovalRuleTemplateFromRepositoriesOutput(v **BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput
	if *v == nil {
		sv = &BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "disassociatedRepositoryNames":
			if err := awsAwsjson11_deserializeDocumentRepositoryNameList(&sv.DisassociatedRepositoryNames, value); err != nil {
				return err
			}

		case "errors":
			if err := awsAwsjson11_deserializeDocumentBatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsList(&sv.Errors, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentBatchGetCommitsOutput(v **BatchGetCommitsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchGetCommitsOutput
	if *v == nil {
		sv = &BatchGetCommitsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commits":
			if err := awsAwsjson11_deserializeDocumentCommitObjectsList(&sv.Commits, value); err != nil {
				return err
			}

		case "errors":
			if err := awsAwsjson11_deserializeDocumentBatchGetCommitsErrorsList(&sv.Errors, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentBatchGetRepositoriesOutput(v **BatchGetRepositoriesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *BatchGetRepositoriesOutput
	if *v == nil {
		sv = &BatchGetRepositoriesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "errors":
			if err := awsAwsjson11_deserializeDocumentBatchGetRepositoriesErrorsList(&sv.Errors, value); err != nil {
				return err
			}

		case "repositories":
			if err := awsAwsjson11_deserializeDocumentRepositoryMetadataList(&sv.Repositories, value); err != nil {
				return err
			}

		case "repositoriesNotFound":
			if err := awsAwsjson11_deserializeDocumentRepositoryNotFoundList(&sv.RepositoriesNotFound, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentCreateApprovalRuleTemplateOutput(v **CreateApprovalRuleTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateApprovalRuleTemplateOutput
	if *v == nil {
		sv = &CreateApprovalRuleTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplate":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleTemplate(&sv.ApprovalRuleTemplate, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentCreateCommitOutput(v **CreateCommitOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateCommitOutput
	if *v == nil {
		sv = &CreateCommitOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "filesAdded":
			if err := awsAwsjson11_deserializeDocumentFilesMetadata(&sv.FilesAdded, value); err != nil {
				return err
			}

		case "filesDeleted":
			if err := awsAwsjson11_deserializeDocumentFilesMetadata(&sv.FilesDeleted, value); err != nil {
				return err
			}

		case "filesUpdated":
			if err := awsAwsjson11_deserializeDocumentFilesMetadata(&sv.FilesUpdated, value); err != nil {
				return err
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentCreatePullRequestApprovalRuleOutput(v **CreatePullRequestApprovalRuleOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreatePullRequestApprovalRuleOutput
	if *v == nil {
		sv = &CreatePullRequestApprovalRuleOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRule":
			if err := awsAwsjson11_deserializeDocumentApprovalRule(&sv.ApprovalRule, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentCreatePullRequestOutput(v **CreatePullRequestOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreatePullRequestOutput
	if *v == nil {
		sv = &CreatePullRequestOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequest":
			if err := awsAwsjson11_deserializeDocumentPullRequest(&sv.PullRequest, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentCreateRepositoryOutput(v **CreateRepositoryOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateRepositoryOutput
	if *v == nil {
		sv = &CreateRepositoryOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "repositoryMetadata":
			if err := awsAwsjson11_deserializeDocumentRepositoryMetadata(&sv.RepositoryMetadata, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentCreateUnreferencedMergeCommitOutput(v **CreateUnreferencedMergeCommitOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CreateUnreferencedMergeCommitOutput
	if *v == nil {
		sv = &CreateUnreferencedMergeCommitOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentDeleteApprovalRuleTemplateOutput(v **DeleteApprovalRuleTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteApprovalRuleTemplateOutput
	if *v == nil {
		sv = &DeleteApprovalRuleTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplateId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleTemplateId to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleTemplateId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentDeleteBranchOutput(v **DeleteBranchOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteBranchOutput
	if *v == nil {
		sv = &DeleteBranchOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "deletedBranch":
			if err := awsAwsjson11_deserializeDocumentBranchInfo(&sv.DeletedBranch, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentDeleteCommentContentOutput(v **DeleteCommentContentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteCommentContentOutput
	if *v == nil {
		sv = &DeleteCommentContentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "comment":
			if err := awsAwsjson11_deserializeDocumentComment(&sv.Comment, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentDeleteFileOutput(v **DeleteFileOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteFileOutput
	if *v == nil {
		sv = &DeleteFileOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "blobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BlobId = ptr.String(jtv)
			}

		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "filePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.FilePath = ptr.String(jtv)
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentDeletePullRequestApprovalRuleOutput(v **DeletePullRequestApprovalRuleOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeletePullRequestApprovalRuleOutput
	if *v == nil {
		sv = &DeletePullRequestApprovalRuleOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ApprovalRuleId to be of type string, got %T instead", value)
				}
				sv.ApprovalRuleId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentDeleteRepositoryOutput(v **DeleteRepositoryOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DeleteRepositoryOutput
	if *v == nil {
		sv = &DeleteRepositoryOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "repositoryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryId to be of type string, got %T instead", value)
				}
				sv.RepositoryId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentDescribeMergeConflictsOutput(v **DescribeMergeConflictsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeMergeConflictsOutput
	if *v == nil {
		sv = &DescribeMergeConflictsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "baseCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BaseCommitId = ptr.String(jtv)
			}

		case "conflictMetadata":
			if err := awsAwsjson11_deserializeDocumentConflictMetadata(&sv.ConflictMetadata, value); err != nil {
				return err
			}

		case "destinationCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.DestinationCommitId = ptr.String(jtv)
			}

		case "mergeHunks":
			if err := awsAwsjson11_deserializeDocumentMergeHunks(&sv.MergeHunks, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "sourceCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.SourceCommitId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentDescribePullRequestEventsOutput(v **DescribePullRequestEventsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribePullRequestEventsOutput
	if *v == nil {
		sv = &DescribePullRequestEventsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "pullRequestEvents":
			if err := awsAwsjson11_deserializeDocumentPullRequestEventList(&sv.PullRequestEvents, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentEvaluatePullRequestApprovalRulesOutput(v **EvaluatePullRequestApprovalRulesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *EvaluatePullRequestApprovalRulesOutput
	if *v == nil {
		sv = &EvaluatePullRequestApprovalRulesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "evaluation":
			if err := awsAwsjson11_deserializeDocumentEvaluation(&sv.Evaluation, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetApprovalRuleTemplateOutput(v **GetApprovalRuleTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetApprovalRuleTemplateOutput
	if *v == nil {
		sv = &GetApprovalRuleTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplate":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleTemplate(&sv.ApprovalRuleTemplate, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetBlobOutput(v **GetBlobOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetBlobOutput
	if *v == nil {
		sv = &GetBlobOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "content":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected blob to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode blob, %w", err)
				}
				sv.Content = dv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetBranchOutput(v **GetBranchOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetBranchOutput
	if *v == nil {
		sv = &GetBranchOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "branch":
			if err := awsAwsjson11_deserializeDocumentBranchInfo(&sv.Branch, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetCommentOutput(v **GetCommentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCommentOutput
	if *v == nil {
		sv = &GetCommentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "comment":
			if err := awsAwsjson11_deserializeDocumentComment(&sv.Comment, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetCommentReactionsOutput(v **GetCommentReactionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCommentReactionsOutput
	if *v == nil {
		sv = &GetCommentReactionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "reactionsForComment":
			if err := awsAwsjson11_deserializeDocumentReactionsForCommentList(&sv.ReactionsForComment, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetCommentsForComparedCommitOutput(v **GetCommentsForComparedCommitOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCommentsForComparedCommitOutput
	if *v == nil {
		sv = &GetCommentsForComparedCommitOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commentsForComparedCommitData":
			if err := awsAwsjson11_deserializeDocumentCommentsForComparedCommitData(&sv.CommentsForComparedCommitData, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetCommentsForPullRequestOutput(v **GetCommentsForPullRequestOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCommentsForPullRequestOutput
	if *v == nil {
		sv = &GetCommentsForPullRequestOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commentsForPullRequestData":
			if err := awsAwsjson11_deserializeDocumentCommentsForPullRequestData(&sv.CommentsForPullRequestData, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetCommitOutput(v **GetCommitOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetCommitOutput
	if *v == nil {
		sv = &GetCommitOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commit":
			if err := awsAwsjson11_deserializeDocumentCommit(&sv.Commit, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetDifferencesOutput(v **GetDifferencesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetDifferencesOutput
	if *v == nil {
		sv = &GetDifferencesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "differences":
			if err := awsAwsjson11_deserializeDocumentDifferenceList(&sv.Differences, value); err != nil {
				return err
			}

		case "NextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetFileOutput(v **GetFileOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetFileOutput
	if *v == nil {
		sv = &GetFileOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "blobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BlobId = ptr.String(jtv)
			}

		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "fileContent":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FileContent to be []byte, got %T instead", value)
				}
				dv, err := base64.StdEncoding.DecodeString(jtv)
				if err != nil {
					return fmt.Errorf("failed to base64 decode FileContent, %w", err)
				}
				sv.FileContent = dv
			}

		case "fileMode":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FileModeTypeEnum to be of type string, got %T instead", value)
				}
				sv.FileMode = types.FileModeTypeEnum(jtv)
			}

		case "filePath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.FilePath = ptr.String(jtv)
			}

		case "fileSize":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected ObjectSize to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.FileSize = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetFolderOutput(v **GetFolderOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetFolderOutput
	if *v == nil {
		sv = &GetFolderOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "files":
			if err := awsAwsjson11_deserializeDocumentFileList(&sv.Files, value); err != nil {
				return err
			}

		case "folderPath":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Path to be of type string, got %T instead", value)
				}
				sv.FolderPath = ptr.String(jtv)
			}

		case "subFolders":
			if err := awsAwsjson11_deserializeDocumentFolderList(&sv.SubFolders, value); err != nil {
				return err
			}

		case "subModules":
			if err := awsAwsjson11_deserializeDocumentSubModuleList(&sv.SubModules, value); err != nil {
				return err
			}

		case "symbolicLinks":
			if err := awsAwsjson11_deserializeDocumentSymbolicLinkList(&sv.SymbolicLinks, value); err != nil {
				return err
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetMergeCommitOutput(v **GetMergeCommitOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetMergeCommitOutput
	if *v == nil {
		sv = &GetMergeCommitOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "baseCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BaseCommitId = ptr.String(jtv)
			}

		case "destinationCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.DestinationCommitId = ptr.String(jtv)
			}

		case "mergedCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.MergedCommitId = ptr.String(jtv)
			}

		case "sourceCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.SourceCommitId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetMergeConflictsOutput(v **GetMergeConflictsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetMergeConflictsOutput
	if *v == nil {
		sv = &GetMergeConflictsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "baseCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BaseCommitId = ptr.String(jtv)
			}

		case "conflictMetadataList":
			if err := awsAwsjson11_deserializeDocumentConflictMetadataList(&sv.ConflictMetadataList, value); err != nil {
				return err
			}

		case "destinationCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.DestinationCommitId = ptr.String(jtv)
			}

		case "mergeable":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected IsMergeable to be of type *bool, got %T instead", value)
				}
				sv.Mergeable = jtv
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "sourceCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.SourceCommitId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetMergeOptionsOutput(v **GetMergeOptionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetMergeOptionsOutput
	if *v == nil {
		sv = &GetMergeOptionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "baseCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BaseCommitId = ptr.String(jtv)
			}

		case "destinationCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.DestinationCommitId = ptr.String(jtv)
			}

		case "mergeOptions":
			if err := awsAwsjson11_deserializeDocumentMergeOptions(&sv.MergeOptions, value); err != nil {
				return err
			}

		case "sourceCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.SourceCommitId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetPullRequestApprovalStatesOutput(v **GetPullRequestApprovalStatesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetPullRequestApprovalStatesOutput
	if *v == nil {
		sv = &GetPullRequestApprovalStatesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvals":
			if err := awsAwsjson11_deserializeDocumentApprovalList(&sv.Approvals, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetPullRequestOutput(v **GetPullRequestOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetPullRequestOutput
	if *v == nil {
		sv = &GetPullRequestOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequest":
			if err := awsAwsjson11_deserializeDocumentPullRequest(&sv.PullRequest, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetPullRequestOverrideStateOutput(v **GetPullRequestOverrideStateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetPullRequestOverrideStateOutput
	if *v == nil {
		sv = &GetPullRequestOverrideStateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "overridden":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Overridden to be of type *bool, got %T instead", value)
				}
				sv.Overridden = jtv
			}

		case "overrider":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.Overrider = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetRepositoryOutput(v **GetRepositoryOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetRepositoryOutput
	if *v == nil {
		sv = &GetRepositoryOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "repositoryMetadata":
			if err := awsAwsjson11_deserializeDocumentRepositoryMetadata(&sv.RepositoryMetadata, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentGetRepositoryTriggersOutput(v **GetRepositoryTriggersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetRepositoryTriggersOutput
	if *v == nil {
		sv = &GetRepositoryTriggersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "configurationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryTriggersConfigurationId to be of type string, got %T instead", value)
				}
				sv.ConfigurationId = ptr.String(jtv)
			}

		case "triggers":
			if err := awsAwsjson11_deserializeDocumentRepositoryTriggersList(&sv.Triggers, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentListApprovalRuleTemplatesOutput(v **ListApprovalRuleTemplatesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListApprovalRuleTemplatesOutput
	if *v == nil {
		sv = &ListApprovalRuleTemplatesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplateNames":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleTemplateNameList(&sv.ApprovalRuleTemplateNames, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentListAssociatedApprovalRuleTemplatesForRepositoryOutput(v **ListAssociatedApprovalRuleTemplatesForRepositoryOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListAssociatedApprovalRuleTemplatesForRepositoryOutput
	if *v == nil {
		sv = &ListAssociatedApprovalRuleTemplatesForRepositoryOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplateNames":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleTemplateNameList(&sv.ApprovalRuleTemplateNames, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentListBranchesOutput(v **ListBranchesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListBranchesOutput
	if *v == nil {
		sv = &ListBranchesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "branches":
			if err := awsAwsjson11_deserializeDocumentBranchNameList(&sv.Branches, value); err != nil {
				return err
			}

		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentListFileCommitHistoryOutput(v **ListFileCommitHistoryOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListFileCommitHistoryOutput
	if *v == nil {
		sv = &ListFileCommitHistoryOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "revisionDag":
			if err := awsAwsjson11_deserializeDocumentRevisionDag(&sv.RevisionDag, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentListPullRequestsOutput(v **ListPullRequestsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListPullRequestsOutput
	if *v == nil {
		sv = &ListPullRequestsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "pullRequestIds":
			if err := awsAwsjson11_deserializeDocumentPullRequestIdList(&sv.PullRequestIds, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentListRepositoriesForApprovalRuleTemplateOutput(v **ListRepositoriesForApprovalRuleTemplateOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListRepositoriesForApprovalRuleTemplateOutput
	if *v == nil {
		sv = &ListRepositoriesForApprovalRuleTemplateOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "repositoryNames":
			if err := awsAwsjson11_deserializeDocumentRepositoryNameList(&sv.RepositoryNames, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentListRepositoriesOutput(v **ListRepositoriesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListRepositoriesOutput
	if *v == nil {
		sv = &ListRepositoriesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "repositories":
			if err := awsAwsjson11_deserializeDocumentRepositoryNameIdPairList(&sv.Repositories, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentListTagsForResourceOutput(v **ListTagsForResourceOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListTagsForResourceOutput
	if *v == nil {
		sv = &ListTagsForResourceOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected NextToken to be of type string, got %T instead", value)
				}
				sv.NextToken = ptr.String(jtv)
			}

		case "tags":
			if err := awsAwsjson11_deserializeDocumentTagsMap(&sv.Tags, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentMergeBranchesByFastForwardOutput(v **MergeBranchesByFastForwardOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *MergeBranchesByFastForwardOutput
	if *v == nil {
		sv = &MergeBranchesByFastForwardOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentMergeBranchesBySquashOutput(v **MergeBranchesBySquashOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *MergeBranchesBySquashOutput
	if *v == nil {
		sv = &MergeBranchesBySquashOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentMergeBranchesByThreeWayOutput(v **MergeBranchesByThreeWayOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *MergeBranchesByThreeWayOutput
	if *v == nil {
		sv = &MergeBranchesByThreeWayOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentMergePullRequestByFastForwardOutput(v **MergePullRequestByFastForwardOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *MergePullRequestByFastForwardOutput
	if *v == nil {
		sv = &MergePullRequestByFastForwardOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequest":
			if err := awsAwsjson11_deserializeDocumentPullRequest(&sv.PullRequest, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentMergePullRequestBySquashOutput(v **MergePullRequestBySquashOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *MergePullRequestBySquashOutput
	if *v == nil {
		sv = &MergePullRequestBySquashOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequest":
			if err := awsAwsjson11_deserializeDocumentPullRequest(&sv.PullRequest, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentMergePullRequestByThreeWayOutput(v **MergePullRequestByThreeWayOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *MergePullRequestByThreeWayOutput
	if *v == nil {
		sv = &MergePullRequestByThreeWayOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequest":
			if err := awsAwsjson11_deserializeDocumentPullRequest(&sv.PullRequest, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentPostCommentForComparedCommitOutput(v **PostCommentForComparedCommitOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PostCommentForComparedCommitOutput
	if *v == nil {
		sv = &PostCommentForComparedCommitOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "afterBlobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.AfterBlobId = ptr.String(jtv)
			}

		case "afterCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.AfterCommitId = ptr.String(jtv)
			}

		case "beforeBlobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BeforeBlobId = ptr.String(jtv)
			}

		case "beforeCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.BeforeCommitId = ptr.String(jtv)
			}

		case "comment":
			if err := awsAwsjson11_deserializeDocumentComment(&sv.Comment, value); err != nil {
				return err
			}

		case "location":
			if err := awsAwsjson11_deserializeDocumentLocation(&sv.Location, value); err != nil {
				return err
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentPostCommentForPullRequestOutput(v **PostCommentForPullRequestOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PostCommentForPullRequestOutput
	if *v == nil {
		sv = &PostCommentForPullRequestOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "afterBlobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.AfterBlobId = ptr.String(jtv)
			}

		case "afterCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.AfterCommitId = ptr.String(jtv)
			}

		case "beforeBlobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BeforeBlobId = ptr.String(jtv)
			}

		case "beforeCommitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CommitId to be of type string, got %T instead", value)
				}
				sv.BeforeCommitId = ptr.String(jtv)
			}

		case "comment":
			if err := awsAwsjson11_deserializeDocumentComment(&sv.Comment, value); err != nil {
				return err
			}

		case "location":
			if err := awsAwsjson11_deserializeDocumentLocation(&sv.Location, value); err != nil {
				return err
			}

		case "pullRequestId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PullRequestId to be of type string, got %T instead", value)
				}
				sv.PullRequestId = ptr.String(jtv)
			}

		case "repositoryName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryName to be of type string, got %T instead", value)
				}
				sv.RepositoryName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentPostCommentReplyOutput(v **PostCommentReplyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PostCommentReplyOutput
	if *v == nil {
		sv = &PostCommentReplyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "comment":
			if err := awsAwsjson11_deserializeDocumentComment(&sv.Comment, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentPutFileOutput(v **PutFileOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PutFileOutput
	if *v == nil {
		sv = &PutFileOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "blobId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.BlobId = ptr.String(jtv)
			}

		case "commitId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.CommitId = ptr.String(jtv)
			}

		case "treeId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ObjectId to be of type string, got %T instead", value)
				}
				sv.TreeId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentPutRepositoryTriggersOutput(v **PutRepositoryTriggersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PutRepositoryTriggersOutput
	if *v == nil {
		sv = &PutRepositoryTriggersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "configurationId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryTriggersConfigurationId to be of type string, got %T instead", value)
				}
				sv.ConfigurationId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentTestRepositoryTriggersOutput(v **TestRepositoryTriggersOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *TestRepositoryTriggersOutput
	if *v == nil {
		sv = &TestRepositoryTriggersOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "failedExecutions":
			if err := awsAwsjson11_deserializeDocumentRepositoryTriggerExecutionFailureList(&sv.FailedExecutions, value); err != nil {
				return err
			}

		case "successfulExecutions":
			if err := awsAwsjson11_deserializeDocumentRepositoryTriggerNameList(&sv.SuccessfulExecutions, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdateApprovalRuleTemplateContentOutput(v **UpdateApprovalRuleTemplateContentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateApprovalRuleTemplateContentOutput
	if *v == nil {
		sv = &UpdateApprovalRuleTemplateContentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplate":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleTemplate(&sv.ApprovalRuleTemplate, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdateApprovalRuleTemplateDescriptionOutput(v **UpdateApprovalRuleTemplateDescriptionOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateApprovalRuleTemplateDescriptionOutput
	if *v == nil {
		sv = &UpdateApprovalRuleTemplateDescriptionOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplate":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleTemplate(&sv.ApprovalRuleTemplate, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdateApprovalRuleTemplateNameOutput(v **UpdateApprovalRuleTemplateNameOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateApprovalRuleTemplateNameOutput
	if *v == nil {
		sv = &UpdateApprovalRuleTemplateNameOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRuleTemplate":
			if err := awsAwsjson11_deserializeDocumentApprovalRuleTemplate(&sv.ApprovalRuleTemplate, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdateCommentOutput(v **UpdateCommentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateCommentOutput
	if *v == nil {
		sv = &UpdateCommentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "comment":
			if err := awsAwsjson11_deserializeDocumentComment(&sv.Comment, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdatePullRequestApprovalRuleContentOutput(v **UpdatePullRequestApprovalRuleContentOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdatePullRequestApprovalRuleContentOutput
	if *v == nil {
		sv = &UpdatePullRequestApprovalRuleContentOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "approvalRule":
			if err := awsAwsjson11_deserializeDocumentApprovalRule(&sv.ApprovalRule, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdatePullRequestDescriptionOutput(v **UpdatePullRequestDescriptionOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdatePullRequestDescriptionOutput
	if *v == nil {
		sv = &UpdatePullRequestDescriptionOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequest":
			if err := awsAwsjson11_deserializeDocumentPullRequest(&sv.PullRequest, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdatePullRequestStatusOutput(v **UpdatePullRequestStatusOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdatePullRequestStatusOutput
	if *v == nil {
		sv = &UpdatePullRequestStatusOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequest":
			if err := awsAwsjson11_deserializeDocumentPullRequest(&sv.PullRequest, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdatePullRequestTitleOutput(v **UpdatePullRequestTitleOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdatePullRequestTitleOutput
	if *v == nil {
		sv = &UpdatePullRequestTitleOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "pullRequest":
			if err := awsAwsjson11_deserializeDocumentPullRequest(&sv.PullRequest, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson11_deserializeOpDocumentUpdateRepositoryEncryptionKeyOutput(v **UpdateRepositoryEncryptionKeyOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *UpdateRepositoryEncryptionKeyOutput
	if *v == nil {
		sv = &UpdateRepositoryEncryptionKeyOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "kmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected KmsKeyId to be of type string, got %T instead", value)
				}
				sv.KmsKeyId = ptr.String(jtv)
			}

		case "originalKmsKeyId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected KmsKeyId to be of type string, got %T instead", value)
				}
				sv.OriginalKmsKeyId = ptr.String(jtv)
			}

		case "repositoryId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RepositoryId to be of type string, got %T instead", value)
				}
				sv.RepositoryId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type protocolErrorInfo struct {
	Type    string `json:"__type"`
	Message string
	Code    any // nonstandard for awsjson but some services do present the type here
}

func getProtocolErrorInfo(decoder *json.Decoder) (protocolErrorInfo, error) {
	var errInfo protocolErrorInfo
	if err := decoder.Decode(&errInfo); err != nil {
		if err == io.EOF {
			return errInfo, nil
		}
		return errInfo, err
	}

	return errInfo, nil
}

func resolveProtocolErrorType(headerType string, bodyInfo protocolErrorInfo) (string, bool) {
	if len(headerType) != 0 {
		return headerType, true
	} else if len(bodyInfo.Type) != 0 {
		return bodyInfo.Type, true
	} else if code, ok := bodyInfo.Code.(string); ok && len(code) != 0 {
		return code, true
	}
	return "", false
}
