// Code generated by smithy-go-codegen DO NOT EDIT.

package sts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a signed JSON Web Token (JWT) that represents the calling Amazon Web
// Services identity. The returned JWT can be used to authenticate with external
// services that support OIDC discovery. The token is signed by Amazon Web Services
// STS and can be publicly verified using the verification keys published at the
// issuer's JWKS endpoint.
func (c *Client) GetWebIdentityToken(ctx context.Context, params *GetWebIdentityTokenInput, optFns ...func(*Options)) (*GetWebIdentityTokenOutput, error) {
	if params == nil {
		params = &GetWebIdentityTokenInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetWebIdentityToken", params, optFns, c.addOperationGetWebIdentityTokenMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetWebIdentityTokenOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetWebIdentityTokenInput struct {

	// The intended recipient of the web identity token. This value populates the aud
	// claim in the JWT and should identify the service or application that will
	// validate and use the token. The external service should verify this claim to
	// ensure the token was intended for their use.
	//
	// This member is required.
	Audience []string

	// The cryptographic algorithm to use for signing the JSON Web Token (JWT). Valid
	// values are RS256 (RSA with SHA-256) and ES384 (ECDSA using P-384 curve with
	// SHA-384).
	//
	// This member is required.
	SigningAlgorithm *string

	// The duration, in seconds, for which the JSON Web Token (JWT) will remain valid.
	// The value can range from 60 seconds (1 minute) to 3600 seconds (1 hour). If not
	// specified, the default duration is 300 seconds (5 minutes). The token is
	// designed to be short-lived and should be used for proof of identity, then
	// exchanged for credentials or short-lived tokens in the external service.
	DurationSeconds *int32

	// An optional list of tags to include in the JSON Web Token (JWT). These tags are
	// added as custom claims to the JWT and can be used by the downstream service for
	// authorization decisions.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type GetWebIdentityTokenOutput struct {

	// The date and time when the web identity token expires, in UTC. The expiration
	// is determined by adding the DurationSeconds value to the time the token was
	// issued. After this time, the token should no longer be considered valid.
	Expiration *time.Time

	// A signed JSON Web Token (JWT) that represents the caller's Amazon Web Services
	// identity. The token contains standard JWT claims such as subject, audience,
	// expiration time, and additional identity attributes added by STS as custom
	// claims. You can also add your own custom claims to the token by passing tags as
	// request parameters to the GetWebIdentityToken API. The token is signed using
	// the specified signing algorithm and can be verified using the verification keys
	// available at the issuer's JWKS endpoint.
	WebIdentityToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetWebIdentityTokenMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpGetWebIdentityToken{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpGetWebIdentityToken{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetWebIdentityToken"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetWebIdentityTokenValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetWebIdentityToken(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetWebIdentityToken(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetWebIdentityToken",
	}
}
