// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>The request is denied because you do not have sufficient permissions to perform the requested action. For troubleshooting this error, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-access-denied">AccessDeniedException</a> in the Amazon Bedrock User Guide</p>
    AccessDeniedException(crate::types::error::AccessDeniedException),
    /// <p>Error occurred because of a conflict while performing an operation.</p>
    ConflictException(crate::types::error::ConflictException),
    /// <p>An internal server error occurred. For troubleshooting this error, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-internal-failure">InternalFailure</a> in the Amazon Bedrock User Guide</p>
    InternalServerException(crate::types::error::InternalServerException),
    /// <p>The request failed due to an error while processing the model.</p>
    ModelErrorException(crate::types::error::ModelErrorException),
    /// <p>The model specified in the request is not ready to serve inference requests. The AWS SDK will automatically retry the operation up to 5 times. For information about configuring automatic retries, see <a href="https://docs.aws.amazon.com/sdkref/latest/guide/feature-retry-behavior.html">Retry behavior</a> in the <i>AWS SDKs and Tools</i> reference guide.</p>
    ModelNotReadyException(crate::types::error::ModelNotReadyException),
    /// <p>An error occurred while streaming the response. Retry your request.</p>
    ModelStreamErrorException(crate::types::error::ModelStreamErrorException),
    /// <p>The request took too long to process. Processing time exceeded the model timeout length.</p>
    ModelTimeoutException(crate::types::error::ModelTimeoutException),
    /// <p>The specified resource ARN was not found. For troubleshooting this error, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-resource-not-found">ResourceNotFound</a> in the Amazon Bedrock User Guide</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>Your request exceeds the service quota for your account. You can view your quotas at <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/gs-request-quota.html">Viewing service quotas</a>. You can resubmit your request later.</p>
    ServiceQuotaExceededException(crate::types::error::ServiceQuotaExceededException),
    /// <p>The service isn't currently available. For troubleshooting this error, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-service-unavailable">ServiceUnavailable</a> in the Amazon Bedrock User Guide</p>
    ServiceUnavailableException(crate::types::error::ServiceUnavailableException),
    /// <p>Your request was denied due to exceeding the account quotas for <i>Amazon Bedrock</i>. For troubleshooting this error, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-throttling-exception">ThrottlingException</a> in the Amazon Bedrock User Guide</p>
    ThrottlingException(crate::types::error::ThrottlingException),
    /// <p>The input fails to satisfy the constraints specified by <i>Amazon Bedrock</i>. For troubleshooting this error, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html#ts-validation-error">ValidationError</a> in the Amazon Bedrock User Guide</p>
    ValidationException(crate::types::error::ValidationException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::ConflictException(inner) => inner.fmt(f),
            Error::InternalServerException(inner) => inner.fmt(f),
            Error::ModelErrorException(inner) => inner.fmt(f),
            Error::ModelNotReadyException(inner) => inner.fmt(f),
            Error::ModelStreamErrorException(inner) => inner.fmt(f),
            Error::ModelTimeoutException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::ServiceQuotaExceededException(inner) => inner.fmt(f),
            Error::ServiceUnavailableException(inner) => inner.fmt(f),
            Error::ThrottlingException(inner) => inner.fmt(f),
            Error::ValidationException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::AccessDeniedException(inner) => inner.meta(),
            Self::ConflictException(inner) => inner.meta(),
            Self::InternalServerException(inner) => inner.meta(),
            Self::ModelErrorException(inner) => inner.meta(),
            Self::ModelNotReadyException(inner) => inner.meta(),
            Self::ModelStreamErrorException(inner) => inner.meta(),
            Self::ModelTimeoutException(inner) => inner.meta(),
            Self::ResourceNotFoundException(inner) => inner.meta(),
            Self::ServiceQuotaExceededException(inner) => inner.meta(),
            Self::ServiceUnavailableException(inner) => inner.meta(),
            Self::ThrottlingException(inner) => inner.meta(),
            Self::ValidationException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::apply_guardrail::ApplyGuardrailError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::apply_guardrail::ApplyGuardrailError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::apply_guardrail::ApplyGuardrailError> for Error {
    fn from(err: crate::operation::apply_guardrail::ApplyGuardrailError) -> Self {
        match err {
            crate::operation::apply_guardrail::ApplyGuardrailError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::apply_guardrail::ApplyGuardrailError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::apply_guardrail::ApplyGuardrailError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::operation::apply_guardrail::ApplyGuardrailError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::apply_guardrail::ApplyGuardrailError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::apply_guardrail::ApplyGuardrailError::ServiceQuotaExceededException(inner) => {
                Error::ServiceQuotaExceededException(inner)
            }
            crate::operation::apply_guardrail::ApplyGuardrailError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::converse::ConverseError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::converse::ConverseError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::converse::ConverseError> for Error {
    fn from(err: crate::operation::converse::ConverseError) -> Self {
        match err {
            crate::operation::converse::ConverseError::ModelTimeoutException(inner) => Error::ModelTimeoutException(inner),
            crate::operation::converse::ConverseError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::converse::ConverseError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::converse::ConverseError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::operation::converse::ConverseError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::operation::converse::ConverseError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::converse::ConverseError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::converse::ConverseError::ModelNotReadyException(inner) => Error::ModelNotReadyException(inner),
            crate::operation::converse::ConverseError::ModelErrorException(inner) => Error::ModelErrorException(inner),
            crate::operation::converse::ConverseError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::converse_stream::ConverseStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::converse_stream::ConverseStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::converse_stream::ConverseStreamError> for Error {
    fn from(err: crate::operation::converse_stream::ConverseStreamError) -> Self {
        match err {
            crate::operation::converse_stream::ConverseStreamError::ModelTimeoutException(inner) => Error::ModelTimeoutException(inner),
            crate::operation::converse_stream::ConverseStreamError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::converse_stream::ConverseStreamError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::converse_stream::ConverseStreamError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::operation::converse_stream::ConverseStreamError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::operation::converse_stream::ConverseStreamError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::converse_stream::ConverseStreamError::ModelStreamErrorException(inner) => Error::ModelStreamErrorException(inner),
            crate::operation::converse_stream::ConverseStreamError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::converse_stream::ConverseStreamError::ModelNotReadyException(inner) => Error::ModelNotReadyException(inner),
            crate::operation::converse_stream::ConverseStreamError::ModelErrorException(inner) => Error::ModelErrorException(inner),
            crate::operation::converse_stream::ConverseStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_async_invoke::GetAsyncInvokeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_async_invoke::GetAsyncInvokeError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_async_invoke::GetAsyncInvokeError> for Error {
    fn from(err: crate::operation::get_async_invoke::GetAsyncInvokeError) -> Self {
        match err {
            crate::operation::get_async_invoke::GetAsyncInvokeError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::get_async_invoke::GetAsyncInvokeError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::operation::get_async_invoke::GetAsyncInvokeError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::get_async_invoke::GetAsyncInvokeError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::get_async_invoke::GetAsyncInvokeError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::invoke_model::InvokeModelError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::invoke_model::InvokeModelError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::invoke_model::InvokeModelError> for Error {
    fn from(err: crate::operation::invoke_model::InvokeModelError) -> Self {
        match err {
            crate::operation::invoke_model::InvokeModelError::ModelTimeoutException(inner) => Error::ModelTimeoutException(inner),
            crate::operation::invoke_model::InvokeModelError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::invoke_model::InvokeModelError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::invoke_model::InvokeModelError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::operation::invoke_model::InvokeModelError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::operation::invoke_model::InvokeModelError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::invoke_model::InvokeModelError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::invoke_model::InvokeModelError::ModelNotReadyException(inner) => Error::ModelNotReadyException(inner),
            crate::operation::invoke_model::InvokeModelError::ModelErrorException(inner) => Error::ModelErrorException(inner),
            crate::operation::invoke_model::InvokeModelError::ServiceQuotaExceededException(inner) => Error::ServiceQuotaExceededException(inner),
            crate::operation::invoke_model::InvokeModelError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError> for Error {
    fn from(err: crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError) -> Self {
        match err {
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ModelTimeoutException(inner) => {
                Error::ModelTimeoutException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ThrottlingException(inner) => {
                Error::ThrottlingException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ModelStreamErrorException(inner) => {
                Error::ModelStreamErrorException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ModelNotReadyException(inner) => {
                Error::ModelNotReadyException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ModelErrorException(inner) => {
                Error::ModelErrorException(inner)
            }
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::ServiceQuotaExceededException(
                inner,
            ) => Error::ServiceQuotaExceededException(inner),
            crate::operation::invoke_model_with_bidirectional_stream::InvokeModelWithBidirectionalStreamError::Unhandled(inner) => {
                Error::Unhandled(inner)
            }
        }
    }
}
impl<R>
    From<
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError,
            R,
        >,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError> for Error {
    fn from(err: crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError) -> Self {
        match err {
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ModelTimeoutException(inner) => {
                Error::ModelTimeoutException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::AccessDeniedException(inner) => {
                Error::AccessDeniedException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ThrottlingException(inner) => {
                Error::ThrottlingException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ModelStreamErrorException(inner) => {
                Error::ModelStreamErrorException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ValidationException(inner) => {
                Error::ValidationException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ModelNotReadyException(inner) => {
                Error::ModelNotReadyException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ModelErrorException(inner) => {
                Error::ModelErrorException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::ServiceQuotaExceededException(inner) => {
                Error::ServiceQuotaExceededException(inner)
            }
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_async_invokes::ListAsyncInvokesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_async_invokes::ListAsyncInvokesError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_async_invokes::ListAsyncInvokesError> for Error {
    fn from(err: crate::operation::list_async_invokes::ListAsyncInvokesError) -> Self {
        match err {
            crate::operation::list_async_invokes::ListAsyncInvokesError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::list_async_invokes::ListAsyncInvokesError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::operation::list_async_invokes::ListAsyncInvokesError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::list_async_invokes::ListAsyncInvokesError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::list_async_invokes::ListAsyncInvokesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_async_invoke::StartAsyncInvokeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_async_invoke::StartAsyncInvokeError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_async_invoke::StartAsyncInvokeError> for Error {
    fn from(err: crate::operation::start_async_invoke::StartAsyncInvokeError) -> Self {
        match err {
            crate::operation::start_async_invoke::StartAsyncInvokeError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::start_async_invoke::StartAsyncInvokeError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::start_async_invoke::StartAsyncInvokeError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::operation::start_async_invoke::StartAsyncInvokeError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::operation::start_async_invoke::StartAsyncInvokeError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::start_async_invoke::StartAsyncInvokeError::ConflictException(inner) => Error::ConflictException(inner),
            crate::operation::start_async_invoke::StartAsyncInvokeError::ValidationException(inner) => Error::ValidationException(inner),
            crate::operation::start_async_invoke::StartAsyncInvokeError::ServiceQuotaExceededException(inner) => {
                Error::ServiceQuotaExceededException(inner)
            }
            crate::operation::start_async_invoke::StartAsyncInvokeError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::ConverseStreamOutputError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::ConverseStreamOutputError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::ConverseStreamOutputError> for Error {
    fn from(err: crate::types::error::ConverseStreamOutputError) -> Self {
        match err {
            crate::types::error::ConverseStreamOutputError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::types::error::ConverseStreamOutputError::ModelStreamErrorException(inner) => Error::ModelStreamErrorException(inner),
            crate::types::error::ConverseStreamOutputError::ValidationException(inner) => Error::ValidationException(inner),
            crate::types::error::ConverseStreamOutputError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::types::error::ConverseStreamOutputError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::types::error::ConverseStreamOutputError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::InvokeModelWithBidirectionalStreamInputError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::InvokeModelWithBidirectionalStreamInputError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::InvokeModelWithBidirectionalStreamInputError> for Error {
    fn from(err: crate::types::error::InvokeModelWithBidirectionalStreamInputError) -> Self {
        match err {
            crate::types::error::InvokeModelWithBidirectionalStreamInputError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::InvokeModelWithBidirectionalStreamOutputError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::InvokeModelWithBidirectionalStreamOutputError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::InvokeModelWithBidirectionalStreamOutputError> for Error {
    fn from(err: crate::types::error::InvokeModelWithBidirectionalStreamOutputError) -> Self {
        match err {
            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ModelStreamErrorException(inner) => {
                Error::ModelStreamErrorException(inner)
            }
            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ValidationException(inner) => Error::ValidationException(inner),
            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ModelTimeoutException(inner) => Error::ModelTimeoutException(inner),
            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::ServiceUnavailableException(inner) => {
                Error::ServiceUnavailableException(inner)
            }
            crate::types::error::InvokeModelWithBidirectionalStreamOutputError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::ResponseStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::types::error::ResponseStreamError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::types::error::ResponseStreamError> for Error {
    fn from(err: crate::types::error::ResponseStreamError) -> Self {
        match err {
            crate::types::error::ResponseStreamError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::types::error::ResponseStreamError::ModelStreamErrorException(inner) => Error::ModelStreamErrorException(inner),
            crate::types::error::ResponseStreamError::ValidationException(inner) => Error::ValidationException(inner),
            crate::types::error::ResponseStreamError::ThrottlingException(inner) => Error::ThrottlingException(inner),
            crate::types::error::ResponseStreamError::ModelTimeoutException(inner) => Error::ModelTimeoutException(inner),
            crate::types::error::ResponseStreamError::ServiceUnavailableException(inner) => Error::ServiceUnavailableException(inner),
            crate::types::error::ResponseStreamError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::AccessDeniedException(inner) => inner.source(),
            Error::ConflictException(inner) => inner.source(),
            Error::InternalServerException(inner) => inner.source(),
            Error::ModelErrorException(inner) => inner.source(),
            Error::ModelNotReadyException(inner) => inner.source(),
            Error::ModelStreamErrorException(inner) => inner.source(),
            Error::ModelTimeoutException(inner) => inner.source(),
            Error::ResourceNotFoundException(inner) => inner.source(),
            Error::ServiceQuotaExceededException(inner) => inner.source(),
            Error::ServiceUnavailableException(inner) => inner.source(),
            Error::ThrottlingException(inner) => inner.source(),
            Error::ValidationException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::AccessDeniedException(e) => e.request_id(),
            Self::ConflictException(e) => e.request_id(),
            Self::InternalServerException(e) => e.request_id(),
            Self::ModelErrorException(e) => e.request_id(),
            Self::ModelNotReadyException(e) => e.request_id(),
            Self::ModelStreamErrorException(e) => e.request_id(),
            Self::ModelTimeoutException(e) => e.request_id(),
            Self::ResourceNotFoundException(e) => e.request_id(),
            Self::ServiceQuotaExceededException(e) => e.request_id(),
            Self::ServiceUnavailableException(e) => e.request_id(),
            Self::ThrottlingException(e) => e.request_id(),
            Self::ValidationException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
