/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;

public class SQLSequenceCharacterIterator
implements CharacterIterator {
    private int index = -1;
    private final CharSequence sequence;
    private final int first;
    private final int last;

    private void invariant() {
        Assert.isTrue((this.index >= this.first ? 1 : 0) != 0);
        Assert.isTrue((this.index <= this.last ? 1 : 0) != 0);
    }

    public SQLSequenceCharacterIterator(CharSequence sequence) {
        this(sequence, 0);
    }

    public SQLSequenceCharacterIterator(CharSequence sequence, int first) throws IllegalArgumentException {
        this(sequence, first, sequence.length());
    }

    public SQLSequenceCharacterIterator(CharSequence sequence, int first, int last) throws IllegalArgumentException {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (first >= 0 && first <= last) {
            if (last > sequence.length()) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.sequence = sequence;
        this.first = first;
        this.last = last;
        this.index = first;
        this.invariant();
    }

    @Override
    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    @Override
    public char last() {
        return this.first == this.last ? this.setIndex(this.getEndIndex()) : this.setIndex(this.getEndIndex() - 1);
    }

    @Override
    public char current() {
        return this.index >= this.first && this.index < this.last ? this.sequence.charAt(this.index) : (char)'\uffff';
    }

    @Override
    public char next() {
        return this.setIndex(Math.min(this.index + 1, this.getEndIndex()));
    }

    @Override
    public char previous() {
        return this.index > this.getBeginIndex() ? this.setIndex(this.index - 1) : (char)'\uffff';
    }

    @Override
    public char setIndex(int position) {
        if (position >= this.getBeginIndex() && position <= this.getEndIndex()) {
            this.index = position;
            this.invariant();
            return this.current();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getBeginIndex() {
        return this.first;
    }

    @Override
    public int getEndIndex() {
        return this.last;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

