/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.ValueException;

public class FloatDefinition
extends BasicDefinition<Float> {
    private final Float minimumValue;

    public FloatDefinition(String key, String documentation) {
        super(key, documentation, Float.class, null);
        this.minimumValue = null;
    }

    public FloatDefinition(String key, String documentation, Float defaultValue) {
        super(key, documentation, Float.class, defaultValue);
        this.minimumValue = null;
    }

    public FloatDefinition(String key, String documentation, Float defaultValue, Float minimumValue) {
        super(key, documentation, Float.class, defaultValue);
        this.minimumValue = minimumValue;
    }

    @Override
    public String getTypeName() {
        return "Float";
    }

    @Override
    public String writeValue(Float value) {
        return value.toString();
    }

    @Override
    public Float checkValue(Float value) throws ValueException {
        if (this.minimumValue != null && value != null && value.floatValue() < this.minimumValue.floatValue()) {
            throw new ValueException("Value " + value + " must be not less than " + this.minimumValue + "!");
        }
        return value;
    }

    @Override
    protected Float parseValue(String value) {
        return Float.valueOf(Float.parseFloat(value));
    }
}

