#!/bin/bash

# Usage: ./worktodo.sh
# Iterates over the numbers in worktodo.txt (one number per line with
# optional flags) and processes them using primecount.

command -v ./primecount >/dev/null 2>/dev/null
if [ $? -ne 0 ]
then
    echo "Error: no primecount binary in current directory."
    exit 1
fi

while read first_line < worktodo.txt
do
    # Skip empty lines and comments
    if [ "$first_line" != "" ] && [ ${first_line:0:1} != "#" ]
    then
        ./primecount $first_line

        # Check if primecount exited successfully
        if [ $? -ne 0 ]
        then
            echo ""
            echo "Error in worktodo.sh:"
            echo "The following command failed: ./primecount $first_line"
            exit 1
        fi
    fi

    # delete first line from worktodo.txt
    tail -n +2 worktodo.txt > .tmp_worktodo.txt
    mv -f .tmp_worktodo.txt worktodo.txt
done
