#include "Rivet/AnalysisHandler.hh"
#include "Rivet/Tools/RivetHepMC.hh"
#include <fstream>

using namespace std;

int main() {

  Rivet::AnalysisHandler ah;
  Rivet::Log::setLevel("Rivet", Rivet::Log::DEBUG);

  // No beams for single-particle-gun-type setups
  ah.setCheckBeams(false);

  // Specify the analyses to be used
  ah.addAnalysis("BELLE_2008_I786560");

  auto reader = Rivet::RivetHepMC::deduce_reader("tau-decays.hepmc");
  std::shared_ptr<Rivet::GenEvent> evt = make_shared<Rivet::GenEvent>();
  double sum_of_weights = 0.0;
  while ( Rivet::HepMCUtils::readEvent(reader, evt) ) {
    // Analyse current event
    ah.analyze(*evt);
    sum_of_weights += evt->weights()[0];
  }
  (void)sum_of_weights; // suppress unused variable warning

  ah.setCrossSection(make_pair(1.0, 0.1));

  ah.finalize();
  ah.writeData("taus.yoda");

  return 0;
}
