// SPDX-License-Identifier: Apache-2.0 OR MIT
// This file is @generated by cargo-config2-internal-codegen
// (gen_track_size function at tools/codegen/src/main.rs).
// It is not intended for manual editing.

#![cfg_attr(rustfmt, rustfmt::skip)]
#![allow(dead_code, clippy::std_instead_of_alloc, clippy::std_instead_of_core)]
use std::{fmt::Write as _, path::Path, string::String};
fn write_size<T>(out: &mut String) {
    let _ = writeln!(
        out, "{}: {}", std::any::type_name::<T> (), std::mem::size_of::<T> ()
    );
}
/// Test the size of public types. This is not intended to keep a specific size and is intended to
/// be used only as a help in optimization.
///
/// Ignore non-64-bit targets due to usize/ptr size, ignore Miri/cargo-careful as we set
/// -Z randomize-layout for them, and ignore old rustc as any::type_name output and size
/// optimization may differ between compiler versions.
#[rustversion::attr(
    nightly,
    cfg_attr(any(not(target_pointer_width = "64"), miri, careful), ignore)
)]
#[rustversion::attr(not(nightly), ignore)]
#[test]
fn track_size() {
    let mut out = String::new();
    write_size::<crate::de::Config>(&mut out);
    write_size::<crate::de::BuildConfig>(&mut out);
    write_size::<crate::de::TargetConfig>(&mut out);
    write_size::<crate::de::DocConfig>(&mut out);
    write_size::<crate::de::EnvConfigValue>(&mut out);
    write_size::<crate::de::FutureIncompatReportConfig>(&mut out);
    write_size::<crate::de::CargoNewConfig>(&mut out);
    write_size::<crate::de::VersionControlSoftware>(&mut out);
    write_size::<crate::de::HttpConfig>(&mut out);
    write_size::<crate::de::NetConfig>(&mut out);
    write_size::<crate::de::RegistriesConfigValue>(&mut out);
    write_size::<crate::de::RegistriesProtocol>(&mut out);
    write_size::<crate::de::RegistryConfig>(&mut out);
    write_size::<crate::de::SourceConfigValue>(&mut out);
    write_size::<crate::de::GlobalCredentialProviders>(&mut out);
    write_size::<crate::de::CredentialProvider>(&mut out);
    write_size::<crate::de::CredentialProviderKind>(&mut out);
    write_size::<crate::de::TermConfig>(&mut out);
    write_size::<crate::de::TermProgress>(&mut out);
    write_size::<crate::de::Color>(&mut out);
    write_size::<crate::de::When>(&mut out);
    write_size::<crate::de::Frequency>(&mut out);
    write_size::<crate::de::Flags>(&mut out);
    write_size::<crate::de::ConfigRelativePath>(&mut out);
    write_size::<crate::de::PathAndArgs>(&mut out);
    write_size::<crate::de::StringList>(&mut out);
    write_size::<crate::de::StringOrArray>(&mut out);
    write_size::<crate::easy::Config>(&mut out);
    write_size::<crate::easy::BuildConfig>(&mut out);
    write_size::<crate::easy::TargetConfig>(&mut out);
    write_size::<crate::easy::DocConfig>(&mut out);
    write_size::<crate::easy::EnvConfigValue>(&mut out);
    write_size::<crate::easy::FutureIncompatReportConfig>(&mut out);
    write_size::<crate::easy::CargoNewConfig>(&mut out);
    write_size::<crate::easy::HttpConfig>(&mut out);
    write_size::<crate::easy::NetConfig>(&mut out);
    write_size::<crate::easy::RegistriesConfigValue>(&mut out);
    write_size::<crate::easy::RegistryConfig>(&mut out);
    write_size::<crate::easy::SourceConfigValue>(&mut out);
    write_size::<crate::easy::GlobalCredentialProviders>(&mut out);
    write_size::<crate::easy::CredentialProvider>(&mut out);
    write_size::<crate::easy::TermConfig>(&mut out);
    write_size::<crate::easy::TermProgressConfig>(&mut out);
    write_size::<crate::easy::Flags>(&mut out);
    write_size::<crate::easy::PathAndArgs>(&mut out);
    write_size::<crate::easy::StringList>(&mut out);
    write_size::<crate::error::Error>(&mut out);
    write_size::<crate::resolve::ResolveOptions>(&mut out);
    write_size::<crate::resolve::ResolveContext>(&mut out);
    write_size::<crate::resolve::TargetTripleRef<'_>>(&mut out);
    write_size::<crate::resolve::RustcVersion>(&mut out);
    write_size::<crate::resolve::CargoVersion>(&mut out);
    write_size::<crate::value::Value<()>>(&mut out);
    write_size::<crate::value::Definition>(&mut out);
    write_size::<crate::walk::Walk<'_>>(&mut out);
    test_helper::git::assert_diff(
        Path::new(env!("CARGO_MANIFEST_DIR")).join("src/gen/tests/track_size.txt"),
        out,
    );
}
