// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies a character-level location within a document, providing precise positioning information for cited content using start and end character indices.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DocumentCharLocation {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub document_index: ::std::option::Option<i32>,
    /// <p>The starting character position of the cited content within the document.</p>
    pub start: ::std::option::Option<i32>,
    /// <p>The ending character position of the cited content within the document.</p>
    pub end: ::std::option::Option<i32>,
}
impl DocumentCharLocation {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn document_index(&self) -> ::std::option::Option<i32> {
        self.document_index
    }
    /// <p>The starting character position of the cited content within the document.</p>
    pub fn start(&self) -> ::std::option::Option<i32> {
        self.start
    }
    /// <p>The ending character position of the cited content within the document.</p>
    pub fn end(&self) -> ::std::option::Option<i32> {
        self.end
    }
}
impl DocumentCharLocation {
    /// Creates a new builder-style object to manufacture [`DocumentCharLocation`](crate::types::DocumentCharLocation).
    pub fn builder() -> crate::types::builders::DocumentCharLocationBuilder {
        crate::types::builders::DocumentCharLocationBuilder::default()
    }
}

/// A builder for [`DocumentCharLocation`](crate::types::DocumentCharLocation).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DocumentCharLocationBuilder {
    pub(crate) document_index: ::std::option::Option<i32>,
    pub(crate) start: ::std::option::Option<i32>,
    pub(crate) end: ::std::option::Option<i32>,
}
impl DocumentCharLocationBuilder {
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn document_index(mut self, input: i32) -> Self {
        self.document_index = ::std::option::Option::Some(input);
        self
    }
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn set_document_index(mut self, input: ::std::option::Option<i32>) -> Self {
        self.document_index = input;
        self
    }
    /// <p>The index of the document within the array of documents provided in the request.</p>
    pub fn get_document_index(&self) -> &::std::option::Option<i32> {
        &self.document_index
    }
    /// <p>The starting character position of the cited content within the document.</p>
    pub fn start(mut self, input: i32) -> Self {
        self.start = ::std::option::Option::Some(input);
        self
    }
    /// <p>The starting character position of the cited content within the document.</p>
    pub fn set_start(mut self, input: ::std::option::Option<i32>) -> Self {
        self.start = input;
        self
    }
    /// <p>The starting character position of the cited content within the document.</p>
    pub fn get_start(&self) -> &::std::option::Option<i32> {
        &self.start
    }
    /// <p>The ending character position of the cited content within the document.</p>
    pub fn end(mut self, input: i32) -> Self {
        self.end = ::std::option::Option::Some(input);
        self
    }
    /// <p>The ending character position of the cited content within the document.</p>
    pub fn set_end(mut self, input: ::std::option::Option<i32>) -> Self {
        self.end = input;
        self
    }
    /// <p>The ending character position of the cited content within the document.</p>
    pub fn get_end(&self) -> &::std::option::Option<i32> {
        &self.end
    }
    /// Consumes the builder and constructs a [`DocumentCharLocation`](crate::types::DocumentCharLocation).
    pub fn build(self) -> crate::types::DocumentCharLocation {
        crate::types::DocumentCharLocation {
            document_index: self.document_index,
            start: self.start,
            end: self.end,
        }
    }
}
