package http

import (
	"bytes"
	"io/ioutil"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestToWSMV(t *testing.T) {
	tables := []struct {
		got, want []byte
		err       error
	}{
		{
			[]byte{
				0x2d, 0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
				0x74, 0x65, 0x64, 0x20, 0x42, 0x6f, 0x75, 0x6e,
				0x64, 0x61, 0x72, 0x79, 0x0d, 0x0a, 0x43, 0x6f,
				0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79,
				0x70, 0x65, 0x3a, 0x20, 0x61, 0x70, 0x70, 0x6c,
				0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
				0x48, 0x54, 0x54, 0x50, 0x2d, 0x53, 0x50, 0x4e,
				0x45, 0x47, 0x4f, 0x2d, 0x73, 0x65, 0x73, 0x73,
				0x69, 0x6f, 0x6e, 0x2d, 0x65, 0x6e, 0x63, 0x72,
				0x79, 0x70, 0x74, 0x65, 0x64, 0x0d, 0x0a, 0x4f,
				0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x63,
				0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x20,
				0x74, 0x79, 0x70, 0x65, 0x3d, 0x61, 0x70, 0x70,
				0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
				0x2f, 0x73, 0x6f, 0x61, 0x70, 0x2b, 0x78, 0x6d,
				0x6c, 0x3b, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65,
				0x74, 0x3d, 0x55, 0x54, 0x46, 0x2d, 0x38, 0x3b,
				0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x3d, 0x31,
				0x32, 0x33, 0x34, 0x0d, 0x0a, 0x0d, 0x0a, 0x0d,
				0x0a, 0x2d, 0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79,
				0x70, 0x74, 0x65, 0x64, 0x20, 0x42, 0x6f, 0x75,
				0x6e, 0x64, 0x61, 0x72, 0x79, 0x0d, 0x0a, 0x43,
				0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54,
				0x79, 0x70, 0x65, 0x3a, 0x20, 0x61, 0x70, 0x70,
				0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
				0x2f, 0x6f, 0x63, 0x74, 0x65, 0x74, 0x2d, 0x73,
				0x74, 0x72, 0x65, 0x61, 0x6d, 0x0d, 0x0a, 0x0d,
				0x0a, 0x66, 0x6f, 0x6f, 0x0d, 0x0a, 0x2d, 0x2d,
				0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65,
				0x64, 0x20, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61,
				0x72, 0x79, 0x2d, 0x2d, 0x0d, 0x0a,
			},
			[]byte{
				0x2d, 0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
				0x74, 0x65, 0x64, 0x20, 0x42, 0x6f, 0x75, 0x6e,
				0x64, 0x61, 0x72, 0x79, 0x0d, 0x0a, 0x09, 0x43,
				0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54,
				0x79, 0x70, 0x65, 0x3a, 0x20, 0x61, 0x70, 0x70,
				0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
				0x2f, 0x48, 0x54, 0x54, 0x50, 0x2d, 0x53, 0x50,
				0x4e, 0x45, 0x47, 0x4f, 0x2d, 0x73, 0x65, 0x73,
				0x73, 0x69, 0x6f, 0x6e, 0x2d, 0x65, 0x6e, 0x63,
				0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x0d, 0x0a,
				0x09, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
				0x6c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
				0x3a, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x61,
				0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
				0x6f, 0x6e, 0x2f, 0x73, 0x6f, 0x61, 0x70, 0x2b,
				0x78, 0x6d, 0x6c, 0x3b, 0x63, 0x68, 0x61, 0x72,
				0x73, 0x65, 0x74, 0x3d, 0x55, 0x54, 0x46, 0x2d,
				0x38, 0x3b, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
				0x3d, 0x31, 0x32, 0x33, 0x34, 0x0d, 0x0a, 0x2d,
				0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
				0x65, 0x64, 0x20, 0x42, 0x6f, 0x75, 0x6e, 0x64,
				0x61, 0x72, 0x79, 0x0d, 0x0a, 0x09, 0x43, 0x6f,
				0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79,
				0x70, 0x65, 0x3a, 0x20, 0x61, 0x70, 0x70, 0x6c,
				0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
				0x6f, 0x63, 0x74, 0x65, 0x74, 0x2d, 0x73, 0x74,
				0x72, 0x65, 0x61, 0x6d, 0x0d, 0x0a, 0x66, 0x6f,
				0x6f, 0x2d, 0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79,
				0x70, 0x74, 0x65, 0x64, 0x20, 0x42, 0x6f, 0x75,
				0x6e, 0x64, 0x61, 0x72, 0x79, 0x2d, 0x2d, 0x0d,
				0x0a,
			},
			nil,
		},
	}

	for _, table := range tables {
		got, err := ioutil.ReadAll(toWSMV(bytes.NewBuffer(table.got)))
		assert.Equal(t, table.err, err)
		if err == nil {
			assert.Equal(t, table.want, got)
		}
	}
}

func TestFromWSMV(t *testing.T) {
	tables := []struct {
		got, want []byte
		err       error
	}{
		{
			[]byte{
				0x2d, 0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
				0x74, 0x65, 0x64, 0x20, 0x42, 0x6f, 0x75, 0x6e,
				0x64, 0x61, 0x72, 0x79, 0x0d, 0x0a, 0x09, 0x43,
				0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54,
				0x79, 0x70, 0x65, 0x3a, 0x20, 0x61, 0x70, 0x70,
				0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
				0x2f, 0x48, 0x54, 0x54, 0x50, 0x2d, 0x53, 0x50,
				0x4e, 0x45, 0x47, 0x4f, 0x2d, 0x73, 0x65, 0x73,
				0x73, 0x69, 0x6f, 0x6e, 0x2d, 0x65, 0x6e, 0x63,
				0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x0d, 0x0a,
				0x09, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
				0x6c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
				0x3a, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x61,
				0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
				0x6f, 0x6e, 0x2f, 0x73, 0x6f, 0x61, 0x70, 0x2b,
				0x78, 0x6d, 0x6c, 0x3b, 0x63, 0x68, 0x61, 0x72,
				0x73, 0x65, 0x74, 0x3d, 0x55, 0x54, 0x46, 0x2d,
				0x38, 0x3b, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
				0x3d, 0x31, 0x32, 0x33, 0x34, 0x0d, 0x0a, 0x2d,
				0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
				0x65, 0x64, 0x20, 0x42, 0x6f, 0x75, 0x6e, 0x64,
				0x61, 0x72, 0x79, 0x0d, 0x0a, 0x09, 0x43, 0x6f,
				0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79,
				0x70, 0x65, 0x3a, 0x20, 0x61, 0x70, 0x70, 0x6c,
				0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
				0x6f, 0x63, 0x74, 0x65, 0x74, 0x2d, 0x73, 0x74,
				0x72, 0x65, 0x61, 0x6d, 0x0d, 0x0a, 0x66, 0x6f,
				0x6f, 0x2d, 0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79,
				0x70, 0x74, 0x65, 0x64, 0x20, 0x42, 0x6f, 0x75,
				0x6e, 0x64, 0x61, 0x72, 0x79, 0x2d, 0x2d, 0x0d,
				0x0a,
			},
			[]byte{
				0x2d, 0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
				0x74, 0x65, 0x64, 0x20, 0x42, 0x6f, 0x75, 0x6e,
				0x64, 0x61, 0x72, 0x79, 0x0d, 0x0a, 0x43, 0x6f,
				0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79,
				0x70, 0x65, 0x3a, 0x20, 0x61, 0x70, 0x70, 0x6c,
				0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f,
				0x48, 0x54, 0x54, 0x50, 0x2d, 0x53, 0x50, 0x4e,
				0x45, 0x47, 0x4f, 0x2d, 0x73, 0x65, 0x73, 0x73,
				0x69, 0x6f, 0x6e, 0x2d, 0x65, 0x6e, 0x63, 0x72,
				0x79, 0x70, 0x74, 0x65, 0x64, 0x0d, 0x0a, 0x4f,
				0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x63,
				0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x20,
				0x74, 0x79, 0x70, 0x65, 0x3d, 0x61, 0x70, 0x70,
				0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
				0x2f, 0x73, 0x6f, 0x61, 0x70, 0x2b, 0x78, 0x6d,
				0x6c, 0x3b, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65,
				0x74, 0x3d, 0x55, 0x54, 0x46, 0x2d, 0x38, 0x3b,
				0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x3d, 0x31,
				0x32, 0x33, 0x34, 0x0d, 0x0a, 0x0d, 0x0a, 0x0d,
				0x0a, 0x2d, 0x2d, 0x45, 0x6e, 0x63, 0x72, 0x79,
				0x70, 0x74, 0x65, 0x64, 0x20, 0x42, 0x6f, 0x75,
				0x6e, 0x64, 0x61, 0x72, 0x79, 0x0d, 0x0a, 0x43,
				0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54,
				0x79, 0x70, 0x65, 0x3a, 0x20, 0x61, 0x70, 0x70,
				0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
				0x2f, 0x6f, 0x63, 0x74, 0x65, 0x74, 0x2d, 0x73,
				0x74, 0x72, 0x65, 0x61, 0x6d, 0x0d, 0x0a, 0x0d,
				0x0a, 0x66, 0x6f, 0x6f, 0x0d, 0x0a, 0x2d, 0x2d,
				0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65,
				0x64, 0x20, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61,
				0x72, 0x79, 0x2d, 0x2d, 0x0d, 0x0a,
			},
			nil,
		},
	}

	for _, table := range tables {
		got, err := ioutil.ReadAll(fromWSMV(bytes.NewBuffer(table.got)))
		assert.Equal(t, table.err, err)
		if err == nil {
			assert.Equal(t, table.want, got)
		}
	}
}
