package policyinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PolicyRestrictionsClient is the client for the PolicyRestrictions methods of the Policyinsights service.
type PolicyRestrictionsClient struct {
	BaseClient
}

// NewPolicyRestrictionsClient creates an instance of the PolicyRestrictionsClient client.
func NewPolicyRestrictionsClient(subscriptionID2 string) PolicyRestrictionsClient {
	return NewPolicyRestrictionsClientWithBaseURI(DefaultBaseURI, subscriptionID2)
}

// NewPolicyRestrictionsClientWithBaseURI creates an instance of the PolicyRestrictionsClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewPolicyRestrictionsClientWithBaseURI(baseURI string, subscriptionID2 string) PolicyRestrictionsClient {
	return PolicyRestrictionsClient{NewWithBaseURI(baseURI, subscriptionID2)}
}

// CheckAtResourceGroupScope checks what restrictions Azure Policy will place on a resource within a resource group.
// Use this when the resource group the resource will be created in is already known.
// Parameters:
// subscriptionID - the ID of the target subscription.
// resourceGroupName - the name of the resource group. The name is case insensitive.
// parameters - the check policy restrictions parameters.
func (client PolicyRestrictionsClient) CheckAtResourceGroupScope(ctx context.Context, subscriptionID string, resourceGroupName string, parameters CheckRestrictionsRequest) (result CheckRestrictionsResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyRestrictionsClient.CheckAtResourceGroupScope")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: subscriptionID,
			Constraints: []validation.Constraint{{Target: "subscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ResourceDetails", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.ResourceDetails.ResourceContent", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyRestrictionsClient", "CheckAtResourceGroupScope", err.Error())
	}

	req, err := client.CheckAtResourceGroupScopePreparer(ctx, subscriptionID, resourceGroupName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyRestrictionsClient", "CheckAtResourceGroupScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckAtResourceGroupScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyRestrictionsClient", "CheckAtResourceGroupScope", resp, "Failure sending request")
		return
	}

	result, err = client.CheckAtResourceGroupScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyRestrictionsClient", "CheckAtResourceGroupScope", resp, "Failure responding to request")
		return
	}

	return
}

// CheckAtResourceGroupScopePreparer prepares the CheckAtResourceGroupScope request.
func (client PolicyRestrictionsClient) CheckAtResourceGroupScopePreparer(ctx context.Context, subscriptionID string, resourceGroupName string, parameters CheckRestrictionsRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2020-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckAtResourceGroupScopeSender sends the CheckAtResourceGroupScope request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyRestrictionsClient) CheckAtResourceGroupScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckAtResourceGroupScopeResponder handles the response to the CheckAtResourceGroupScope request. The method always
// closes the http.Response Body.
func (client PolicyRestrictionsClient) CheckAtResourceGroupScopeResponder(resp *http.Response) (result CheckRestrictionsResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CheckAtSubscriptionScope checks what restrictions Azure Policy will place on a resource within a subscription.
// Parameters:
// subscriptionID - the ID of the target subscription.
// parameters - the check policy restrictions parameters.
func (client PolicyRestrictionsClient) CheckAtSubscriptionScope(ctx context.Context, subscriptionID string, parameters CheckRestrictionsRequest) (result CheckRestrictionsResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyRestrictionsClient.CheckAtSubscriptionScope")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: subscriptionID,
			Constraints: []validation.Constraint{{Target: "subscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.ResourceDetails", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.ResourceDetails.ResourceContent", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policyinsights.PolicyRestrictionsClient", "CheckAtSubscriptionScope", err.Error())
	}

	req, err := client.CheckAtSubscriptionScopePreparer(ctx, subscriptionID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyRestrictionsClient", "CheckAtSubscriptionScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.CheckAtSubscriptionScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyRestrictionsClient", "CheckAtSubscriptionScope", resp, "Failure sending request")
		return
	}

	result, err = client.CheckAtSubscriptionScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policyinsights.PolicyRestrictionsClient", "CheckAtSubscriptionScope", resp, "Failure responding to request")
		return
	}

	return
}

// CheckAtSubscriptionScopePreparer prepares the CheckAtSubscriptionScope request.
func (client PolicyRestrictionsClient) CheckAtSubscriptionScopePreparer(ctx context.Context, subscriptionID string, parameters CheckRestrictionsRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", subscriptionID),
	}

	const APIVersion = "2020-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/checkPolicyRestrictions", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CheckAtSubscriptionScopeSender sends the CheckAtSubscriptionScope request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyRestrictionsClient) CheckAtSubscriptionScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CheckAtSubscriptionScopeResponder handles the response to the CheckAtSubscriptionScope request. The method always
// closes the http.Response Body.
func (client PolicyRestrictionsClient) CheckAtSubscriptionScopeResponder(resp *http.Response) (result CheckRestrictionsResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
