/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.TerminationException;
import com.icl.saxon.tree.AttributeCollection;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLMessage
extends StyleElement {
    boolean terminate = false;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.TERMINATE) {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            if (string.equals("yes")) {
                this.terminate = true;
            } else if (string.equals("no")) {
                this.terminate = false;
            } else {
                this.styleError("terminate must be \"yes\" or \"no\"");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws TransformerException {
        Controller controller = context.getController();
        Emitter emitter = controller.getMessageEmitter();
        if (emitter == null) {
            emitter = controller.makeMessageEmitter();
        }
        if (emitter.getWriter() == null) {
            emitter.setWriter(new OutputStreamWriter(System.err));
        }
        Outputter outputter = controller.getOutputter();
        Properties properties = new Properties();
        ((Hashtable)properties).put("omit-xml-declaration", "yes");
        controller.changeOutputDestination(properties, emitter);
        this.processChildren(context);
        controller.resetOutputDestination(outputter);
        if (this.terminate) {
            throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber());
        }
    }
}

