/*
 * Decompiled with CFR 0.152.
 */
package org.python.jsr223;

import java.io.StringReader;
import java.io.StringWriter;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import junit.framework.TestCase;
import org.python.jsr223.PyScriptEngine;
import org.python.jsr223.PyScriptEngineFactory;

public class ScriptEngineIOTest
extends TestCase {
    ScriptEngineFactory pythonEngineFactory;
    ScriptEngine pythonEngine;

    public void setUp() throws ScriptException {
        this.pythonEngineFactory = new PyScriptEngineFactory();
        this.pythonEngine = new PyScriptEngine(this.pythonEngineFactory);
    }

    public void testEvalString() throws ScriptException {
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("x = 5"));
        ScriptEngineIOTest.assertEquals((Object)5, (Object)this.pythonEngine.eval("x"));
    }

    public void testReadline() throws ScriptException {
        String testString = "Shazaam Batman!\n";
        this.pythonEngine.getContext().setReader(new StringReader("Shazaam Batman!\n"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        ScriptEngineIOTest.assertEquals((Object)"Shazaam Batman!\n", (Object)this.pythonEngine.eval("sys.stdin.readline()"));
    }

    public void testReadlines() throws ScriptException {
        String testString = "Holy Smokes Batman!\nBIF!\r\n\nKAPOW!!!\rTHE END.";
        this.pythonEngine.getContext().setReader(new StringReader("Holy Smokes Batman!\nBIF!\r\n\nKAPOW!!!\rTHE END."));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        Object o = this.pythonEngine.eval("''.join(sys.stdin.readlines())");
        ScriptEngineIOTest.assertEquals((Object)"Holy Smokes Batman!\nBIF!\n\nKAPOW!!!\nTHE END.\n", (Object)o);
    }

    public void testWriter() throws ScriptException {
        StringWriter sw = new StringWriter();
        this.pythonEngine.getContext().setWriter(sw);
        String testString = "It is a wonderful world.";
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("print 'It is a wonderful world.',"));
        ScriptEngineIOTest.assertEquals((String)"It is a wonderful world.", (String)sw.toString());
    }

    public void testErrorWriter() throws ScriptException {
        StringWriter stdout = new StringWriter();
        StringWriter stderr = new StringWriter();
        this.pythonEngine.getContext().setWriter(stdout);
        this.pythonEngine.getContext().setErrorWriter(stderr);
        String testString1 = "It is a wonderful world.";
        String testString2 = "Stuff happens!";
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("import sys"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("sys.stdout.write('It is a wonderful world.')"));
        ScriptEngineIOTest.assertNull((Object)this.pythonEngine.eval("sys.stderr.write('Stuff happens!')"));
        ScriptEngineIOTest.assertEquals((String)"It is a wonderful world.", (String)stdout.toString());
        ScriptEngineIOTest.assertEquals((String)"Stuff happens!", (String)stderr.toString());
    }
}

