/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Iterator;
import java.util.List;
import sun.security.jca.GetInstance;
import sun.security.util.Debug;

public class KeyFactory {
    private static final Debug debug = Debug.getInstance("jca", "KeyFactory");
    private final String algorithm;
    private Provider provider;
    private volatile KeyFactorySpi spi;
    private final Object lock = new Object();
    private Iterator<Provider.Service> serviceIterator;

    protected KeyFactory(KeyFactorySpi keyFactorySpi, Provider provider, String string) {
        this.spi = keyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    private KeyFactory(String string) throws NoSuchAlgorithmException {
        this.algorithm = string;
        List<Provider.Service> list = GetInstance.getServices("KeyFactory", string);
        this.serviceIterator = list.iterator();
        if (this.nextSpi(null) == null) {
            throw new NoSuchAlgorithmException(string + " KeyFactory not available");
        }
    }

    public static KeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        return new KeyFactory(string);
    }

    public static KeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("KeyFactory", KeyFactorySpi.class, string, string2);
        return new KeyFactory((KeyFactorySpi)instance.impl, instance.provider, string);
    }

    public static KeyFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("KeyFactory", KeyFactorySpi.class, string, provider);
        return new KeyFactory((KeyFactorySpi)instance.impl, instance.provider, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Provider getProvider() {
        Object object = this.lock;
        synchronized (object) {
            this.serviceIterator = null;
            return this.provider;
        }
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyFactorySpi nextSpi(KeyFactorySpi keyFactorySpi) {
        Object object = this.lock;
        synchronized (object) {
            if (keyFactorySpi != null && keyFactorySpi != this.spi) {
                return this.spi;
            }
            if (this.serviceIterator == null) {
                return null;
            }
            while (this.serviceIterator.hasNext()) {
                Provider.Service service = this.serviceIterator.next();
                try {
                    Object object2 = service.newInstance(null);
                    if (!(object2 instanceof KeyFactorySpi)) continue;
                    KeyFactorySpi keyFactorySpi2 = (KeyFactorySpi)object2;
                    this.provider = service.getProvider();
                    this.spi = keyFactorySpi2;
                    return keyFactorySpi2;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
            }
            this.serviceIterator = null;
            return null;
        }
    }

    public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGeneratePublic(keySpec);
        }
        Exception exception = null;
        KeyFactorySpi keyFactorySpi = this.spi;
        while (true) {
            try {
                return keyFactorySpi.engineGeneratePublic(keySpec);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyFactorySpi = this.nextSpi(keyFactorySpi)) != null) continue;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)exception;
                }
                throw new InvalidKeySpecException("Could not generate public key", exception);
            }
            break;
        }
    }

    public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGeneratePrivate(keySpec);
        }
        Exception exception = null;
        KeyFactorySpi keyFactorySpi = this.spi;
        while (true) {
            try {
                return keyFactorySpi.engineGeneratePrivate(keySpec);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyFactorySpi = this.nextSpi(keyFactorySpi)) != null) continue;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)exception;
                }
                throw new InvalidKeySpecException("Could not generate private key", exception);
            }
            break;
        }
    }

    public final <T extends KeySpec> T getKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        if (this.serviceIterator == null) {
            return this.spi.engineGetKeySpec(key, clazz);
        }
        Exception exception = null;
        KeyFactorySpi keyFactorySpi = this.spi;
        while (true) {
            try {
                return keyFactorySpi.engineGetKeySpec(key, clazz);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyFactorySpi = this.nextSpi(keyFactorySpi)) != null) continue;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidKeySpecException) {
                    throw (InvalidKeySpecException)exception;
                }
                throw new InvalidKeySpecException("Could not get key spec", exception);
            }
            break;
        }
    }

    public final Key translateKey(Key key) throws InvalidKeyException {
        if (this.serviceIterator == null) {
            return this.spi.engineTranslateKey(key);
        }
        Exception exception = null;
        KeyFactorySpi keyFactorySpi = this.spi;
        while (true) {
            try {
                return keyFactorySpi.engineTranslateKey(key);
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                if ((keyFactorySpi = this.nextSpi(keyFactorySpi)) != null) continue;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidKeyException) {
                    throw (InvalidKeyException)exception;
                }
                throw new InvalidKeyException("Could not translate key", exception);
            }
            break;
        }
    }
}

