---
layout: default
title: Standards Update
parent: Release & Milestone Tasks
grand_parent: Contributors
nav_order: 110
---

<!--
© 2021 and later: Unicode, Inc. and others.
License & terms of use: http://www.unicode.org/copyright.html
-->

# Standards Updates
{: .no_toc }

## Contents
{: .no_toc .text-delta }

1. TOC
{:toc}

---

## Time Zones

Make sure the timezone (Olson) data is up to date.

Olson timezone data should be regularly updated in the trunk. If the data is out
of date, follow the instruction described in the
[readme](https://github.com/unicode-org/icu-data/blob/main/tzdata/readme.txt)
file.

Once the timezone resource file is generated by the process above, the file
should be checked into
[zoneinfo64.txt](https://github.com/unicode-org/icu/blob/main/icu4c/source/data/misc/zoneinfo64.txt)
in the trunk.

## Unicode

### Update Unicode Data

See the [Unicode Update page](../../unicode-update.md) for an overview, and the
[change log for Unicode updates](https://github.com/unicode-org/icu/blob/main/icu4c/source/data/unidata/changes.txt)
for details.

### Update script code enums

Starting with ICU 55, we do not add UScriptCode constants for new scripts any more
until they are encoded in Unicode,
or can be assumed to be encoded in the next Unicode version.

Script enum constant names want to follow the Unicode script property value aliases,
which are assigned only when the scripts are encoded.
When we encode scripts early and guess wrong, then we have confusing enum constants
and have sometimes added aliases.

Normally, we add script codes during the ICU update for a Unicode beta,
at the same time as we add new API constants for new Unicode blocks and
for new values of other supported properties.

Variant script codes like Latf and Aran that are not subject to separate encoding
can be added at any time.
(For example, Aran could be added as USCRIPT_ARABIC_NASTALIQ.)

We add script codes used in CLDR or in the spoof checker.
This includes combination/alias codes like Hanb and Jamo.
See https://unicode.org/reports/tr35/#unicode_script_subtag_validity
and look for "alias" on https://unicode.org/iso15924/iso15924-codes.html

We add special Z* script codes like Zsye.

For new script codes see https://www.unicode.org/iso15924/codechanges.html
Check for recent changes with the code highlighted in the left column and
"Add" in the right column.

Update script code enums with new codes from ISO 15924, send a notice for them
as public API (born `@stable`) to the icu-design list.

See details in the
[change log for Unicode updates](https://github.com/unicode-org/icu/blob/main/icu4c/source/data/unidata/changes.txt).

## CLDR

### Sync ICU with CLDR and tag CLDR.

Update ICU data from CLDR, tag CLDR. Instructions
[here](https://github.com/unicode-org/icu/blob/main/icu4c/source/data/cldr-icu-readme.txt).

### Update MeasureUnit Code

<https://github.com/unicode-org/icu/blob/main/docs/processes/release/tasks/updating-measure-unit.md>

## ISO 4217 numeric codes

Make sure the ISO 4217 numeric code mapping data is up to date.

See the instruction in
<https://github.com/unicode-org/icu/blob/main/tools/currency/readme.txt>
