//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscombobuttonstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSComboButtonStyle(pub NSInteger);
impl NSComboButtonStyle {
    /// The button will be split across 2 segments. The leading segment shows `title`, `image`, or both. If `action` is set, it will be performed when the leading segment is clicked. If `action` is `nil`, the leading segment will be disabled. The trailing segment shows a menu indicator. If `menu` is set, clicking the trailing segment will show it. If `menu` is empty, the trailing segment will be disabled.
    #[doc(alias = "NSComboButtonStyleSplit")]
    pub const Split: Self = Self(0);
    /// The button will be unified in a single segment. If `action` is set, `menu` will appear on click and hold. If `action` is `nil`, then `menu` will appear on click.
    #[doc(alias = "NSComboButtonStyleUnified")]
    pub const Unified: Self = Self(1);
}

unsafe impl Encode for NSComboButtonStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSComboButtonStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscombobutton?language=objc)
    #[unsafe(super(NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    pub struct NSComboButton;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSComboButton {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSComboButton {}
);

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSComboButton {}
);

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSComboButton {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSComboButton {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSComboButton {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSComboButton {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSComboButton {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSComboButton {
    extern_methods!(
        #[cfg(feature = "NSMenu")]
        /// Creates a standard combo button with a title, menu, and primary action.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `menu`: The additional menu to display on the button.
        ///
        /// Parameter `target`: The target object that receives primary action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the primary action portion of the control.
        ///
        /// # Safety
        ///
        /// - `target` should be of the correct type.
        /// - `action` must be a valid selector.
        #[unsafe(method(comboButtonWithTitle:menu:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn comboButtonWithTitle_menu_target_action(
            title: &NSString,
            menu: Option<&NSMenu>,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSImage", feature = "NSMenu"))]
        /// Creates a standard combo button with a image, menu, and primary action.
        ///
        /// Parameter `image`: The image to display in the body of the button.
        ///
        /// Parameter `menu`: The additional menu to display on the button.
        ///
        /// Parameter `target`: The target object that receives primary action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the primary action portion of the control.
        ///
        /// # Safety
        ///
        /// - `target` should be of the correct type.
        /// - `action` must be a valid selector.
        #[unsafe(method(comboButtonWithImage:menu:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn comboButtonWithImage_menu_target_action(
            image: &NSImage,
            menu: Option<&NSMenu>,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSImage", feature = "NSMenu"))]
        /// Creates a standard combo button with a title, image, menu, and primary action.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `image`: The image to display in the body of the button.
        ///
        /// Parameter `menu`: The additional menu to display on the button.
        ///
        /// Parameter `target`: The target object that receives primary action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the primary action portion of the control.
        ///
        /// # Safety
        ///
        /// - `target` should be of the correct type.
        /// - `action` must be a valid selector.
        #[unsafe(method(comboButtonWithTitle:image:menu:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn comboButtonWithTitle_image_menu_target_action(
            title: &NSString,
            image: &NSImage,
            menu: Option<&NSMenu>,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// The title displayed on the control. The default value is an empty string.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: &NSString);

        #[cfg(feature = "NSImage")]
        /// The image displayed on the control. The default value is `nil`.
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub fn image(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub fn setImage(&self, image: Option<&NSImage>);

        #[cfg(feature = "NSCell")]
        /// The scaling mode applied to fit the button's image within the content area. The default value is `NSImageScaleProportionallyDown`.
        #[unsafe(method(imageScaling))]
        #[unsafe(method_family = none)]
        pub fn imageScaling(&self) -> NSImageScaling;

        #[cfg(feature = "NSCell")]
        /// Setter for [`imageScaling`][Self::imageScaling].
        #[unsafe(method(setImageScaling:))]
        #[unsafe(method_family = none)]
        pub fn setImageScaling(&self, image_scaling: NSImageScaling);

        #[cfg(feature = "NSMenu")]
        /// Overrides behavior of NSResponder menu. This menu is shown when interacting with the button (see NSComboButtonStyle). NSComboButton does not have a context menu. Items in this menu specify their own target and action independent of the primary action that is configured on the control.
        #[unsafe(method(menu))]
        #[unsafe(method_family = none)]
        pub fn menu(&self) -> Retained<NSMenu>;

        #[cfg(feature = "NSMenu")]
        /// Setter for [`menu`][Self::menu].
        #[unsafe(method(setMenu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMenu(&self, menu: &NSMenu);

        /// Specifies the visual presentation and behavior for NSComboButton's primary action and its menu. The default value is `NSComboButtonStyleSplit`.
        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> NSComboButtonStyle;

        /// Setter for [`style`][Self::style].
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub fn setStyle(&self, style: NSComboButtonStyle);
    );
}

/// Methods declared on superclass `NSControl`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSComboButton {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSComboButton {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSComboButton {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
