/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import martin.tempest.gui.scale.LogScale;
import martin.tempest.gui.scale.ZoomableXScale;

public class PlotVisualizer
extends JPanel {
    private static final long serialVersionUID = -6754436015453195809L;
    private static final double FONT_SPACING_COEFF = 1.3;
    private static final double FONT_SIZE_COEFF = 0.8;
    private static final double ZOOM_AMOUNT = 0.9;
    private static final double UNZOOM_AMOUNT = 1.1;
    private final Color default_txt_colour_background = Color.LIGHT_GRAY;
    private Object locker = new Object();
    private double[] data = null;
    private double[] visdata = null;
    private int size = 0;
    private int max_index = 0;
    private boolean enabled;
    private int mouse_xpx = -1;
    private int mouse_drag = -1;
    private Integer index_selected = null;
    private Double initial_value = null;
    private long samplerate;
    private int offset;
    private int size_of_val_in_px = 0;
    private int area_around_mouse = 0;
    private final TransformerAndCallback trans;
    private int nwidth = 1;
    private int nheight = 1;
    private boolean font_set = false;
    private int half_fontsize;
    private Font font;
    private ZoomableXScale scale_x = new ZoomableXScale(10.0);
    private final LogScale scale_y = new LogScale(this.default_txt_colour_background, 1.3);

    public PlotVisualizer(final TransformerAndCallback transformerAndCallback) {
        this.trans = transformerAndCallback;
        this.addMouseMotionListener(new MouseMotionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (PlotVisualizer.this.mouse_drag != -1) {
                    int n = mouseEvent.getX() - PlotVisualizer.this.mouse_drag;
                    PlotVisualizer.this.mouse_drag = mouseEvent.getX();
                    PlotVisualizer.this.mouse_xpx = PlotVisualizer.this.mouse_drag;
                    PlotVisualizer.this.scale_x.moveOffsetWithPixels(n);
                    Object object = PlotVisualizer.this.locker;
                    synchronized (object) {
                        PlotVisualizer.this.populateData();
                    }
                    PlotVisualizer.this.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                PlotVisualizer.this.mouse_xpx = mouseEvent.getX();
                int n = (int)PlotVisualizer.this.scale_x.pixels_to_value_absolute(PlotVisualizer.this.mouse_xpx);
                if (n >= 0 && n < PlotVisualizer.this.size) {
                    transformerAndCallback.onMouseMoved(n, PlotVisualizer.this.offset, PlotVisualizer.this.samplerate);
                }
                PlotVisualizer.this.repaint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                double d = mouseWheelEvent.getWheelRotation() > 0 ? 0.9 : 1.1;
                PlotVisualizer.this.scale_x.zoomAround(mouseWheelEvent.getX(), d);
                Object object = PlotVisualizer.this.locker;
                synchronized (object) {
                    PlotVisualizer.this.populateData();
                }
                PlotVisualizer.this.repaint();
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PlotVisualizer.this.mouse_drag = -1;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PlotVisualizer.this.mouse_drag = mouseEvent.getX();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object = PlotVisualizer.this.locker;
                synchronized (object) {
                    if (mouseEvent.getButton() == 1) {
                        int n = PlotVisualizer.this.getBestIdAround(PlotVisualizer.this.mouse_xpx, PlotVisualizer.this.area_around_mouse);
                        PlotVisualizer.this.setSelectedIndex(n);
                        transformerAndCallback.executeIdSelected(n, PlotVisualizer.this.offset, PlotVisualizer.this.samplerate);
                    } else {
                        PlotVisualizer.this.scale_x.reset();
                    }
                }
                PlotVisualizer.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PlotVisualizer.this.mouse_xpx = -1;
                transformerAndCallback.onMouseExited();
                PlotVisualizer.this.repaint();
            }
        });
    }

    public void setAreaAroundMouse(int n) {
        if (n >= 0) {
            this.area_around_mouse = n;
        }
    }

    private int getBestIdAround(int n, int n2) {
        int n3;
        int n4 = (int)this.scale_x.pixels_to_value_absolute(n - n2 / 2);
        if (n4 >= this.size) {
            return -1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if ((n3 = (int)this.scale_x.pixels_to_value_absolute(n + n2 / 2)) < 0) {
            return -1;
        }
        if (n3 > this.size) {
            n3 = this.size;
        }
        int n5 = n4;
        double d = this.data[n5];
        for (int i = n4 + 1; i < n3; ++i) {
            if (!(this.data[i] > d)) continue;
            d = this.data[i];
            n5 = i;
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedValue(double d) {
        if (this.data == null) {
            Object object = this.locker;
            synchronized (object) {
                this.initial_value = d;
            }
        } else {
            this.setSelectedIndex(this.trans.toIndex(d, this.offset, this.samplerate));
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int n) {
        Object object = this.locker;
        synchronized (object) {
            this.index_selected = n;
        }
        this.repaint();
    }

    public Double getSelectedValue() {
        if (this.data == null) {
            return this.initial_value;
        }
        return this.trans.fromIndex(this.index_selected, this.offset, this.samplerate);
    }

    public Double getValueFromId(int n) {
        return this.trans.fromIndex(n, this.offset, this.samplerate);
    }

    private String getValueAt(int n) {
        double d = this.trans.fromIndex(n, this.offset, this.samplerate);
        return this.trans.getDescription(d, n);
    }

    private void populateData() {
        int n;
        double d;
        if (!this.scale_y.valuesValid()) {
            return;
        }
        double d2 = d = this.data[0];
        this.max_index = 0;
        double d3 = d;
        this.size_of_val_in_px = this.scale_x.value_to_pixel_relative(1.0) + 1;
        int n2 = 0;
        int n3 = (int)Math.min(Math.max(this.scale_x.pixels_to_value_absolute(0), 0.0), (double)this.size);
        int n4 = (int)Math.min(Math.max(this.scale_x.pixels_to_value_absolute(this.nwidth) + 1.0, 0.0), (double)this.size);
        double d4 = this.data[n3];
        for (n = n3; n < n4; ++n) {
            double d5 = this.data[n];
            int n5 = this.scale_x.value_to_pixel_absolute(n);
            if (n5 >= 0 && n5 < this.nwidth) {
                if (n2 != n5) {
                    if (d4 > d) {
                        d = d4;
                    } else if (d4 < d2) {
                        d2 = d4;
                    }
                    for (int i = n2; i < n5; ++i) {
                        this.visdata[i] = d4;
                    }
                    d4 = d5;
                    n2 = n5;
                } else if (d5 > d4) {
                    d4 = d5;
                }
            }
            if (!(d5 > d3)) continue;
            d3 = d5;
            this.max_index = n;
        }
        for (n = n2; n < this.nwidth; ++n) {
            this.visdata[n] = d4;
        }
        this.scale_y.setLowestHighestValue(d2, d);
        for (n = 0; n < this.nwidth; ++n) {
            this.visdata[n] = this.scale_y.valtopx(this.visdata[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plot(double[] dArray, int n, int n2, long l) {
        if (n2 <= 0) {
            return;
        }
        Object object = this.locker;
        synchronized (object) {
            if (this.data == null || this.data.length < n2) {
                this.data = new double[n2];
            }
            System.arraycopy(dArray, 0, this.data, 0, n2);
            if (this.visdata == null || this.visdata.length != this.nwidth) {
                this.visdata = new double[this.nwidth];
                this.scale_x.reset();
            }
            this.size = n2;
            this.scale_x.setMinMaxValue(0.0, n2);
            this.offset = n;
            this.samplerate = l;
            this.populateData();
            if (this.index_selected == null && this.initial_value != null) {
                this.index_selected = this.trans.toIndex(this.initial_value, n, l);
                this.initial_value = null;
            }
        }
        this.repaint();
    }

    public int getMaxIndex() {
        return this.max_index;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getSamplerate() {
        return this.samplerate;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.nwidth = n3;
        this.nheight = n4;
        this.scale_y.setDimentions(this.nwidth, this.nheight);
        this.scale_x.setMaxPixels(this.nwidth);
        this.enabled = this.isEnabled();
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.nwidth = rectangle.width;
        this.nheight = rectangle.height;
        this.scale_y.setDimentions(this.nwidth, this.nheight);
        this.scale_x.setMaxPixels(this.nwidth);
        this.enabled = this.isEnabled();
        super.setBounds(rectangle);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.enabled = this.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.locker;
        synchronized (object) {
            this.data = null;
            this.size = 0;
        }
        this.repaint();
    }

    private void setFont(Graphics graphics) {
        if (!this.font_set) {
            Font font = graphics.getFont();
            this.font = new Font(font.getFontName(), 0, (int)((double)font.getSize() * 0.8));
            this.half_fontsize = this.font.getSize() / 2;
            graphics.setFont(this.font);
            this.font_set = true;
        } else {
            graphics.setFont(this.font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        this.setFont(graphics);
        if (this.data == null) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, this.nwidth, this.nheight);
            this.scale_y.paintScale(graphics);
            return;
        }
        Object object = this.locker;
        synchronized (object) {
            int n;
            if (!this.scale_y.valuesValid()) {
                return;
            }
            graphics.setColor(this.enabled ? Color.black : Color.DARK_GRAY);
            graphics.fillRect(0, 0, this.nwidth, this.nheight);
            if (this.mouse_xpx != -1) {
                graphics.setColor(Color.darkGray);
                if (this.area_around_mouse != 0) {
                    graphics.fillRect(this.mouse_xpx - this.area_around_mouse / 2, 0, this.area_around_mouse, this.nheight);
                }
            }
            if (this.visdata.length == this.nwidth) {
                graphics.setColor(Color.gray);
                for (n = 0; n < this.nwidth; ++n) {
                    graphics.drawLine(n, (int)this.visdata[n], n, this.nheight);
                }
            } else {
                graphics.setColor(Color.blue);
                graphics.fillRect(0, 0, this.nwidth, this.nheight);
                return;
            }
            if (this.mouse_xpx != -1) {
                graphics.setColor(this.default_txt_colour_background);
                graphics.drawLine(this.mouse_xpx, 0, this.mouse_xpx, this.nheight);
                n = this.getBestIdAround(this.mouse_xpx, this.area_around_mouse);
                if (n >= 0 && n < this.size) {
                    int n2 = this.scale_x.value_to_pixel_absolute(n);
                    int n3 = this.scale_y.valtopx(this.data[n]);
                    double d = this.scale_y.valtodb(this.data[n]);
                    graphics.setColor(Color.yellow);
                    graphics.fillRect(n2, n3, this.size_of_val_in_px, this.nheight);
                    graphics.setColor(this.default_txt_colour_background);
                    graphics.drawString(this.getValueAt(n), this.mouse_xpx + this.nheight / 10, this.nheight / 5);
                    graphics.drawString(String.format("%.1f dB", d), this.mouse_xpx + this.nheight / 10, this.nheight / 5 + 3 * this.half_fontsize);
                }
            }
            if (this.index_selected != null && (this.index_selected >= 0 || this.index_selected < this.size)) {
                graphics.setColor(Color.green);
                n = this.scale_x.value_to_pixel_absolute(this.index_selected.intValue()) + this.size_of_val_in_px / 2;
                graphics.drawLine(n, 0, n, this.nheight);
                if (this.index_selected >= 0 && this.index_selected < this.size) {
                    graphics.drawString(this.getValueAt(this.index_selected), n + this.nheight / 10, this.nheight / 9);
                }
            }
            this.scale_y.paintScale(graphics);
        }
    }

    public static abstract class TransformerAndCallback {
        public abstract double fromIndex(int var1, int var2, long var3);

        public abstract int toIndex(double var1, int var3, long var4);

        public abstract String getDescription(double var1, int var3);

        public void onMouseMoved(int n, int n2, long l) {
        }

        public void onMouseExited() {
        }

        public void executeIdSelected(int n, int n2, long l) {
        }
    }
}

