\page ExampleSplitting Example splitting

## Authorship

  Authors: J. A. Ramos-Mendez and B. A. Faddegon

  Department of Radiation Oncology, University of California San Francisco 

  This example is provided by the Geant4-DNA collaboration.

  These processes and models are further described at:
  http://geant4-dna.org

  Any report or published results obtained using the Geant4-DNA software shall 
  cite the following Geant4-DNA collaboration publications:
  - Phys. Med. 31 (2015) 861-874
  - Med. Phys. 37 (2010) 4692-4708

  If use this example, please cite
  - J Ramos-Mendez, et. Al. Phys. Med. Biol. 62(15), 5908-5925, (2017) DOI: 10.1088/1361-6560/aa7831

## A brief description

  The Splitting example uses variance reduction to improve the computational
  efficiency of calculations of ionization cluster size distributions. Ionization 
  events are scored in a nanoscaled cylinder. Ionized electrons generated by 
  the first generation of secondary electrons are split, i.e. new clone electrons
  are generated, labeled and propagated. The label is used to classify those 
  new particles as if they were produced by independent histories to avoid 
  overlapping of tracks at final analysis. The Splitting is performed only
  if the ionization event occurred in the cylinder.

  Geant4-DNA processes are used. 

  The example package contains:
  - source files (src, include)
  - README
  - .in, plot.C and visualization macro files

## Set-up

  The geometry is a nanoscaled cylinder centered in the world. The medium is 
  water everywhere. The dimensions can be defined with
```
/detector/diameter  6 nm
/detector/length   10 nm
```

  User can define the split number (default is 1, i.e. no split) 
  with:
```
/vrt/numberOfSplit 10
```

## How to run the example.

  In interactive mode, run:
```
./splitting
Idle> /control/execute vis.mac
```

  In batch mode , run:
```
./splitting run.mac
```
 
  To get visualization, make sure to uncomment the #/control/execute vis.mac line in the macro.

## Physics

  This example shows:
  - how to use the Geant4-DNA processes,
  - how to implement the Splitting via G4WrappedProcess 
  - how to set the Splitting in specific region
  - how to propagate new track information to secondary particles

  A simple electron capture process is also provided in order to kill electrons
  below a chosen energy threshold, set in the Physics list.

  Look at the PhysicsList class.

## Simulation output

  The output results consists in two histograms in root format

  - the energy deposit in the cylindrical target 
  - the frequency distribution of ionization cluster size 

### Important
    Every time a value is added to a ROOT histogram, it contributes to the statistics.
    For this example, to correct estimate the uncertainties is recommended to split the simulation into
    several jobs and to calculate the statistics from them: batch mode. Otherwise, the statistical
    uncertainty may be underestimated.

## Contact

  If you have any questions or wish to notify of updates and/or modification please contact:
 	
  J. Ramos-Mendez at joserm84@gmail.com 

## Acknowledgments

Sebastien Incerti (CNRS) for its guidance 