package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateProfileCatalog invokes the vcs.UpdateProfileCatalog API synchronously
func (client *Client) UpdateProfileCatalog(request *UpdateProfileCatalogRequest) (response *UpdateProfileCatalogResponse, err error) {
	response = CreateUpdateProfileCatalogResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateProfileCatalogWithChan invokes the vcs.UpdateProfileCatalog API asynchronously
func (client *Client) UpdateProfileCatalogWithChan(request *UpdateProfileCatalogRequest) (<-chan *UpdateProfileCatalogResponse, <-chan error) {
	responseChan := make(chan *UpdateProfileCatalogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateProfileCatalog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateProfileCatalogWithCallback invokes the vcs.UpdateProfileCatalog API asynchronously
func (client *Client) UpdateProfileCatalogWithCallback(request *UpdateProfileCatalogRequest, callback func(response *UpdateProfileCatalogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateProfileCatalogResponse
		var err error
		defer close(result)
		response, err = client.UpdateProfileCatalog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateProfileCatalogRequest is the request struct for api UpdateProfileCatalog
type UpdateProfileCatalogRequest struct {
	*requests.RpcRequest
	IsvSubId    string           `position:"Body" name:"IsvSubId"`
	CorpId      string           `position:"Body" name:"CorpId"`
	CatalogName string           `position:"Body" name:"CatalogName"`
	CatalogId   requests.Integer `position:"Body" name:"CatalogId"`
}

// UpdateProfileCatalogResponse is the response struct for api UpdateProfileCatalog
type UpdateProfileCatalogResponse struct {
	*responses.BaseResponse
	Code      string                     `json:"Code" xml:"Code"`
	Message   string                     `json:"Message" xml:"Message"`
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Data      DataInUpdateProfileCatalog `json:"Data" xml:"Data"`
}

// CreateUpdateProfileCatalogRequest creates a request to invoke UpdateProfileCatalog API
func CreateUpdateProfileCatalogRequest() (request *UpdateProfileCatalogRequest) {
	request = &UpdateProfileCatalogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "UpdateProfileCatalog", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateProfileCatalogResponse creates a response to parse from UpdateProfileCatalog response
func CreateUpdateProfileCatalogResponse() (response *UpdateProfileCatalogResponse) {
	response = &UpdateProfileCatalogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
