package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeployGateway invokes the sgw.DeployGateway API synchronously
func (client *Client) DeployGateway(request *DeployGatewayRequest) (response *DeployGatewayResponse, err error) {
	response = CreateDeployGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// DeployGatewayWithChan invokes the sgw.DeployGateway API asynchronously
func (client *Client) DeployGatewayWithChan(request *DeployGatewayRequest) (<-chan *DeployGatewayResponse, <-chan error) {
	responseChan := make(chan *DeployGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeployGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeployGatewayWithCallback invokes the sgw.DeployGateway API asynchronously
func (client *Client) DeployGatewayWithCallback(request *DeployGatewayRequest, callback func(response *DeployGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeployGatewayResponse
		var err error
		defer close(result)
		response, err = client.DeployGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeployGatewayRequest is the request struct for api DeployGateway
type DeployGatewayRequest struct {
	*requests.RpcRequest
	GatewayClass   string                   `position:"Query" name:"GatewayClass"`
	GatewayVersion string                   `position:"Query" name:"GatewayVersion"`
	DataDisk       *[]DeployGatewayDataDisk `position:"Query" name:"DataDisk"  type:"Repeated"`
	VSwitchId      string                   `position:"Query" name:"VSwitchId"`
	SecurityToken  string                   `position:"Query" name:"SecurityToken"`
	GatewayId      string                   `position:"Query" name:"GatewayId"`
}

// DeployGatewayDataDisk is a repeated param struct in DeployGatewayRequest
type DeployGatewayDataDisk struct {
	Size        string `name:"Size"`
	Category    string `name:"Category"`
	CacheConfig string `name:"CacheConfig"`
}

// DeployGatewayResponse is the response struct for api DeployGateway
type DeployGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateDeployGatewayRequest creates a request to invoke DeployGateway API
func CreateDeployGatewayRequest() (request *DeployGatewayRequest) {
	request = &DeployGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DeployGateway", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeployGatewayResponse creates a response to parse from DeployGateway response
func CreateDeployGatewayResponse() (response *DeployGatewayResponse) {
	response = &DeployGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
