package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOuterCallCenterDataList invokes the scsp.GetOuterCallCenterDataList API synchronously
func (client *Client) GetOuterCallCenterDataList(request *GetOuterCallCenterDataListRequest) (response *GetOuterCallCenterDataListResponse, err error) {
	response = CreateGetOuterCallCenterDataListResponse()
	err = client.DoAction(request, response)
	return
}

// GetOuterCallCenterDataListWithChan invokes the scsp.GetOuterCallCenterDataList API asynchronously
func (client *Client) GetOuterCallCenterDataListWithChan(request *GetOuterCallCenterDataListRequest) (<-chan *GetOuterCallCenterDataListResponse, <-chan error) {
	responseChan := make(chan *GetOuterCallCenterDataListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOuterCallCenterDataList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOuterCallCenterDataListWithCallback invokes the scsp.GetOuterCallCenterDataList API asynchronously
func (client *Client) GetOuterCallCenterDataListWithCallback(request *GetOuterCallCenterDataListRequest, callback func(response *GetOuterCallCenterDataListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOuterCallCenterDataListResponse
		var err error
		defer close(result)
		response, err = client.GetOuterCallCenterDataList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOuterCallCenterDataListRequest is the request struct for api GetOuterCallCenterDataList
type GetOuterCallCenterDataListRequest struct {
	*requests.RpcRequest
	QueryEndTime   string `position:"Body"`
	InstanceId     string `position:"Body"`
	ToPhoneNum     string `position:"Body"`
	QueryStartTime string `position:"Body"`
	BizId          string `position:"Body"`
	SessionId      string `position:"Body"`
	FromPhoneNum   string `position:"Body"`
}

// GetOuterCallCenterDataListResponse is the response struct for api GetOuterCallCenterDataList
type GetOuterCallCenterDataListResponse struct {
	*responses.BaseResponse
	Message        string     `json:"Message" xml:"Message"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Code           string     `json:"Code" xml:"Code"`
	Success        bool       `json:"Success" xml:"Success"`
	HttpStatusCode int64      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           []DataItem `json:"Data" xml:"Data"`
}

// CreateGetOuterCallCenterDataListRequest creates a request to invoke GetOuterCallCenterDataList API
func CreateGetOuterCallCenterDataListRequest() (request *GetOuterCallCenterDataListRequest) {
	request = &GetOuterCallCenterDataListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetOuterCallCenterDataList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOuterCallCenterDataListResponse creates a response to parse from GetOuterCallCenterDataList response
func CreateGetOuterCallCenterDataListResponse() (response *GetOuterCallCenterDataListResponse) {
	response = &GetOuterCallCenterDataListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
