package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAllTables invokes the openanalytics_open.GetAllTables API synchronously
func (client *Client) GetAllTables(request *GetAllTablesRequest) (response *GetAllTablesResponse, err error) {
	response = CreateGetAllTablesResponse()
	err = client.DoAction(request, response)
	return
}

// GetAllTablesWithChan invokes the openanalytics_open.GetAllTables API asynchronously
func (client *Client) GetAllTablesWithChan(request *GetAllTablesRequest) (<-chan *GetAllTablesResponse, <-chan error) {
	responseChan := make(chan *GetAllTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAllTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAllTablesWithCallback invokes the openanalytics_open.GetAllTables API asynchronously
func (client *Client) GetAllTablesWithCallback(request *GetAllTablesRequest, callback func(response *GetAllTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAllTablesResponse
		var err error
		defer close(result)
		response, err = client.GetAllTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAllTablesRequest is the request struct for api GetAllTables
type GetAllTablesRequest struct {
	*requests.RpcRequest
	DbName string `position:"Query" name:"DbName"`
}

// GetAllTablesResponse is the response struct for api GetAllTables
type GetAllTablesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Message   string   `json:"Message" xml:"Message"`
	Code      string   `json:"Code" xml:"Code"`
	Success   bool     `json:"Success" xml:"Success"`
	Data      []string `json:"Data" xml:"Data"`
}

// CreateGetAllTablesRequest creates a request to invoke GetAllTables API
func CreateGetAllTablesRequest() (request *GetAllTablesRequest) {
	request = &GetAllTablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "GetAllTables", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAllTablesResponse creates a response to parse from GetAllTables response
func CreateGetAllTablesResponse() (response *GetAllTablesResponse) {
	response = &GetAllTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
