package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// JoinBoard invokes the live.JoinBoard API synchronously
func (client *Client) JoinBoard(request *JoinBoardRequest) (response *JoinBoardResponse, err error) {
	response = CreateJoinBoardResponse()
	err = client.DoAction(request, response)
	return
}

// JoinBoardWithChan invokes the live.JoinBoard API asynchronously
func (client *Client) JoinBoardWithChan(request *JoinBoardRequest) (<-chan *JoinBoardResponse, <-chan error) {
	responseChan := make(chan *JoinBoardResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.JoinBoard(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// JoinBoardWithCallback invokes the live.JoinBoard API asynchronously
func (client *Client) JoinBoardWithCallback(request *JoinBoardRequest, callback func(response *JoinBoardResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *JoinBoardResponse
		var err error
		defer close(result)
		response, err = client.JoinBoard(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// JoinBoardRequest is the request struct for api JoinBoard
type JoinBoardRequest struct {
	*requests.RpcRequest
	BoardId string           `position:"Query" name:"BoardId"`
	AppUid  string           `position:"Query" name:"AppUid"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	AppId   string           `position:"Query" name:"AppId"`
}

// JoinBoardResponse is the response struct for api JoinBoard
type JoinBoardResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	Token             string `json:"Token" xml:"Token"`
	BoardId           string `json:"BoardId" xml:"BoardId"`
	TopicId           string `json:"TopicId" xml:"TopicId"`
	KeepaliveTopic    string `json:"KeepaliveTopic" xml:"KeepaliveTopic"`
	KeepaliveInterval int    `json:"KeepaliveInterval" xml:"KeepaliveInterval"`
}

// CreateJoinBoardRequest creates a request to invoke JoinBoard API
func CreateJoinBoardRequest() (request *JoinBoardRequest) {
	request = &JoinBoardRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "JoinBoard", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateJoinBoardResponse creates a response to parse from JoinBoard response
func CreateJoinBoardResponse() (response *JoinBoardResponse) {
	response = &JoinBoardResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
