package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateResource invokes the eas.UpdateResource API synchronously
func (client *Client) UpdateResource(request *UpdateResourceRequest) (response *UpdateResourceResponse, err error) {
	response = CreateUpdateResourceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateResourceWithChan invokes the eas.UpdateResource API asynchronously
func (client *Client) UpdateResourceWithChan(request *UpdateResourceRequest) (<-chan *UpdateResourceResponse, <-chan error) {
	responseChan := make(chan *UpdateResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateResourceWithCallback invokes the eas.UpdateResource API asynchronously
func (client *Client) UpdateResourceWithCallback(request *UpdateResourceRequest, callback func(response *UpdateResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateResourceResponse
		var err error
		defer close(result)
		response, err = client.UpdateResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateResourceRequest is the request struct for api UpdateResource
type UpdateResourceRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	ClusterId  string `position:"Path" name:"ClusterId"`
	Body       string `position:"Body" name:"body"`
}

// UpdateResourceResponse is the response struct for api UpdateResource
type UpdateResourceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ResourceId   string `json:"ResourceId" xml:"ResourceId"`
	ResourceName string `json:"ResourceName" xml:"ResourceName"`
}

// CreateUpdateResourceRequest creates a request to invoke UpdateResource API
func CreateUpdateResourceRequest() (request *UpdateResourceRequest) {
	request = &UpdateResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "UpdateResource", "/api/v2/resources/[ClusterId]/[ResourceId]", "eas", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateResourceResponse creates a response to parse from UpdateResource response
func CreateUpdateResourceResponse() (response *UpdateResourceResponse) {
	response = &UpdateResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
