package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PreCreateMediaEx invokes the cloudcallcenter.PreCreateMediaEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/precreatemediaex.html
func (client *Client) PreCreateMediaEx(request *PreCreateMediaExRequest) (response *PreCreateMediaExResponse, err error) {
	response = CreatePreCreateMediaExResponse()
	err = client.DoAction(request, response)
	return
}

// PreCreateMediaExWithChan invokes the cloudcallcenter.PreCreateMediaEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/precreatemediaex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PreCreateMediaExWithChan(request *PreCreateMediaExRequest) (<-chan *PreCreateMediaExResponse, <-chan error) {
	responseChan := make(chan *PreCreateMediaExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PreCreateMediaEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PreCreateMediaExWithCallback invokes the cloudcallcenter.PreCreateMediaEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/precreatemediaex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PreCreateMediaExWithCallback(request *PreCreateMediaExRequest, callback func(response *PreCreateMediaExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PreCreateMediaExResponse
		var err error
		defer close(result)
		response, err = client.PreCreateMediaEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PreCreateMediaExRequest is the request struct for api PreCreateMediaEx
type PreCreateMediaExRequest struct {
	*requests.RpcRequest
	Bucket      string `position:"Query" name:"Bucket"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	FileName    string `position:"Query" name:"FileName"`
	Name        string `position:"Query" name:"Name"`
	Description string `position:"Query" name:"Description"`
	Type        string `position:"Query" name:"Type"`
	Content     string `position:"Query" name:"Content"`
}

// PreCreateMediaExResponse is the response struct for api PreCreateMediaEx
type PreCreateMediaExResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Success             bool                `json:"Success" xml:"Success"`
	Code                string              `json:"Code" xml:"Code"`
	Message             string              `json:"Message" xml:"Message"`
	HttpStatusCode      int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	PreCreateMediaParam PreCreateMediaParam `json:"PreCreateMediaParam" xml:"PreCreateMediaParam"`
}

// CreatePreCreateMediaExRequest creates a request to invoke PreCreateMediaEx API
func CreatePreCreateMediaExRequest() (request *PreCreateMediaExRequest) {
	request = &PreCreateMediaExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "PreCreateMediaEx", "", "")
	request.Method = requests.POST
	return
}

// CreatePreCreateMediaExResponse creates a response to parse from PreCreateMediaEx response
func CreatePreCreateMediaExResponse() (response *PreCreateMediaExResponse) {
	response = &PreCreateMediaExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
