/*
 * Copyright 2019 Arnaud Gelas <arnaud.gelas@sensefly.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Use the unit test allocators */
#define UNIT_TESTING 1

#include <stdarg.h>
#include <stddef.h>
#include <setjmp.h>
#include <cmocka.h>

/* A test case that does check if double is equal. */
static void double_test_success(void **state)
{
    (void)state; /* unused */

    assert_double_equal(0.5, 1. / 2., 0.000001);
    assert_double_not_equal(0.5, 0.499, 0.000001);
}

int main(void) {
    const struct CMUnitTest tests[] = {
        cmocka_unit_test(double_test_success),
    };

    return cmocka_run_group_tests(tests, NULL, NULL);
}
