/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.Map;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;

public class SortedMap
extends Map
implements java.util.SortedMap {
    private Comparator comparator;

    public Serializable snapshot(CollectionPersister persister) throws HibernateException {
        TreeMap clonedMap = new TreeMap(this.comparator);
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            clonedMap.put(e.getKey(), persister.getElementType().deepCopy(e.getValue()));
        }
        return clonedMap;
    }

    public SortedMap(SessionImplementor session) {
        super(session);
    }

    public SortedMap(SessionImplementor session, CollectionPersister persister, Comparator comparator, Serializable disassembled, Object owner) throws HibernateException {
        super(session);
        this.comparator = comparator;
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        int i = 0;
        while (i < array.length) {
            this.map.put(persister.getIndexType().assemble(array[i], session, owner), persister.getElementType().assemble(array[i + 1], session, owner));
            i += 2;
        }
        this.initialized = true;
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.map = new TreeMap(this.comparator);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public SortedMap(SessionImplementor session, java.util.SortedMap map) {
        super(session, map);
        this.comparator = map.comparator();
    }

    public SortedMap() {
    }

    public Comparator comparator() {
        return ((java.util.SortedMap)this.map).comparator();
    }

    public java.util.SortedMap subMap(Object fromKey, Object toKey) {
        this.read();
        java.util.SortedMap m = ((java.util.SortedMap)this.map).subMap(fromKey, toKey);
        return new SortedSubMap(m);
    }

    public java.util.SortedMap headMap(Object toKey) {
        this.read();
        java.util.SortedMap m = ((java.util.SortedMap)this.map).headMap(toKey);
        return new SortedSubMap(m);
    }

    public java.util.SortedMap tailMap(Object fromKey) {
        this.read();
        java.util.SortedMap m = ((java.util.SortedMap)this.map).tailMap(fromKey);
        return new SortedSubMap(m);
    }

    public Object firstKey() {
        this.read();
        return ((java.util.SortedMap)this.map).firstKey();
    }

    public Object lastKey() {
        this.read();
        return ((java.util.SortedMap)this.map).lastKey();
    }

    class SortedSubMap
    implements java.util.SortedMap {
        java.util.SortedMap map;

        SortedSubMap(java.util.SortedMap m) {
            this.map = m;
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean containsKey(Object arg0) {
            return this.map.containsKey(arg0);
        }

        public boolean containsValue(Object arg0) {
            return this.map.containsValue(arg0);
        }

        public Object get(Object arg0) {
            return this.map.get(arg0);
        }

        public Object put(Object arg0, Object arg1) {
            SortedMap.this.write();
            return this.map.put(arg0, arg1);
        }

        public Object remove(Object arg0) {
            SortedMap.this.write();
            return this.map.remove(arg0);
        }

        public void putAll(java.util.Map arg0) {
            SortedMap.this.write();
            this.map.putAll(arg0);
        }

        public void clear() {
            SortedMap.this.write();
            this.map.clear();
        }

        public Set keySet() {
            return new PersistentCollection.SetProxy(this.map.keySet());
        }

        public Collection values() {
            return new PersistentCollection.SetProxy(this.map.values());
        }

        public Set entrySet() {
            return new Map.EntrySetProxy(this.map.entrySet());
        }

        public Comparator comparator() {
            return this.map.comparator();
        }

        public java.util.SortedMap subMap(Object fromKey, Object toKey) {
            java.util.SortedMap m = this.map.subMap(fromKey, toKey);
            return new SortedSubMap(m);
        }

        public java.util.SortedMap headMap(Object toKey) {
            java.util.SortedMap m = this.map.headMap(toKey);
            return new SortedSubMap(m);
        }

        public java.util.SortedMap tailMap(Object fromKey) {
            java.util.SortedMap m = this.map.tailMap(fromKey);
            return new SortedSubMap(m);
        }

        public Object firstKey() {
            return this.map.firstKey();
        }

        public Object lastKey() {
            return this.map.lastKey();
        }
    }
}

