/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.doclint.Checker;
import com.sun.tools.doclint.Env;
import com.sun.tools.doclint.HtmlVersion;
import com.sun.tools.doclint.Messages;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.lang.model.element.Name;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class DocLint
implements Plugin {
    public static final String XMSGS_OPTION = "-Xmsgs";
    public static final String XMSGS_CUSTOM_PREFIX = "-Xmsgs:";
    private static final String STATS = "-stats";
    public static final String XIMPLICIT_HEADERS = "-XimplicitHeaders:";
    public static final String XCUSTOM_TAGS_PREFIX = "-XcustomTags:";
    public static final String XHTML_VERSION_PREFIX = "-XhtmlVersion:";
    public static final String XCHECK_PACKAGE = "-XcheckPackage:";
    public static final String SEPARATOR = ",";
    List<File> javacBootClassPath;
    List<File> javacClassPath;
    List<File> javacSourcePath;
    List<String> javacOpts;
    List<File> javacFiles;
    boolean needHelp = false;
    Env env;
    Checker checker;

    public static void main(String ... stringArray) {
        DocLint docLint = new DocLint();
        try {
            docLint.run(stringArray);
        }
        catch (BadArgs badArgs) {
            System.err.println(badArgs.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(docLint.localize("dc.main.ioerror", iOException.getLocalizedMessage()));
            System.exit(2);
        }
    }

    public void run(String ... stringArray) throws BadArgs, IOException {
        PrintWriter printWriter = new PrintWriter(System.out);
        try {
            this.run(printWriter, stringArray);
        }
        finally {
            printWriter.flush();
        }
    }

    public void run(PrintWriter printWriter, String ... stringArray) throws BadArgs, IOException {
        this.env = new Env();
        this.processArgs(stringArray);
        boolean bl = this.javacFiles.isEmpty();
        if (this.needHelp) {
            this.showHelp(printWriter);
            if (bl) {
                return;
            }
        } else if (bl) {
            printWriter.println(this.localize("dc.main.no.files.given", new Object[0]));
            return;
        }
        JavacTool javacTool = JavacTool.create();
        JavacFileManager javacFileManager = new JavacFileManager(new Context(), false, null);
        javacFileManager.setSymbolFileEnabled(false);
        if (this.javacBootClassPath != null) {
            javacFileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.javacBootClassPath);
        }
        if (this.javacClassPath != null) {
            javacFileManager.setLocation(StandardLocation.CLASS_PATH, this.javacClassPath);
        }
        if (this.javacSourcePath != null) {
            javacFileManager.setLocation(StandardLocation.SOURCE_PATH, this.javacSourcePath);
        }
        JavaCompiler.CompilationTask compilationTask = javacTool.getTask((Writer)printWriter, (JavaFileManager)javacFileManager, (DiagnosticListener)null, this.javacOpts, (Iterable)null, (Iterable)javacFileManager.getJavaFileObjectsFromFiles(this.javacFiles));
        Iterable<? extends CompilationUnitTree> iterable = ((JavacTask)compilationTask).parse();
        ((JavacTaskImpl)compilationTask).enter();
        this.env.init((JavacTask)compilationTask);
        this.checker = new Checker(this.env);
        DeclScanner declScanner = new DeclScanner(this.env){

            @Override
            void visitDecl(Tree tree, Name name) {
                TreePath treePath = this.getCurrentPath();
                DocCommentTree docCommentTree = this.env.trees.getDocCommentTree(treePath);
                DocLint.this.checker.scan(docCommentTree, treePath);
            }
        };
        declScanner.scan(iterable, null);
        this.reportStats(printWriter);
        Context context = ((JavacTaskImpl)compilationTask).getContext();
        JavaCompiler javaCompiler = JavaCompiler.instance(context);
        javaCompiler.printCount("error", javaCompiler.errorCount());
        javaCompiler.printCount("warn", javaCompiler.warningCount());
    }

    void processArgs(String ... stringArray) throws BadArgs {
        this.javacOpts = new ArrayList<String>();
        this.javacFiles = new ArrayList<File>();
        if (stringArray.length == 0) {
            this.needHelp = true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.matches("-Xmax(errs|warns)") && i + 1 < stringArray.length) {
                if (stringArray[++i].matches("[0-9]+")) {
                    this.javacOpts.add(string);
                    this.javacOpts.add(stringArray[i]);
                    continue;
                }
                throw new BadArgs("dc.bad.value.for.option", string, stringArray[i]);
            }
            if ((string.equals("-target") || string.equals("-source")) && i + 1 < stringArray.length) {
                this.javacOpts.add(string);
                this.javacOpts.add(stringArray[++i]);
                continue;
            }
            if (string.equals(STATS)) {
                this.env.messages.setStatsEnabled(true);
                continue;
            }
            if (string.equals("-bootclasspath") && i + 1 < stringArray.length) {
                this.javacBootClassPath = this.splitPath(stringArray[++i]);
                continue;
            }
            if (string.equals("-classpath") && i + 1 < stringArray.length) {
                this.javacClassPath = this.splitPath(stringArray[++i]);
                continue;
            }
            if (string.equals("-cp") && i + 1 < stringArray.length) {
                this.javacClassPath = this.splitPath(stringArray[++i]);
                continue;
            }
            if (string.equals("-sourcepath") && i + 1 < stringArray.length) {
                this.javacSourcePath = this.splitPath(stringArray[++i]);
                continue;
            }
            if (string.equals(XMSGS_OPTION)) {
                this.env.messages.setOptions(null);
                continue;
            }
            if (string.startsWith(XMSGS_CUSTOM_PREFIX)) {
                this.env.messages.setOptions(string.substring(string.indexOf(":") + 1));
                continue;
            }
            if (string.startsWith(XCUSTOM_TAGS_PREFIX)) {
                this.env.setCustomTags(string.substring(string.indexOf(":") + 1));
                continue;
            }
            if (string.startsWith(XHTML_VERSION_PREFIX)) {
                String string2 = string.substring(string.indexOf(":") + 1);
                HtmlVersion htmlVersion = HtmlVersion.getHtmlVersion(string2);
                if (htmlVersion != null) {
                    this.env.setHtmlVersion(htmlVersion);
                    continue;
                }
                throw new BadArgs("dc.bad.value.for.option", string, string2);
            }
            if (string.equals("-h") || string.equals("-help") || string.equals("--help") || string.equals("-?") || string.equals("-usage")) {
                this.needHelp = true;
                continue;
            }
            if (string.startsWith("-")) {
                throw new BadArgs("dc.bad.option", string);
            }
            while (i < stringArray.length) {
                this.javacFiles.add(new File(stringArray[i++]));
            }
        }
    }

    void showHelp(PrintWriter printWriter) {
        String string = this.localize("dc.main.usage", new Object[0]);
        for (String string2 : string.split("\n")) {
            printWriter.println(string2);
        }
    }

    List<File> splitPath(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : string.split(File.pathSeparator)) {
            if (string2.length() <= 0) continue;
            arrayList.add(new File(string2));
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return "doclint";
    }

    @Override
    public void init(JavacTask javacTask, String ... stringArray) {
        this.init(javacTask, stringArray, true);
    }

    public void init(JavacTask javacTask, String[] stringArray, boolean bl) {
        this.env = new Env();
        for (String string : stringArray) {
            if (string.equals(XMSGS_OPTION)) {
                this.env.messages.setOptions(null);
                continue;
            }
            if (string.startsWith(XMSGS_CUSTOM_PREFIX)) {
                this.env.messages.setOptions(string.substring(string.indexOf(":") + 1));
                continue;
            }
            if (string.matches("-XimplicitHeaders:[1-6]")) {
                char string2 = string.charAt(string.length() - 1);
                this.env.setImplicitHeaders(Character.digit(string2, 10));
                continue;
            }
            if (string.startsWith(XCUSTOM_TAGS_PREFIX)) {
                this.env.setCustomTags(string.substring(string.indexOf(":") + 1));
                continue;
            }
            if (string.startsWith(XHTML_VERSION_PREFIX)) {
                String string2 = string.substring(string.indexOf(":") + 1);
                HtmlVersion htmlVersion = HtmlVersion.getHtmlVersion(string2);
                if (htmlVersion != null) {
                    this.env.setHtmlVersion(htmlVersion);
                    continue;
                }
                throw new IllegalArgumentException(string2);
            }
            if (string.startsWith(XCHECK_PACKAGE)) {
                this.env.setCheckPackages(string.substring(string.indexOf(":") + 1));
                continue;
            }
            throw new IllegalArgumentException(string);
        }
        this.env.init(javacTask);
        this.checker = new Checker(this.env);
        if (bl) {
            final DeclScanner declScanner = new DeclScanner(this.env){

                @Override
                void visitDecl(Tree tree, Name name) {
                    TreePath treePath = this.getCurrentPath();
                    DocCommentTree docCommentTree = this.env.trees.getDocCommentTree(treePath);
                    DocLint.this.checker.scan(docCommentTree, treePath);
                }
            };
            TaskListener taskListener = new TaskListener(){
                Queue<CompilationUnitTree> todo = new LinkedList<CompilationUnitTree>();

                @Override
                public void started(TaskEvent taskEvent) {
                    switch (taskEvent.getKind()) {
                        case ANALYZE: {
                            CompilationUnitTree compilationUnitTree;
                            while ((compilationUnitTree = this.todo.poll()) != null) {
                                declScanner.scan(compilationUnitTree, null);
                            }
                            break;
                        }
                    }
                }

                @Override
                public void finished(TaskEvent taskEvent) {
                    switch (taskEvent.getKind()) {
                        case PARSE: {
                            this.todo.add(taskEvent.getCompilationUnit());
                        }
                    }
                }
            };
            javacTask.addTaskListener(taskListener);
        }
    }

    public void scan(TreePath treePath) {
        DocCommentTree docCommentTree = this.env.trees.getDocCommentTree(treePath);
        this.checker.scan(docCommentTree, treePath);
    }

    public boolean shouldCheck(CompilationUnitTree compilationUnitTree) {
        return this.env.shouldCheck(compilationUnitTree);
    }

    public void reportStats(PrintWriter printWriter) {
        this.env.messages.reportStats(printWriter);
    }

    public static boolean isValidOption(String string) {
        if (string.equals(XMSGS_OPTION)) {
            return true;
        }
        if (string.startsWith(XMSGS_CUSTOM_PREFIX)) {
            return Messages.Options.isValidOptions(string.substring(XMSGS_CUSTOM_PREFIX.length()));
        }
        if (string.startsWith(XCHECK_PACKAGE)) {
            return Env.validatePackages(string.substring(string.indexOf(":") + 1));
        }
        return false;
    }

    private String localize(String string, Object ... objectArray) {
        Messages messages = this.env != null ? this.env.messages : new Messages(null);
        return messages.localize(string, objectArray);
    }

    static abstract class DeclScanner
    extends TreePathScanner<Void, Void> {
        final Env env;

        public DeclScanner(Env env) {
            this.env = env;
        }

        abstract void visitDecl(Tree var1, Name var2);

        @Override
        public Void visitPackage(PackageTree packageTree, Void void_) {
            this.visitDecl(packageTree, null);
            return (Void)super.visitPackage(packageTree, void_);
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            this.visitDecl(classTree, classTree.getSimpleName());
            return (Void)super.visitClass(classTree, void_);
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Void void_) {
            this.visitDecl(methodTree, methodTree.getName());
            return null;
        }

        @Override
        public Void visitModule(ModuleTree moduleTree, Void void_) {
            this.visitDecl(moduleTree, null);
            return (Void)super.visitModule(moduleTree, void_);
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void void_) {
            this.visitDecl(variableTree, variableTree.getName());
            return (Void)super.visitVariable(variableTree, void_);
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Void void_) {
            if (!this.env.shouldCheck(compilationUnitTree)) {
                return null;
            }
            return (Void)super.visitCompilationUnit(compilationUnitTree, void_);
        }
    }

    public class BadArgs
    extends Exception {
        private static final long serialVersionUID = 0L;
        final String code;
        final Object[] args;

        BadArgs(String string, Object ... objectArray) {
            super(DocLint.this.localize(string, objectArray));
            this.code = string;
            this.args = objectArray;
        }
    }
}

