// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Specifies the S3 Intelligent-Tiering configuration for an Amazon S3 bucket.</p>
/// <p>For information about the S3 Intelligent-Tiering storage class, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access">Storage class for automatically optimizing frequently and infrequently accessed objects</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct IntelligentTieringConfiguration {
    /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    pub id: ::std::string::String,
    /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
    pub filter: ::std::option::Option<crate::types::IntelligentTieringFilter>,
    /// <p>Specifies the status of the configuration.</p>
    pub status: crate::types::IntelligentTieringStatus,
    /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
    pub tierings: ::std::vec::Vec<crate::types::Tiering>,
}
impl IntelligentTieringConfiguration {
    /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    pub fn id(&self) -> &str {
        use std::ops::Deref;
        self.id.deref()
    }
    /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
    pub fn filter(&self) -> ::std::option::Option<&crate::types::IntelligentTieringFilter> {
        self.filter.as_ref()
    }
    /// <p>Specifies the status of the configuration.</p>
    pub fn status(&self) -> &crate::types::IntelligentTieringStatus {
        &self.status
    }
    /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
    pub fn tierings(&self) -> &[crate::types::Tiering] {
        use std::ops::Deref;
        self.tierings.deref()
    }
}
impl IntelligentTieringConfiguration {
    /// Creates a new builder-style object to manufacture [`IntelligentTieringConfiguration`](crate::types::IntelligentTieringConfiguration).
    pub fn builder() -> crate::types::builders::IntelligentTieringConfigurationBuilder {
        crate::types::builders::IntelligentTieringConfigurationBuilder::default()
    }
}

/// A builder for [`IntelligentTieringConfiguration`](crate::types::IntelligentTieringConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct IntelligentTieringConfigurationBuilder {
    pub(crate) id: ::std::option::Option<::std::string::String>,
    pub(crate) filter: ::std::option::Option<crate::types::IntelligentTieringFilter>,
    pub(crate) status: ::std::option::Option<crate::types::IntelligentTieringStatus>,
    pub(crate) tierings: ::std::option::Option<::std::vec::Vec<crate::types::Tiering>>,
}
impl IntelligentTieringConfigurationBuilder {
    /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    /// This field is required.
    pub fn id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    pub fn set_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.id = input;
        self
    }
    /// <p>The ID used to identify the S3 Intelligent-Tiering configuration.</p>
    pub fn get_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.id
    }
    /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
    pub fn filter(mut self, input: crate::types::IntelligentTieringFilter) -> Self {
        self.filter = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
    pub fn set_filter(mut self, input: ::std::option::Option<crate::types::IntelligentTieringFilter>) -> Self {
        self.filter = input;
        self
    }
    /// <p>Specifies a bucket filter. The configuration only includes objects that meet the filter's criteria.</p>
    pub fn get_filter(&self) -> &::std::option::Option<crate::types::IntelligentTieringFilter> {
        &self.filter
    }
    /// <p>Specifies the status of the configuration.</p>
    /// This field is required.
    pub fn status(mut self, input: crate::types::IntelligentTieringStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies the status of the configuration.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::IntelligentTieringStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>Specifies the status of the configuration.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::IntelligentTieringStatus> {
        &self.status
    }
    /// Appends an item to `tierings`.
    ///
    /// To override the contents of this collection use [`set_tierings`](Self::set_tierings).
    ///
    /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
    pub fn tierings(mut self, input: crate::types::Tiering) -> Self {
        let mut v = self.tierings.unwrap_or_default();
        v.push(input);
        self.tierings = ::std::option::Option::Some(v);
        self
    }
    /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
    pub fn set_tierings(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tiering>>) -> Self {
        self.tierings = input;
        self
    }
    /// <p>Specifies the S3 Intelligent-Tiering storage class tier of the configuration.</p>
    pub fn get_tierings(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tiering>> {
        &self.tierings
    }
    /// Consumes the builder and constructs a [`IntelligentTieringConfiguration`](crate::types::IntelligentTieringConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`id`](crate::types::builders::IntelligentTieringConfigurationBuilder::id)
    /// - [`status`](crate::types::builders::IntelligentTieringConfigurationBuilder::status)
    /// - [`tierings`](crate::types::builders::IntelligentTieringConfigurationBuilder::tierings)
    pub fn build(self) -> ::std::result::Result<crate::types::IntelligentTieringConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::IntelligentTieringConfiguration {
            id: self.id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "id",
                    "id was not specified but it is required when building IntelligentTieringConfiguration",
                )
            })?,
            filter: self.filter,
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building IntelligentTieringConfiguration",
                )
            })?,
            tierings: self.tierings.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "tierings",
                    "tierings was not specified but it is required when building IntelligentTieringConfiguration",
                )
            })?,
        })
    }
}
