---
title: "iCloud Drive"
description: "Rclone docs for iCloud Drive"
versionIntroduced: "v1.69"
---

# {{< icon "fa fa-cloud" >}} iCloud Drive

## Configuration

The initial setup for an iCloud Drive backend involves getting a trust token/session.
This can be done by simply using the regular iCloud password, and accepting the code
prompt on another iCloud connected device.

**IMPORTANT**: At the moment an app specific password won't be accepted. Only
use your regular password and 2FA.

`rclone config` walks you through the token creation. The trust token is valid
for 30 days. After which you will have to reauthenticate with `rclone reconnect`
or `rclone config`.

Here is an example of how to make a remote called `iclouddrive`.  First run:

```console
rclone config
```

This will guide you through an interactive setup process:

```text
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n
name> iclouddrive
Option Storage.
Type of storage to configure.
Choose a number from below, or type in your own value.
[snip]
XX / iCloud Drive
   \ (iclouddrive)
[snip]
Storage> iclouddrive
Option apple_id.
Apple ID.
Enter a value.
apple_id> APPLEID  
Option password.
Password.
Choose an alternative below.
y) Yes, type in my own password
g) Generate random password
y/g> y
Enter the password:
password:
Confirm the password:
password:
Edit advanced config?
y) Yes
n) No (default)
y/n> n
Option config_2fa.
Two-factor authentication: please enter your 2FA code
Enter a value.
config_2fa> 2FACODE
Remote config
--------------------
[iclouddrive]
- type: iclouddrive
- apple_id: APPLEID
- password: *** ENCRYPTED ***
- cookies: ****************************
- trust_token: ****************************
--------------------
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

## Advanced Data Protection

ADP is currently unsupported and need to be disabled

On iPhone, Settings `>` Apple Account `>` iCloud `>` 'Access iCloud Data on the Web'
must be ON, and 'Advanced Data Protection' OFF.

## Troubleshooting

### Missing PCS cookies from the request

This means you have Advanced Data Protection (ADP) turned on. This is not supported
at the moment. If you want to use rclone you will have to turn it off. See above
for how to turn it off.

You will need to clear the `cookies` and the `trust_token` fields in the config.
Or you can delete the remote config and start again.

You should then run `rclone reconnect remote:`.

Note that changing the ADP setting may not take effect immediately - you may
need to wait a few hours or a day before you can get rclone to work - keep
clearing the config entry and running `rclone reconnect remote:` until rclone
functions properly.

<!-- autogenerated options start - DO NOT EDIT - instead edit fs.RegInfo in backend/iclouddrive/iclouddrive.go and run make backenddocs to verify --> <!-- markdownlint-disable-line line-length -->
### Standard options

Here are the Standard options specific to iclouddrive (iCloud Drive).

#### --iclouddrive-apple-id

Apple ID.

Properties:

- Config:      apple_id
- Env Var:     RCLONE_ICLOUDDRIVE_APPLE_ID
- Type:        string
- Required:    true

#### --iclouddrive-password

Password.

**NB** Input to this must be obscured - see [rclone obscure](/commands/rclone_obscure/).

Properties:

- Config:      password
- Env Var:     RCLONE_ICLOUDDRIVE_PASSWORD
- Type:        string
- Required:    true

#### --iclouddrive-trust-token

Trust token (internal use)

Properties:

- Config:      trust_token
- Env Var:     RCLONE_ICLOUDDRIVE_TRUST_TOKEN
- Type:        string
- Required:    false

#### --iclouddrive-cookies

cookies (internal use only)

Properties:

- Config:      cookies
- Env Var:     RCLONE_ICLOUDDRIVE_COOKIES
- Type:        string
- Required:    false

### Advanced options

Here are the Advanced options specific to iclouddrive (iCloud Drive).

#### --iclouddrive-client-id

Client id

Properties:

- Config:      client_id
- Env Var:     RCLONE_ICLOUDDRIVE_CLIENT_ID
- Type:        string
- Default:     "d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d"

#### --iclouddrive-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_ICLOUDDRIVE_ENCODING
- Type:        Encoding
- Default:     Slash,BackSlash,Del,Ctl,InvalidUtf8,Dot

#### --iclouddrive-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_ICLOUDDRIVE_DESCRIPTION
- Type:        string
- Required:    false

<!-- autogenerated options stop -->
