﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/ListInvocationStepsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::BedrockAgentRuntime::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListInvocationStepsResult::ListInvocationStepsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListInvocationStepsResult& ListInvocationStepsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("invocationStepSummaries")) {
    Aws::Utils::Array<JsonView> invocationStepSummariesJsonList = jsonValue.GetArray("invocationStepSummaries");
    for (unsigned invocationStepSummariesIndex = 0; invocationStepSummariesIndex < invocationStepSummariesJsonList.GetLength();
         ++invocationStepSummariesIndex) {
      m_invocationStepSummaries.push_back(invocationStepSummariesJsonList[invocationStepSummariesIndex].AsObject());
    }
    m_invocationStepSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
