%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM2": ["0x3FF0000000000000", "0x4010000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x3FF0000000000000", "0x4010000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0x3FF0000000000000", "0x4010000000000000", "0xC08F600000000000", "0xC05D000000000000"],
    "XMM5": ["0x3FF0000000000000", "0x4010000000000000", "0xC08F600000000000", "0xC05D000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32]

vhsubpd xmm2, xmm0, xmm1
vhsubpd xmm3, xmm0, [rdx + 32]

vhsubpd ymm4, ymm0, ymm1
vhsubpd ymm5, ymm0, [rdx + 32]

hlt

align 32
.data:
dq 0x4000000000000000 ; 2.0
dq 0x3FF0000000000000 ; 1.0
dq 0x4034000000000000 ; 20.0
dq 0x4090000000000000 ; 1024.0

dq 0x4020000000000000 ; 8.0
dq 0x4010000000000000 ; 4.0
dq 0x4028000000000000 ; 12.0
dq 0x4060000000000000 ; 128.0
