/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.audio.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.FixedLengthAudioStream;
import org.openhab.core.audio.PipedAudioStream;
import org.openhab.core.audio.SizeableAudioStream;
import org.openhab.core.audio.UnsupportedAudioFormatException;
import org.openhab.core.audio.UnsupportedAudioStreamException;
import org.openhab.core.audio.utils.AudioWaveUtils;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketAudioUtil;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketConnection;
import org.openhab.core.io.websocket.audio.internal.PCMWebSocketStreamIdUtil;
import org.openhab.core.library.types.PercentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PCMWebSocketAudioSink
implements AudioSink {
    private static final byte STREAM_TERMINATION_BYTE = -2;
    private static final Set<AudioFormat> SUPPORTED_FORMATS = Set.of(AudioFormat.WAV, AudioFormat.PCM_SIGNED);
    private static final Set<Class<? extends AudioStream>> SUPPORTED_STREAMS = Set.of(FixedLengthAudioStream.class, PipedAudioStream.class);
    private final Logger logger = LoggerFactory.getLogger(PCMWebSocketAudioSink.class);
    private final String sinkId;
    private final String sinkLabel;
    private final PCMWebSocketConnection websocket;
    private PercentType sinkVolume = new PercentType(100);
    private @Nullable Integer forceSampleRate;
    private @Nullable Integer forceBitDepth;
    private @Nullable Integer forceChannels;

    public PCMWebSocketAudioSink(String id, String label, PCMWebSocketConnection websocket, @Nullable Integer forceSampleRate, @Nullable Integer forceBitDepth, @Nullable Integer forceChannels) {
        this.sinkId = id;
        this.sinkLabel = label;
        this.websocket = websocket;
        this.forceSampleRate = forceSampleRate;
        this.forceBitDepth = forceBitDepth;
        this.forceChannels = forceChannels;
    }

    public String getId() {
        return this.sinkId;
    }

    public @Nullable String getLabel(@Nullable Locale locale) {
        return this.sinkLabel;
    }

    /*
     * Loose catch block
     */
    public void process(@Nullable AudioStream audioStream) throws UnsupportedAudioFormatException, UnsupportedAudioStreamException {
        if (audioStream == null) {
            return;
        }
        OutputStream outputStream = null;
        try {
            try {
                Object finalAudioStream;
                long duration = -1L;
                if ("WAVE".equals(audioStream.getFormat().getContainer())) {
                    this.logger.debug("Removing wav container from data");
                    try {
                        AudioWaveUtils.removeFMT((InputStream)audioStream);
                    }
                    catch (IOException e) {
                        this.logger.warn("IOException trying to remove wav header: {}", (Object)e.getMessage());
                    }
                }
                AudioFormat audioFormat = audioStream.getFormat();
                if (audioStream instanceof SizeableAudioStream) {
                    SizeableAudioStream sizeableAudioStream = (SizeableAudioStream)audioStream;
                    long byteLength = sizeableAudioStream.length();
                    long bytesPerSecond = (long)(Objects.requireNonNull(audioFormat.getBitDepth()) / 8) * Objects.requireNonNull(audioFormat.getFrequency()) * (long)Objects.requireNonNull(audioFormat.getChannels()).intValue();
                    float durationInSeconds = (float)byteLength / (float)bytesPerSecond;
                    duration = Math.round(durationInSeconds * 1000.0f);
                    this.logger.debug("Duration of input stream : {}", (Object)duration);
                }
                AtomicBoolean transferenceAborted = new AtomicBoolean(false);
                if (audioStream instanceof PipedAudioStream) {
                    PipedAudioStream pipedAudioStream = (PipedAudioStream)audioStream;
                    pipedAudioStream.onClose(() -> transferenceAborted.set(true));
                }
                int sampleRate = Objects.requireNonNull(audioFormat.getFrequency()).intValue();
                int bitDepth = Objects.requireNonNull(audioFormat.getBitDepth());
                int channels = Objects.requireNonNull(audioFormat.getChannels());
                int targetSampleRate = Objects.requireNonNullElse(this.forceSampleRate, sampleRate);
                Integer targetBitDepth = Objects.requireNonNullElse(this.forceBitDepth, bitDepth);
                Integer targetChannels = Objects.requireNonNullElse(this.forceChannels, channels);
                outputStream = new PCMWebSocketOutputStream(this.websocket, targetSampleRate, targetBitDepth.byteValue(), targetChannels.byteValue());
                if (this.forceSampleRate != null && !this.forceSampleRate.equals(sampleRate) || this.forceBitDepth != null && !this.forceBitDepth.equals(bitDepth) || this.forceChannels != null && !this.forceChannels.equals(channels)) {
                    this.logger.debug("Sound is not in the target format. Trying to re-encode it");
                    finalAudioStream = PCMWebSocketAudioUtil.getPCMStreamNormalized((InputStream)audioStream, sampleRate, bitDepth, channels, targetSampleRate, targetBitDepth, targetChannels);
                } else {
                    finalAudioStream = audioStream;
                }
                int bytesPer500ms = targetSampleRate * (targetBitDepth / 8) * targetChannels / 2;
                this.transferAudio((InputStream)finalAudioStream, outputStream, bytesPer500ms, duration, transferenceAborted);
            }
            catch (InterruptedIOException duration) {
                try {
                    audioStream.close();
                }
                catch (IOException e) {
                    this.logger.warn("IOException: {}", (Object)e.getMessage(), (Object)e);
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    this.logger.warn("IOException: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            catch (IOException e) {
                this.logger.warn("IOException: {}", (Object)e.getMessage());
                try {
                    audioStream.close();
                }
                catch (IOException e2) {
                    this.logger.warn("IOException: {}", (Object)e2.getMessage(), (Object)e2);
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e3) {
                    this.logger.warn("IOException: {}", (Object)e3.getMessage(), (Object)e3);
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("InterruptedException: {}", (Object)e.getMessage());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    audioStream.close();
                }
                catch (IOException e4) {
                    this.logger.warn("IOException: {}", (Object)e4.getMessage(), (Object)e4);
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e5) {
                    this.logger.warn("IOException: {}", (Object)e5.getMessage(), (Object)e5);
                }
            }
        }
        finally {
            try {
                audioStream.close();
            }
            catch (IOException e) {
                this.logger.warn("IOException: {}", (Object)e.getMessage(), (Object)e);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                this.logger.warn("IOException: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void transferAudio(InputStream inputStream, OutputStream outputStream, int chunkSize, long duration, AtomicBoolean aborted) throws IOException, InterruptedException {
        Instant end;
        long millisSecondTimedToSendAudioData;
        Instant start = Instant.now();
        long transferred = 0L;
        try {
            int read;
            byte[] buffer = new byte[chunkSize];
            while (!aborted.get() && (read = inputStream.read(buffer, 0, chunkSize)) >= 0) {
                outputStream.write(buffer, 0, read);
                transferred += (long)read;
            }
        }
        catch (Throwable throwable) {
            try {
                outputStream.write(new byte[]{-2}, 0, 1);
            }
            catch (IOException e) {
                this.logger.warn("Unable to send termination byte to sink {}", (Object)this.sinkId);
            }
            throw throwable;
        }
        try {
            outputStream.write(new byte[]{-2}, 0, 1);
        }
        catch (IOException e) {
            this.logger.warn("Unable to send termination byte to sink {}", (Object)this.sinkId);
        }
        this.logger.debug("Sent {} bytes of audio", (Object)transferred);
        if (duration != -1L && (millisSecondTimedToSendAudioData = Duration.between(start, end = Instant.now()).toMillis()) < duration) {
            long timeToSleep = duration - millisSecondTimedToSendAudioData;
            this.logger.debug("Sleep time to let the system play sound : {}ms", (Object)timeToSleep);
            Thread.sleep(timeToSleep);
        }
    }

    public Set<AudioFormat> getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public Set<Class<? extends AudioStream>> getSupportedStreams() {
        return SUPPORTED_STREAMS;
    }

    public PercentType getVolume() throws IOException {
        return this.sinkVolume;
    }

    public void setVolume(PercentType percentType) throws IOException {
        this.sinkVolume = percentType;
        this.websocket.setSinkVolume(percentType.intValue());
    }

    protected static class PCMWebSocketOutputStream
    extends OutputStream {
        private final byte[] header;
        private final PCMWebSocketConnection websocket;
        private boolean closed = false;

        public PCMWebSocketOutputStream(PCMWebSocketConnection websocket, int sampleRate, byte bitDepth, byte channels) {
            this.websocket = websocket;
            this.header = PCMWebSocketStreamIdUtil.generateAudioPacketHeader(sampleRate, bitDepth, channels).array();
        }

        @Override
        public void write(int b) throws IOException {
            this.write(ByteBuffer.allocate(4).putInt(b).array());
        }

        @Override
        public void write(byte @Nullable [] b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (b != null) {
                this.websocket.sendAudio(this.header, b);
            }
        }

        @Override
        public void write(byte @Nullable [] b, int off, int len) throws IOException {
            if (b != null) {
                this.write(Arrays.copyOfRange(b, off, off + len));
            }
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }
    }
}

