/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum StreamEncoding {
    BINARY('b'),
    TEXT('t'),
    UTF8('u'),
    LOCAL('l');

    private final char code;
    private static final Map<Character, StreamEncoding> MAP;

    private StreamEncoding(char code) {
        this.code = code;
    }

    public char getCode() {
        return this.code;
    }

    @Nullable
    public static StreamEncoding fromCode(int code) {
        return MAP.get(Character.valueOf((char)code));
    }

    @Nonnull
    public static StreamEncoding requireFromCode(int code) {
        StreamEncoding encoding = StreamEncoding.fromCode(code);
        if (encoding == null) {
            throw new NoSuchElementException("No StreamEncoding found for code " + code);
        }
        return encoding;
    }

    static {
        MAP = new ConcurrentHashMap<Character, StreamEncoding>();
        for (StreamEncoding f : StreamEncoding.values()) {
            MAP.put(Character.valueOf(f.code), f);
        }
        MAP.put(Character.valueOf('1'), LOCAL);
    }
}

