/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.stringprep;

import org.jxmpp.JxmppContext;
import org.jxmpp.XmppAddressParttype;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.LruCache;

public class XmppStringPrepUtil {
    private static final Cache<String, String> NODEPREP_CACHE = new LruCache<String, String>(100);
    private static final Cache<String, String> DOMAINPREP_CACHE = new LruCache<String, String>(100);
    private static final Cache<String, String> RESOURCEPREP_CACHE = new LruCache<String, String>(100);

    public static String localprep(String string2) throws XmppStringprepException {
        return XmppStringPrepUtil.localprep(string2, JxmppContext.getDefaultContext());
    }

    public static String localprep(String string2, JxmppContext context) throws XmppStringprepException {
        String res;
        XmppStringPrepUtil.throwIfNullOrEmpty(string2, XmppAddressParttype.localpart);
        if (context.isCachingEnabled() && (res = NODEPREP_CACHE.lookup(string2)) != null) {
            return res;
        }
        res = context.xmppStringprep.localprep(string2);
        if (context.isCachingEnabled()) {
            NODEPREP_CACHE.put(string2, res);
        }
        return res;
    }

    public static String domainprep(String string2) throws XmppStringprepException {
        return XmppStringPrepUtil.domainprep(string2, JxmppContext.getDefaultContext());
    }

    public static String domainprep(String string2, JxmppContext context) throws XmppStringprepException {
        String res;
        XmppStringPrepUtil.throwIfNullOrEmpty(string2, XmppAddressParttype.domainpart);
        if (context.isCachingEnabled() && (res = DOMAINPREP_CACHE.lookup(string2)) != null) {
            return res;
        }
        res = context.xmppStringprep.domainprep(string2);
        if (context.isCachingEnabled()) {
            DOMAINPREP_CACHE.put(string2, res);
        }
        return res;
    }

    public static String resourceprep(String string2) throws XmppStringprepException {
        return XmppStringPrepUtil.resourceprep(string2, JxmppContext.getDefaultContext());
    }

    public static String resourceprep(String string2, JxmppContext context) throws XmppStringprepException {
        String res;
        XmppStringPrepUtil.throwIfNullOrEmpty(string2, XmppAddressParttype.resourcepart);
        if (context.isCachingEnabled() && (res = RESOURCEPREP_CACHE.lookup(string2)) != null) {
            return res;
        }
        res = context.xmppStringprep.resourceprep(string2);
        if (context.isCachingEnabled()) {
            RESOURCEPREP_CACHE.put(string2, res);
        }
        return res;
    }

    public static void setMaxCacheSizes(int size2) {
        NODEPREP_CACHE.setMaxCacheSize(size2);
        DOMAINPREP_CACHE.setMaxCacheSize(size2);
        RESOURCEPREP_CACHE.setMaxCacheSize(size2);
    }

    private static void throwIfNullOrEmpty(String string2, XmppAddressParttype type) throws XmppStringprepException {
        if (string2 == null) {
            throw new XmppStringprepException(string2, String.valueOf((Object)type) + " can't be null");
        }
        if (string2.isEmpty()) {
            throw new XmppStringprepException(string2, String.valueOf((Object)type) + " can't be the empty string");
        }
    }
}

