/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.spoiler.element;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class SpoilerElement
implements ExtensionElement {
    public static final String ELEMENT = "spoiler";
    public static final String NAMESPACE = "urn:xmpp:spoiler:0";
    public static final QName QNAME = new QName("urn:xmpp:spoiler:0", "spoiler");
    public static final SpoilerElement EMPTY = new SpoilerElement(null, null);
    private final String hint;
    private final String language;

    public SpoilerElement(String language2, String hint) {
        if (StringUtils.isNotEmpty((CharSequence)language2) && StringUtils.isNullOrEmpty((CharSequence)hint)) {
            throw new IllegalArgumentException("Hint cannot be null or empty if language is not empty.");
        }
        this.language = language2;
        this.hint = hint;
    }

    public String getHint() {
        return this.hint;
    }

    public static void addSpoiler(Message message) {
        message.addExtension(EMPTY);
    }

    public static void addSpoiler(Message message, String hint) {
        message.addExtension(new SpoilerElement(null, hint));
    }

    public static void addSpoiler(Message message, String lang, String hint) {
        message.addExtension(new SpoilerElement(lang, hint));
    }

    public static boolean containsSpoiler(Message message) {
        return message.hasExtension(ELEMENT, NAMESPACE);
    }

    public static Map<String, String> getSpoilers(Message message) {
        if (!SpoilerElement.containsSpoiler(message)) {
            return Collections.emptyMap();
        }
        List<SpoilerElement> spoilers = message.getExtensions(SpoilerElement.class);
        HashMap<String, String> map = new HashMap<String, String>();
        for (SpoilerElement s : spoilers) {
            if (s.getLanguage() == null || s.getLanguage().equals("")) {
                map.put("", s.getHint());
                continue;
            }
            map.put(s.getLanguage(), s.getHint());
        }
        return map;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
        if (this.getHint() == null) {
            xml.closeEmptyElement();
        } else {
            xml.rightAngleBracket();
            xml.append(this.getHint());
            xml.closeElement(this);
        }
        return xml;
    }
}

