/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.internal;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jivesoftware.smackx.omemo.internal.OmemoAesCipher;

public class CipherAndAuthTag {
    private final byte[] key;
    private final byte[] iv;
    private final byte[] authTag;
    private final boolean wasPreKey;

    public CipherAndAuthTag(byte[] key, byte[] iv, byte[] authTag, boolean wasPreKey) {
        this.authTag = authTag;
        this.key = key;
        this.iv = iv;
        this.wasPreKey = wasPreKey;
    }

    public String decrypt(byte[] ciphertext) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        byte[] plaintext = OmemoAesCipher.decryptAesGcmNoPadding(ciphertext, this.key, this.iv);
        return new String(plaintext, StandardCharsets.UTF_8);
    }

    public byte[] getAuthTag() {
        if (this.authTag != null) {
            return (byte[])this.authTag.clone();
        }
        return null;
    }

    public byte[] getKey() {
        if (this.key != null) {
            return (byte[])this.key.clone();
        }
        return null;
    }

    public byte[] getIv() {
        if (this.iv != null) {
            return (byte[])this.iv.clone();
        }
        return null;
    }

    public boolean wasPreKeyEncrypted() {
        return this.wasPreKey;
    }
}

