/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.stringencoder;

import org.jivesoftware.smack.util.stringencoder.StringEncoder;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class BareJidEncoder
implements StringEncoder<BareJid> {

    public static class UrlSafeEncoder
    extends BareJidEncoder {
        @Override
        public String encode(BareJid jid) {
            return jid.asUrlEncodedString();
        }

        @Override
        public BareJid decode(String string2) {
            try {
                return JidCreate.bareFromUrlEncoded(string2);
            }
            catch (XmppStringprepException e) {
                throw new IllegalArgumentException("BareJid cannot be decoded.", e);
            }
        }
    }

    @Deprecated
    public static class LegacyEncoder
    extends BareJidEncoder {
        @Override
        public String encode(BareJid jid) {
            return jid.toString();
        }

        @Override
        public BareJid decode(String string2) {
            try {
                return JidCreate.bareFrom(string2);
            }
            catch (XmppStringprepException e) {
                throw new IllegalArgumentException("BareJid cannot be decoded.", e);
            }
        }
    }
}

