/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.MultiMap;
import org.jxmpp.util.cache.LruCache;

public class XmppElementUtil {
    private static final LruCache<Class<? extends XmlElement>, QName> CLASS_TO_QNAME_CACHE = new LruCache(512);
    public static final Logger LOGGER = Logger.getLogger(XmppElementUtil.class.getName());

    public static QName getQNameFor(Class<? extends XmlElement> fullyQualifiedElement) {
        String namespace;
        String element;
        QName qname = CLASS_TO_QNAME_CACHE.get(fullyQualifiedElement);
        if (qname != null) {
            return qname;
        }
        try {
            Object qnameObject = fullyQualifiedElement.getField("QNAME").get(null);
            if (QName.class.isAssignableFrom(qnameObject.getClass())) {
                qname = (QName)qnameObject;
                CLASS_TO_QNAME_CACHE.put(fullyQualifiedElement, qname);
                return qname;
            }
            LOGGER.warning("The QNAME field of " + String.valueOf(fullyQualifiedElement) + " is not of type QNAME.");
        }
        catch (NoSuchFieldException e) {
            LOGGER.finer("The " + String.valueOf(fullyQualifiedElement) + " has no static QNAME field. Consider adding one.");
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            element = (String)fullyQualifiedElement.getField("ELEMENT").get(null);
            namespace = (String)fullyQualifiedElement.getField("NAMESPACE").get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException("The " + String.valueOf(fullyQualifiedElement) + " has no ELEMENT, NAMESPACE or QNAME member. Consider adding QNAME", e);
        }
        qname = new QName(namespace, element);
        CLASS_TO_QNAME_CACHE.put(fullyQualifiedElement, qname);
        return qname;
    }

    public static <E extends ExtensionElement> List<E> getElementsFrom(MultiMap<QName, XmlElement> elementMap, Class<E> extensionElementClass) {
        QName qname = XmppElementUtil.getQNameFor(extensionElementClass);
        List<XmlElement> extensionElements = elementMap.getAll(qname);
        if (extensionElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<E> res = new ArrayList<E>(extensionElements.size());
        for (XmlElement extensionElement : extensionElements) {
            E e = XmppElementUtil.castOrThrow(extensionElement, extensionElementClass);
            res.add(e);
        }
        return res;
    }

    public static <E extends ExtensionElement> E castOrThrow(XmlElement extensionElement, Class<E> extensionElementClass) {
        if (!extensionElementClass.isInstance(extensionElement)) {
            String detailMessage;
            QName qname = XmppElementUtil.getQNameFor(extensionElementClass);
            if (extensionElement instanceof StandardExtensionElement) {
                detailMessage = "because there is no according extension element provider registered with ProviderManager for " + String.valueOf(qname) + ". WARNING: This indicates a serious problem with your Smack setup, probably causing Smack not being able to properly initialize itself.";
            } else {
                ExtensionElementProvider<ExtensionElement> provider = ProviderManager.getExtensionProvider(qname);
                detailMessage = "because there is an inconsistency with the provider registered with ProviderManager: the active provider for " + String.valueOf(qname) + " '" + String.valueOf(provider.getClass()) + "' does not return instances of type " + String.valueOf(extensionElementClass) + ", but instead returns instances of type " + String.valueOf(extensionElement.getClass()) + ".";
            }
            String message = "Extension element is not of expected class '" + extensionElementClass.getName() + "', " + detailMessage;
            throw new IllegalStateException(message);
        }
        return (E)((ExtensionElement)extensionElementClass.cast(extensionElement));
    }
}

