/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Mechanisms;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.core.ScramSha1PlusMechanism;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.util.StringUtils;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;

public final class SASLAuthentication {
    private static final Logger LOGGER = Logger.getLogger(SASLAuthentication.class.getName());
    private static final List<SASLMechanism> REGISTERED_MECHANISMS = new ArrayList<SASLMechanism>();
    private static final Set<String> BLACKLISTED_MECHANISMS = new HashSet<String>();
    private final AbstractXMPPConnection connection;
    private final ConnectionConfiguration configuration;
    private SASLMechanism currentMechanism = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSASLMechanism(SASLMechanism mechanism) {
        List<SASLMechanism> list2 = REGISTERED_MECHANISMS;
        synchronized (list2) {
            REGISTERED_MECHANISMS.add(mechanism);
            Collections.sort(REGISTERED_MECHANISMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getRegisterdSASLMechanisms() {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        List<SASLMechanism> list2 = REGISTERED_MECHANISMS;
        synchronized (list2) {
            for (SASLMechanism mechanism : REGISTERED_MECHANISMS) {
                answer.put(mechanism.getClass().getName(), mechanism.toString());
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSaslMechanismRegistered(String saslMechanism) {
        List<SASLMechanism> list2 = REGISTERED_MECHANISMS;
        synchronized (list2) {
            for (SASLMechanism mechanism : REGISTERED_MECHANISMS) {
                if (!mechanism.getName().equals(saslMechanism)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterSASLMechanism(String clazz) {
        List<SASLMechanism> list2 = REGISTERED_MECHANISMS;
        synchronized (list2) {
            Iterator<SASLMechanism> it = REGISTERED_MECHANISMS.iterator();
            while (it.hasNext()) {
                SASLMechanism mechanism = it.next();
                if (!mechanism.getClass().getName().equals(clazz)) continue;
                it.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean blacklistSASLMechanism(String mechanism) {
        Set<String> set = BLACKLISTED_MECHANISMS;
        synchronized (set) {
            return BLACKLISTED_MECHANISMS.add(mechanism);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unBlacklistSASLMechanism(String mechanism) {
        Set<String> set = BLACKLISTED_MECHANISMS;
        synchronized (set) {
            return BLACKLISTED_MECHANISMS.remove(mechanism);
        }
    }

    public static Set<String> getBlacklistedSASLMechanisms() {
        return Collections.unmodifiableSet(BLACKLISTED_MECHANISMS);
    }

    SASLAuthentication(AbstractXMPPConnection connection, ConnectionConfiguration configuration) {
        this.configuration = configuration;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SASLMechanism authenticate(String username, String password, EntityBareJid authzid, SSLSession sslSession) throws XMPPException.XMPPErrorException, SASLErrorException, IOException, InterruptedException, SmackException.SmackSaslException, SmackException.NotConnectedException, SmackException.NoResponseException {
        SASLMechanism mechanism = this.selectMechanism(authzid, password);
        CallbackHandler callbackHandler = this.configuration.getCallbackHandler();
        String host = this.connection.getHost();
        DomainBareJid xmppServiceDomain = this.connection.getXMPPServiceDomain();
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            long now;
            this.currentMechanism = mechanism;
            if (callbackHandler != null) {
                this.currentMechanism.authenticate(host, xmppServiceDomain, callbackHandler, authzid, sslSession);
            } else {
                this.currentMechanism.authenticate(username, host, xmppServiceDomain, password, authzid, sslSession);
            }
            long deadline = System.currentTimeMillis() + this.connection.getReplyTimeout();
            while (!mechanism.isFinished() && (now = System.currentTimeMillis()) < deadline) {
                this.wait(deadline - now);
            }
        }
        mechanism.throwExceptionIfRequired();
        return mechanism;
    }

    void challengeReceived(SaslNonza.Challenge challenge) throws SmackException, InterruptedException {
        this.challengeReceived(challenge.getData(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void challengeReceived(String challenge, boolean finalChallenge) throws SmackException.SmackSaslException, SmackException.NotConnectedException, InterruptedException {
        SASLMechanism mechanism;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            mechanism = this.currentMechanism;
        }
        mechanism.challengeReceived(challenge, finalChallenge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticated(SaslNonza.Success success) throws InterruptedException, SmackException.SmackSaslException, SmackException.NotConnectedException {
        if (success.getData() != null) {
            this.challengeReceived(success.getData(), true);
        }
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.currentMechanism.afterFinalSaslChallenge();
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticationFailed(SaslNonza.SASLFailure saslFailure) {
        SASLErrorException saslErrorException;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            saslErrorException = new SASLErrorException(this.currentMechanism.getName(), saslFailure);
        }
        this.authenticationFailed(saslErrorException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void authenticationFailed(Exception exception) {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.currentMechanism.setException(exception);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticationSuccessful() {
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            if (this.currentMechanism == null) {
                return false;
            }
            return this.currentMechanism.isAuthenticationSuccessful();
        }
    }

    String getNameOfLastUsedSaslMechansism() {
        SASLMechanism lastUsedMech = this.currentMechanism;
        if (lastUsedMech == null) {
            return null;
        }
        return lastUsedMech.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SASLMechanism selectMechanism(EntityBareJid authzid, String password) throws SmackException.SmackSaslException {
        boolean passwordAvailable = StringUtils.isNotEmpty((CharSequence)password);
        Iterator<SASLMechanism> it = REGISTERED_MECHANISMS.iterator();
        List<String> serverMechanisms = this.getServerMechanisms();
        if (serverMechanisms.isEmpty()) {
            LOGGER.warning("Server did not report any SASL mechanisms");
        }
        ArrayList<CallSite> skipReasons = new ArrayList<CallSite>();
        while (it.hasNext()) {
            SASLMechanism mechanism = it.next();
            String mechanismName = mechanism.getName();
            if (!serverMechanisms.contains(mechanismName)) continue;
            Set<String> set = BLACKLISTED_MECHANISMS;
            synchronized (set) {
                if (BLACKLISTED_MECHANISMS.contains(mechanismName)) {
                    continue;
                }
            }
            if (!this.configuration.isEnabledSaslMechanism(mechanismName)) continue;
            if (authzid != null && !mechanism.authzidSupported()) {
                skipReasons.add((CallSite)((Object)("Skipping " + String.valueOf(mechanism) + " because authzid is required by not supported by this SASL mechanism")));
                continue;
            }
            if (mechanism.requiresPassword() && !passwordAvailable) {
                skipReasons.add((CallSite)((Object)("Skipping " + String.valueOf(mechanism) + " because a password is required for it, but none was provided to the connection configuration")));
                continue;
            }
            return mechanism.instanceForAuthentication(this.connection, this.configuration);
        }
        Set<String> set = BLACKLISTED_MECHANISMS;
        synchronized (set) {
            throw new SmackException.SmackSaslException("No supported and enabled SASL Mechanism provided by server. Server announced mechanisms: " + String.valueOf(serverMechanisms) + ". Registered SASL mechanisms with Smack: " + String.valueOf(REGISTERED_MECHANISMS) + ". Enabled SASL mechanisms for this connection: " + String.valueOf(this.configuration.getEnabledSaslMechanisms()) + ". Blacklisted SASL mechanisms: " + String.valueOf(BLACKLISTED_MECHANISMS) + ". Skip reasons: " + String.valueOf(skipReasons));
        }
    }

    private List<String> getServerMechanisms() {
        Mechanisms mechanisms = this.connection.getFeature(Mechanisms.class);
        if (mechanisms == null) {
            return Collections.emptyList();
        }
        return mechanisms.getMechanisms();
    }

    static {
        SASLAuthentication.blacklistSASLMechanism(ScramSha1PlusMechanism.NAME);
    }
}

