/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.Err;

public class TemplateRuleTraceListener {
    private int depth = 0;
    private Logger logger;

    public TemplateRuleTraceListener(Logger logger) {
        this.logger = logger;
    }

    public void enter(String instName, Location instLoc, Item item, TemplateRule rule) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.depth; ++i) {
            builder.append(' ');
        }
        ++this.depth;
        builder.append(instName).append(" at ").append(Err.show(instLoc));
        builder.append(" to ").append(item.toShortString());
        if (item instanceof NodeInfo && ((NodeInfo)item).getLineNumber() != -1) {
            builder.append(" at ").append(Err.abbreviateURI(((NodeInfo)item).getBaseURI())).append("#").append(((NodeInfo)item).getLineNumber());
        }
        builder.append(" using ");
        if (rule == null) {
            builder.append("built-in rule");
        } else {
            builder.append("rule at ").append(Err.show(rule));
        }
        String message = builder.toString().replace(" .../", " ");
        this.logger.info(message);
    }

    public void leave() {
        --this.depth;
    }
}

