/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Arrays;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.SchemaType;

public class StylesheetSpaceStrippingRule
implements SpaceStrippingRule {
    private static final int[] specials = new int[]{131, 132, 133, 138, 140, 142, 143, 153, 173, 176, 182, 183, 208, 212};
    private final NamePool namePool;

    public StylesheetSpaceStrippingRule(NamePool pool) {
        this.namePool = pool;
    }

    @Override
    public int isSpacePreserving(NodeName elementName, SchemaType schemaType) {
        int fingerprint = elementName.obtainFingerprint(this.namePool);
        if (fingerprint == 211) {
            return 1;
        }
        if (Arrays.binarySearch(specials, fingerprint) >= 0) {
            return 2;
        }
        return 0;
    }

    @Override
    public ProxyReceiver makeStripper(Receiver next) {
        return new Stripper(this, next);
    }

    @Override
    public void export(ExpressionPresenter presenter) {
    }
}

