/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown;

import com.elovirta.dita.markdown.DitaRendererOptions;
import com.elovirta.dita.markdown.SaxWriter;
import com.elovirta.dita.markdown.renderer.DitaIdGenerator;
import com.elovirta.dita.markdown.renderer.HeaderIdGenerator;
import com.elovirta.dita.markdown.renderer.MapRenderer;
import com.elovirta.dita.markdown.renderer.NodeRendererContext;
import com.elovirta.dita.markdown.renderer.NodeRenderingHandler;
import com.elovirta.dita.markdown.renderer.TopicRenderer;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.ScopedDataSet;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DitaRenderer {
    public static final DataKey<Boolean> SHORTDESC_PARAGRAPH = new DataKey("SHORTDESC_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> TIGHT_LIST = new DataKey("TIGHT_LIST", (Object)true);
    public static final DataKey<Boolean> ID_FROM_YAML = new DataKey("ID_FROM_YAML", (Object)false);
    public static final DataKey<Boolean> RAW_DITA = new DataKey("RAW_DITA", (Object)true);
    @Deprecated
    public static final DataKey<Boolean> LW_DITA = new DataKey("LW_DITA", (Object)false);
    public static final DataKey<Boolean> MDITA_CORE_PROFILE = new DataKey("MDITA_CORE_PROFILE", (Object)false);
    public static final DataKey<Boolean> MDITA_EXTENDED_PROFILE = new DataKey("MDITA_EXTENDED_PROFILE", (Object)false);
    public static final DataKey<Boolean> SPECIALIZATION = new DataKey("SPECIALIZATION", (Object)false);
    public static final DataKey<Boolean> SPECIALIZATION_CONCEPT = new DataKey("SPECIALIZATION_CONCEPT", (Object)false);
    public static final DataKey<Boolean> SPECIALIZATION_TASK = new DataKey("SPECIALIZATION_TASK", (Object)false);
    public static final DataKey<Boolean> SPECIALIZATION_REFERENCE = new DataKey("SPECIALIZATION_REFERENCE", (Object)false);
    public static final DataKey<Boolean> WIKI = new DataKey("WIKI", (Object)false);
    public static final DataKey<Boolean> FIX_ROOT_HEADING = new DataKey("FIXUP_ROOT_HEADING", (Object)false);
    public static final DataKey<Boolean> MAP = new DataKey("MAP", (Object)false);
    public static final DataKey<Boolean> SUPPRESS_HTML = new DataKey("SUPPRESS_HTML", (Object)false);
    public static final DataKey<Boolean> SUPPRESS_HTML_BLOCKS = new DataKey("SUPPRESS_HTML_BLOCKS", SUPPRESS_HTML);
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_RESOLVE_DUPES = SharedDataKeys.HEADER_ID_GENERATOR_RESOLVE_DUPES;
    public static final DataKey<String> HEADER_ID_GENERATOR_TO_DASH_CHARS = SharedDataKeys.HEADER_ID_GENERATOR_TO_DASH_CHARS;
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_NO_DUPED_DASHES = SharedDataKeys.HEADER_ID_GENERATOR_NO_DUPED_DASHES;
    public static final DataKey<Boolean> DO_NOT_RENDER_LINKS = SharedDataKeys.DO_NOT_RENDER_LINKS;
    public static final DataKey<String> FENCED_CODE_LANGUAGE_CLASS_PREFIX = new DataKey("FENCED_CODE_LANGUAGE_CLASS_PREFIX", (Object)"language-");
    public static final DataKey<String> FENCED_CODE_NO_LANGUAGE_CLASS = new DataKey("FENCED_CODE_NO_LANGUAGE_CLASS", (Object)"");
    private final DitaRendererOptions ditaOptions;
    private final DataHolder options;

    DitaRenderer(DataSet builder) {
        this.options = new MutableDataSet((DataHolder)builder).set(MDITA_EXTENDED_PROFILE, (Object)((Boolean)LW_DITA.get((DataHolder)builder) != false || (Boolean)MDITA_EXTENDED_PROFILE.get((DataHolder)builder) != false ? 1 : 0)).toImmutable();
        this.ditaOptions = new DitaRendererOptions(this.options);
    }

    public void render(Node node, ContentHandler out) {
        SaxWriter saxWriter = new SaxWriter(out);
        MainNodeRenderer renderer = new MainNodeRenderer(this.options, saxWriter, node.getDocument());
        renderer.render(node);
    }

    private class MainNodeRenderer
    implements NodeRendererContext {
        private final Document document;
        private final Map<Class<? extends Node>, NodeRenderingHandler<? extends Node>> renderers;
        private final DataHolder options;
        private final DitaIdGenerator ditaIdGenerator;
        private final SaxWriter saxWriter;
        private Node renderingNode;
        private NodeRenderingHandler<? extends Node> renderingHandler;
        private int doNotRenderLinksNesting;

        MainNodeRenderer(DataHolder options, SaxWriter saxWriter, Document document) {
            this.saxWriter = saxWriter;
            this.renderingNode = null;
            this.doNotRenderLinksNesting = 0;
            this.options = new ScopedDataSet(options, (DataHolder)document);
            this.document = document;
            this.renderers = (Boolean)MAP.get(options) != false ? new MapRenderer(this.getOptions()).getNodeRenderingHandlers() : new TopicRenderer(this.getOptions()).getNodeRenderingHandlers();
            this.doNotRenderLinksNesting = DitaRenderer.this.ditaOptions.doNotRenderLinksInDocument ? 0 : 1;
            this.ditaIdGenerator = new HeaderIdGenerator();
        }

        @Override
        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        public DitaRendererOptions getDitaOptions() {
            return DitaRenderer.this.ditaOptions;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public void render(Node node) {
            try {
                this.saxWriter.startDocument();
                this.saxWriter.getContentHandler().startDocument();
                this.saxWriter.getContentHandler().startPrefixMapping("ditaarch", "http://dita.oasis-open.org/architecture/2005/");
                this.renderNode(node, this);
                this.saxWriter.close();
                this.saxWriter.getContentHandler().endPrefixMapping("ditaarch");
                this.saxWriter.getContentHandler().endDocument();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderNode(Node node, MainNodeRenderer subContext) {
            if (node instanceof Document) {
                int oldDoNotRenderLinksNesting = subContext.getDoNotRenderLinksNesting();
                int documentDoNotRenderLinksNesting = this.getDitaOptions().doNotRenderLinksInDocument ? 1 : 0;
                this.ditaIdGenerator.generateIds(this.document);
                NodeRenderingHandler<? extends Node> nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer != null) {
                    subContext.doNotRenderLinksNesting = documentDoNotRenderLinksNesting;
                    NodeRenderingHandler<? extends Node> prevWrapper = subContext.renderingHandler;
                    try {
                        subContext.renderingNode = node;
                        subContext.renderingHandler = nodeRenderer;
                        nodeRenderer.render(node, subContext, subContext.saxWriter);
                    }
                    finally {
                        subContext.renderingHandler = prevWrapper;
                        subContext.renderingNode = null;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                    }
                }
            } else {
                NodeRenderingHandler<? extends Node> nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer != null) {
                    Node oldNode = this.renderingNode;
                    int oldDoNotRenderLinksNesting = subContext.doNotRenderLinksNesting;
                    NodeRenderingHandler<? extends Node> prevWrapper = subContext.renderingHandler;
                    try {
                        subContext.renderingNode = node;
                        subContext.renderingHandler = nodeRenderer;
                        nodeRenderer.render(node, subContext, subContext.saxWriter);
                    }
                    finally {
                        subContext.renderingNode = oldNode;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                        subContext.renderingHandler = prevWrapper;
                    }
                } else {
                    throw new RuntimeException("No renderer configured for " + node.getClass().getName());
                }
            }
        }

        @Override
        public void renderChildren(Node parent) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.renderNode(node, this);
                node = next;
            }
        }

        @Override
        public void renderChild(Node node) {
            this.renderNode(node, this);
        }

        protected int getDoNotRenderLinksNesting() {
            return this.doNotRenderLinksNesting;
        }
    }
}

