RabbitMQ `3.10.4` is a maintenance release in the `3.10.x` release series.

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release requires at least Erlang 23.2, and supports Erlang 24 and 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Enhancements

 * A minor quorum queue optimization.

   GitHub issue: [#4873](https://github.com/rabbitmq/rabbitmq-server/pull/4873)

#### Bug Fixes

 * Avoid seeding default user in old clusters that still use the deprecated `management.load_definitions` option.
   This could result in an extra user, `guest` or under an [overriden default user name](https://rabbitmq.com/access-control.html#default-state), to appear
   in addition to the user accounts imported from definitions.

   Note that the default user with well-known name [can only connect from `localhost` by default](https://rabbitmq.com/access-control.html#loopback-users), so
   this would not expose reasonably configured production nodes to remote connections.

   GitHub issue: [#4904](https://github.com/rabbitmq/rabbitmq-server/pull/4904)

 * Streams could run into an exception or fetch stale stream position data in some scenarios.

   GitHub issue: [#4898](https://github.com/rabbitmq/rabbitmq-server/pull/4898)

 * `rabbitmqctl set_log_level` did not have any effect on logging via [`amq.rabbitmq.log`](https://rabbitmq.com/logging.html#log-exchange) (the system exchange for logging)

   Contributed by Péter @gomoripeti Gömöri (CloudAMQP).

   GitHub issue: [#4891](https://github.com/rabbitmq/rabbitmq-server/pull/4891)


### CLI Tools

#### Bug Fix

 * `rabbitmq-diagnostics status` is now more resilient and won't fail if free disk space monitoring
   repeatedly fails (gets disabled) on the node.

   GitHub issue: [#4900](https://github.com/rabbitmq/rabbitmq-server/pull/4900)


## Dependency Upgrades

 * `ra` upgraded from [`2.0.11` to `2.0.13`](https://github.com/rabbitmq/ra/compare/v2.0.11...v2.0.13)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.4.tar.xz`
instead of the source tarball produced by GitHub.
