/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb;

import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.GenericDataSourceProvider;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBDataSource;
import org.jkiss.dbeaver.ext.iotdb.model.meta.IoTDBMetaModel;
import org.jkiss.dbeaver.ext.iotdb.model.meta.IoTDBTableMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DatabaseURL;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class IoTDBDataSourceProvider
extends GenericDataSourceProvider {
    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        String url = container.getConnectionConfiguration().getUrl();
        if (url.endsWith("?sql_dialect=table")) {
            return new IoTDBDataSource(monitor, container, new IoTDBTableMetaModel(), false);
        }
        return new IoTDBDataSource(monitor, container, new IoTDBMetaModel(), true);
    }

    private static String makePropPattern(String prop) {
        return "{" + prop + "}";
    }

    private boolean useRawUrl(DBPConnectionConfiguration connectionInfo) {
        return !CommonUtils.isEmpty((String)connectionInfo.getUrl()) && CommonUtils.isEmpty((String)connectionInfo.getHostPort()) && CommonUtils.isEmpty((String)connectionInfo.getHostName()) && CommonUtils.isEmpty((String)connectionInfo.getServerName());
    }

    private String buildUrlFromTemplate(DBPConnectionConfiguration connectionInfo, String urlTemplate) throws DBException {
        DatabaseURL.MetaURL metaURL = DatabaseURL.parseSampleURL((String)urlTemplate);
        StringBuilder url = new StringBuilder();
        Iterator iterator = metaURL.getUrlComponents().iterator();
        while (iterator.hasNext()) {
            String component;
            String newComponent = component = (String)iterator.next();
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                newComponent = newComponent.replace(IoTDBDataSourceProvider.makePropPattern("host"), connectionInfo.getHostName());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                newComponent = newComponent.replace(IoTDBDataSourceProvider.makePropPattern("port"), connectionInfo.getHostPort());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
                newComponent = newComponent.replace(IoTDBDataSourceProvider.makePropPattern("sqlDialect"), connectionInfo.getServerName());
            }
            if ((newComponent = newComponent.replace(IoTDBDataSourceProvider.makePropPattern("user"), CommonUtils.notEmpty((String)connectionInfo.getUserName()))).startsWith("[")) {
                if (newComponent.equals(component)) continue;
                url.append(newComponent.substring(1, newComponent.length() - 1));
                continue;
            }
            url.append(newComponent);
        }
        return url.toString();
    }

    @NotNull
    public String getConnectionURL(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        String urlTemplate = driver.getSampleURL();
        if (this.useRawUrl(connectionInfo)) {
            return connectionInfo.getUrl();
        }
        if (CommonUtils.isEmptyTrimmed((String)urlTemplate)) {
            return connectionInfo.getUrl();
        }
        try {
            return this.buildUrlFromTemplate(connectionInfo, urlTemplate);
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }
}

