#line 2 "engines/director/lingo/lingo-lex.cpp"
/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#define YY_NO_UNISTD_H
#define FORBIDDEN_SYMBOL_EXCEPTION_FILE
#define FORBIDDEN_SYMBOL_EXCEPTION_fprintf
#define FORBIDDEN_SYMBOL_EXCEPTION_fwrite
#define FORBIDDEN_SYMBOL_EXCEPTION_fread
#define FORBIDDEN_SYMBOL_EXCEPTION_stdin
#define FORBIDDEN_SYMBOL_EXCEPTION_stdout
#define FORBIDDEN_SYMBOL_EXCEPTION_stderr
#define FORBIDDEN_SYMBOL_EXCEPTION_exit
#define FORBIDDEN_SYMBOL_EXCEPTION_getc

#include "common/str.h"

#include "director/director.h"
#include "director/lingo/lingo.h"
#include "director/lingo/lingo-ast.h"
#include "director/lingo/lingo-codegen.h"
#include "director/lingo/lingo-gr.h"
#include "director/lingo/lingo-the.h"

using namespace Director;

static const char *inputbuffer;
static uint inputlen;

#line 49 "engines/director/lingo/lingo-lex.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 92
#define YY_END_OF_BUFFER 93
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[368] =
    {   0,
        0,    0,   93,   91,    1,   89,   89,   91,   91,   88,
       88,   87,   88,   84,   88,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   91,    1,   85,   91,    1,
       89,    0,    0,   90,    2,   83,   86,   87,   82,   80,
       81,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   25,   85,
       27,   31,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   50,   51,   85,   53,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   71,

       85,   85,   85,   85,    1,    0,    0,   85,    2,   86,
       85,   85,    7,   85,   85,   85,   85,   85,   85,   85,
       85,   19,   85,   85,   85,   85,    0,    0,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   45,
       85,   85,   48,   85,   85,   85,   85,   85,   57,   85,
       85,   85,   85,   62,   85,   85,   85,   85,   85,   68,
       85,   85,   85,   85,   85,   85,   85,    0,   85,    5,
       85,   85,    9,   12,   85,   15,   85,   17,   18,    0,
        0,   20,   85,   85,   85,    0,   85,   85,   85,   30,
       32,   34,   35,   37,   85,   85,   40,   85,   85,   47,

       85,   52,   54,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   67,   69,   70,   85,   85,   85,   75,
       77,   85,    0,   85,   85,    6,   85,   85,   13,   85,
       85,   19,   22,   23,   85,   25,   85,   85,   85,   33,
       36,   38,   85,   85,   41,   85,   46,   85,   85,   85,
       85,   85,   85,   85,   63,   64,   85,   85,    0,    0,
       73,   85,   85,   78,   79,    0,   85,    4,    8,   85,
       85,   16,   19,   24,   26,   85,   85,   39,   85,   44,
       49,   85,   85,   58,   59,   60,   85,   65,   66,    0,
        0,    0,   74,   76,    0,   85,   85,   10,   85,   85,

       85,   85,   85,   85,   85,    0,    0,    0,    0,   21,
       85,   11,   14,   28,   85,   42,   55,   56,   85,    0,
        0,    0,   21,   85,   85,   43,   85,    0,    0,    0,
        0,   85,   29,   85,    0,    0,    0,    0,    3,   85,
        0,    0,    0,    0,    0,    0,   85,    0,    0,    0,
        0,    0,   85,    0,    0,   85,    0,    0,   85,   72,
       85,   72,   72,   72,   85,   61,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    1,    6,    7,    1,    8,    9,    1,    8,
        8,    8,    8,    8,    8,   10,    8,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,    8,    1,   12,
       13,   14,    1,    1,   15,   16,   17,   18,   19,   20,
       21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
       24,   31,   32,   33,   34,   35,   36,   37,   38,   24,
        8,    1,    8,    8,   24,    1,   39,   40,   41,   42,

       43,   44,   45,   46,   47,   24,   48,   49,   50,   51,
       52,   53,   24,   54,   55,   56,   57,   58,   59,   60,
       61,   24,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,   62,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,   63,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[64] =
    {   0,
        1,    2,    3,    3,    2,    1,    1,    1,    1,    4,
        4,    1,    1,    1,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    1,    2
    } ;

static const flex_int16_t yy_base[375] =
    {   0,
        0,   62,  466,  823,   66,  823,  823,  439,    0,  823,
      429,   55,   59,  823,  404,   58,   56,   61,   62,   59,
       57,   63,   56,   98,    0,  101,  108,  109,  137,  138,
       74,  179,  181,  133,   64,  243,  130,  182,  239,  212,
      823,  196,  245,  823,    0,  823,  178,   84,  823,  823,
      823,    0,  105,  103,  104,  119,  139,  143,  148,  150,
      158,  175,  186,  160,  196,  204,  211,  201,  235,  212,
        0,  212,  220,  210,  218,  220,  232,  227,  239,  219,
      226,  235,    0,    0,  233,    0,  249,  251,  233,  254,
      259,  239,  257,  257,  261,  281,  273,  281,  275,    0,

      285,  278,  281,  286,  334,  303,  124,  302,    0,  166,
      290,  304,    0,  297,  294,  299,  300,  312,  322,  317,
      327,  346,  319,  331,  331,  343,  358,  113,  338,  331,
      343,  339,  334,  350,  353,  340,  360,  339,  355,    0,
      356,  349,    0,  368,  360,  354,  364,  372,    0,  385,
      372,  384,  383,    0,  381,  385,  393,  387,  393,  392,
      404,  398,  401,  406,  408,  414,  419,  420,  406,  425,
      415,  420,  426,  421,  440,    0,  424,    0,    0,  458,
      111,    0,  441,  445,  450,  438,  437,  456,  442,    0,
      445,    0,  446,    0,  452,  463,  462,  455,  467,    0,

      468,    0,    0,  468,  473,  483,  466,  472,  476,  472,
      481,  475,  479,    0,    0,    0,  522,  494,  489,  491,
      487,  497,  497,  503,  498,    0,  515,  513,    0,  516,
      521,    0,    0,    0,  517,  823,  525,  518,  515,    0,
        0,    0,  517,  516,    0,  532,    0,  523,  528,  528,
      528,  537,  534,  538,    0,    0,  532,  544,  576,  108,
        0,  543,  555,    0,    0,  558,  558,  539,    0,  575,
      565,    0,    0,    0,    0,  577,  576,    0,  578,    0,
        0,  566,  571,    0,    0,    0,  578,    0,    0,  579,
      578,  588,    0,    0,  577,  575,  599,  585,  588,  606,

      612,  606,  602,  599,  626,  606,  611,  619,  609,    0,
      615,    0,    0,    0,  617,  619,    0,    0,  620,  624,
      622,  636,  823,  640,  629,    0,  630,  634,  634,  653,
      647,  660,    0,  661,  646,  686,  672,  655,    0,  661,
      665,  692,   82,  666,  668,  667,  668,  705,  681,  672,
      715,  717,  690,  692,  685,  697,  702,  732,  707,  737,
      711,    0,  739,   79,  712,    0,  823,  802,   79,  804,
      806,  810,  812,  817
    } ;

static const flex_int16_t yy_def[375] =
    {   0,
      367,    1,  367,  367,  367,  367,  367,  368,  369,  367,
      367,  367,  367,  367,  367,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  367,  367,  370,  367,  367,
      367,  367,  368,  367,  371,  367,  367,  367,  367,  367,
      367,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,

      370,  370,  370,  370,  367,  367,  367,  370,  371,  367,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  367,  367,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  367,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  372,
      367,  370,  370,  370,  370,  367,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,

      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  367,  370,  370,  370,  370,  370,  370,  370,
      370,  373,  370,  370,  370,  367,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  367,  367,
      370,  370,  370,  370,  370,  367,  370,  370,  370,  370,
      370,  370,  373,  370,  370,  370,  370,  370,  370,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  367,
      367,  367,  370,  370,  367,  370,  370,  370,  370,  370,

      370,  370,  370,  370,  370,  367,  367,  367,  367,  370,
      370,  370,  370,  370,  370,  370,  370,  370,  370,  367,
      367,  367,  367,  370,  370,  370,  370,  367,  367,  367,
      367,  370,  370,  370,  367,  367,  367,  367,  370,  370,
      367,  367,  367,  367,  367,  367,  370,  367,  367,  367,
      367,  367,  370,  367,  367,  370,  367,  367,  370,  374,
      370,  374,  374,  374,  370,  370,    0,  367,  367,  367,
      367,  367,  367,  367
    } ;

static const flex_int16_t yy_nxt[887] =
    {   0,
        4,    5,    6,    7,    5,    8,    9,   10,   11,    4,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
       22,   23,   24,   25,   25,   26,   27,   28,   29,   30,
       31,   32,   33,   25,   25,   34,   35,   25,   16,   17,
       18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
       28,   29,   30,   31,   32,   33,   25,   25,   34,   35,
       25,    4,   36,   37,   47,   48,   37,   40,   41,   41,
       40,   49,   50,   53,   56,   57,   60,   54,   70,   66,
       61,   38,   58,   45,   63,   55,   64,   67,   68,   59,
       62,   69,   90,   47,   48,   65,  104,   53,   56,   57,

       60,   54,   70,   66,   61,   38,   58,   63,   55,   64,
       67,   68,   59,   62,   69,   74,   90,   71,   65,  104,
      111,  113,   77,   75,   39,   72,   78,   80,   42,   76,
       73,  105,   41,   41,  105,  112,   79,   81,  114,   74,
      363,   71,   82,  342,  111,  113,   77,   75,   72,  106,
       78,   80,   76,   73,  101,  102,   83,  116,  112,   79,
       81,  103,  114,   87,   84,   82,   85,   86,   88,  259,
      115,   89,  180,  106,  127,  117,  110,  122,  101,  102,
       83,  116,  118,  119,  103,  105,   87,   84,  110,   85,
       86,   88,  107,  115,   89,   91,  108,   92,  117,   97,

       93,  122,   98,   99,   66,  118,  119,   94,   95,  100,
      120,   96,   67,   40,   41,   41,   40,  121,  123,   91,
      108,   92,  124,   97,   93,  125,   98,   99,   66,  126,
       94,   95,  100,  120,   96,   67,  127,  129,  132,  127,
      121,  133,  123,  130,  131,  134,  124,  135,  136,  125,
       44,  145,  126,  137,  138,  142,  140,   40,  143,  139,
      129,  144,  132,  146,  133,  149,  130,  131,  134,  147,
      135,  154,  136,  141,   42,  145,  137,  138,  142,  148,
      140,  143,  139,  150,  144,  155,  151,  146,  149,  152,
      156,  157,  153,  147,  154,  158,  141,  128,  159,  160,

      105,  161,  148,  162,   40,  164,  150,  163,  155,  151,
      165,  166,  152,  156,  157,  153,  167,  168,  169,  158,
      170,  159,  171,  160,  161,  172,  173,  162,  164,  174,
      176,  163,  175,  165,  166,  105,   41,   41,  105,  167,
      177,  168,  169,  170,  178,  179,  171,  180,  172,  173,
      180,  182,  174,  106,  176,  175,  183,  184,  185,  127,
      187,  189,  127,  188,  177,  191,  192,  178,  193,  179,
      195,  190,  197,  194,  182,  196,  198,  106,  199,  183,
      184,  200,  185,  201,  187,  189,  188,  202,  191,  192,
      186,  203,  193,  195,  190,  197,  107,  194,  204,  196,

      198,  205,  199,  206,  200,  207,  208,  201,  181,  209,
      202,  210,  211,  186,  203,  212,   51,  213,  214,  215,
      128,  204,  216,  219,  205,  217,  218,  206,  207,  220,
      208,  221,  209,  222,  210,  211,  223,   46,  224,  212,
      213,  214,  215,  225,   44,  226,  216,  219,  217,  218,
      227,  228,  229,  220,  230,  221,  231,  222,  233,  180,
      223,  224,  180,  234,  235,  367,  236,  225,  226,  237,
      238,  367,  239,  227,  228,  229,  240,  241,  230,  231,
      242,  243,  233,  246,  244,  247,  248,  234,  235,  236,
      249,  250,  237,  245,  238,  239,  252,  251,  256,  240,

      241,  253,  254,  242,  255,  243,  246,  257,  244,  247,
      248,  258,  261,  263,  249,  250,  245,  262,  264,  252,
      181,  251,  256,  259,  253,  254,  259,  255,  265,  266,
      257,  267,  268,  269,  258,  270,  261,  263,  271,  272,
      262,  264,  274,  275,  367,  276,  277,  278,  279,  280,
      288,  265,  266,  281,  267,  268,  282,  269,  283,  270,
      284,  297,  271,  272,  285,  274,  286,  275,  276,  277,
      278,  279,  287,  280,  288,  289,  281,  259,  293,  282,
      259,  283,  294,  284,  260,  297,  295,  285,  296,  286,
      298,  367,  299,  300,  301,  287,  302,  306,  289,  303,

      290,  293,  291,  304,  305,  294,  307,  309,  292,  295,
      308,  296,  310,  311,  298,  299,  312,  300,  301,  313,
      302,  306,  303,  290,  314,  291,  304,  305,  315,  307,
      309,  292,  316,  317,  308,  310,  318,  311,  260,  312,
      319,  328,  313,  320,  321,  322,  323,  324,  314,  325,
      326,  327,  315,  330,  331,  316,  317,  329,  332,  318,
      333,  334,  335,  336,  319,  328,  320,  321,  322,  323,
      324,  337,  325,  326,  327,  338,  330,  339,  331,  340,
      329,  341,  332,  333,  334,  335,  336,  342,  346,  344,
      342,  347,  348,  342,  350,  337,  342,  351,  338,  352,

      353,  339,  354,  340,  341,  345,  342,  355,  356,  342,
      357,  346,  358,  344,  347,  348,  342,  350,  342,  342,
      351,  342,  352,  353,  349,  367,  354,  359,  345,  360,
      355,  367,  356,  342,  357,  358,  342,  361,  363,  365,
      363,  363,  366,  363,  367,  367,  367,  349,  343,  367,
      359,  367,  360,  367,  343,  367,  367,  367,  367,  367,
      361,  367,  365,  367,  367,  366,  367,  343,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  343,  367,  343,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  343,  367,  367,  367,  367,  364,

      367,  364,   43,   43,  367,   43,   43,   52,   52,  109,
      109,  232,  367,  367,  232,  273,  273,  362,  362,  367,
      362,  362,    3,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367
    } ;

static const flex_int16_t yy_chk[887] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    2,   12,   12,    2,    5,    5,    5,
        5,   13,   13,   16,   17,   18,   19,   16,   23,   21,
       19,    2,   18,  369,   20,   16,   20,   21,   22,   18,
       19,   22,   31,   48,   48,   20,   35,   16,   17,   18,

       19,   16,   23,   21,   19,    2,   18,   20,   16,   20,
       21,   22,   18,   19,   22,   26,   31,   24,   20,   35,
       53,   55,   27,   26,    2,   24,   27,   28,    5,   26,
       24,   37,   37,   37,   37,   54,   27,   28,   56,   26,
      364,   24,   28,  343,   53,   55,   27,   26,   24,   37,
       27,   28,   26,   24,   34,   34,   29,   58,   54,   27,
       28,   34,   56,   30,   29,   28,   29,   29,   30,  260,
       57,   30,  181,   37,  128,   59,  110,   64,   34,   34,
       29,   58,   60,   61,   34,  107,   30,   29,   47,   29,
       29,   30,   37,   57,   30,   32,   38,   32,   59,   33,

       32,   64,   33,   33,   38,   60,   61,   32,   32,   33,
       62,   32,   38,   40,   40,   40,   40,   63,   65,   32,
       38,   32,   66,   33,   32,   67,   33,   33,   38,   68,
       32,   32,   33,   62,   32,   38,   69,   70,   73,   69,
       63,   74,   65,   72,   72,   75,   66,   76,   77,   67,
       43,   85,   68,   78,   78,   80,   79,   42,   81,   78,
       70,   82,   73,   87,   74,   89,   72,   72,   75,   88,
       76,   92,   77,   79,   40,   85,   78,   78,   80,   88,
       79,   81,   78,   90,   82,   93,   90,   87,   89,   91,
       94,   95,   91,   88,   92,   96,   79,   69,   97,   98,

       39,   99,   88,  101,   36,  102,   90,  101,   93,   90,
      102,  103,   91,   94,   95,   91,  104,  106,  108,   96,
      111,   97,  112,   98,   99,  114,  115,  101,  102,  116,
      118,  101,  117,  102,  103,  105,  105,  105,  105,  104,
      119,  106,  108,  111,  120,  121,  112,  122,  114,  115,
      122,  123,  116,  105,  118,  117,  124,  125,  126,  127,
      129,  131,  127,  130,  119,  132,  133,  120,  134,  121,
      136,  131,  138,  135,  123,  137,  139,  105,  141,  124,
      125,  142,  126,  144,  129,  131,  130,  145,  132,  133,
      127,  146,  134,  136,  131,  138,  105,  135,  147,  137,

      139,  148,  141,  150,  142,  151,  152,  144,  122,  153,
      145,  155,  156,  127,  146,  157,   15,  158,  159,  160,
      127,  147,  161,  164,  148,  162,  163,  150,  151,  165,
      152,  166,  153,  167,  155,  156,  168,   11,  169,  157,
      158,  159,  160,  170,    8,  171,  161,  164,  162,  163,
      172,  173,  174,  165,  175,  166,  177,  167,  183,  180,
      168,  169,  180,  184,  185,    3,  186,  170,  171,  187,
      188,    0,  189,  172,  173,  174,  191,  193,  175,  177,
      195,  196,  183,  198,  197,  199,  201,  184,  185,  186,
      204,  205,  187,  197,  188,  189,  207,  206,  211,  191,

      193,  208,  209,  195,  210,  196,  198,  212,  197,  199,
      201,  213,  218,  220,  204,  205,  197,  219,  221,  207,
      180,  206,  211,  217,  208,  209,  217,  210,  222,  223,
      212,  224,  225,  227,  213,  228,  218,  220,  230,  231,
      219,  221,  235,  237,    0,  238,  239,  243,  244,  246,
      257,  222,  223,  248,  224,  225,  249,  227,  250,  228,
      251,  268,  230,  231,  252,  235,  253,  237,  238,  239,
      243,  244,  254,  246,  257,  258,  248,  259,  262,  249,
      259,  250,  263,  251,  217,  268,  266,  252,  267,  253,
      270,    0,  271,  276,  277,  254,  279,  290,  258,  282,

      259,  262,  259,  283,  287,  263,  291,  295,  259,  266,
      292,  267,  296,  297,  270,  271,  298,  276,  277,  299,
      279,  290,  282,  259,  300,  259,  283,  287,  301,  291,
      295,  259,  302,  303,  292,  296,  304,  297,  259,  298,
      305,  320,  299,  306,  307,  308,  309,  311,  300,  315,
      316,  319,  301,  321,  322,  302,  303,  320,  324,  304,
      325,  327,  328,  329,  305,  320,  306,  307,  308,  309,
      311,  330,  315,  316,  319,  331,  321,  332,  322,  334,
      320,  335,  324,  325,  327,  328,  329,  336,  338,  337,
      336,  340,  341,  342,  344,  330,  342,  345,  331,  346,

      347,  332,  349,  334,  335,  337,  348,  350,  353,  348,
      354,  338,  355,  337,  340,  341,  351,  344,  352,  351,
      345,  352,  346,  347,  342,    0,  349,  356,  337,  357,
      350,    0,  353,  358,  354,  355,  358,  359,  360,  361,
      363,  360,  365,  363,    0,    0,    0,  342,  336,    0,
      356,    0,  357,    0,  342,    0,    0,    0,    0,    0,
      359,    0,  361,    0,    0,  365,    0,  348,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  351,    0,  352,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  358,    0,    0,    0,    0,  360,

        0,  363,  368,  368,    0,  368,  368,  370,  370,  371,
      371,  372,    0,    0,  372,  373,  373,  374,  374,    0,
      374,  374,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "engines/director/lingo/lingo-lex.l"

#define YY_NO_INPUT 1
#line 59 "engines/director/lingo/lingo-lex.l"

// Push lines in stack
static void pushLine(uint num) {
	LingoCompiler *compiler = g_lingo->_compiler;

	if (num > inputlen)
		return;

	compiler->_lines[2] = compiler->_lines[1];
	compiler->_lines[1] = compiler->_lines[0];
	compiler->_lines[0] = &inputbuffer[num];
}

static void count() {
	LingoCompiler *compiler = g_lingo->_compiler;

	if (debugChannelSet(-1, kDebugParse))
		debug("LEXER: Read '%s' at %d:%d", yytext, compiler->_linenumber, compiler->_colnumber);

	char *p = yytext;

	while (*p) {
		if (*p == '\n') {
			compiler->_linenumber++;
			compiler->_colnumber = 0;
			pushLine(compiler->_bytenumber + 1);
		} else if (*p == '\xC2' && *(p + 1) == '\xAC') { // continuation
			compiler->_linenumber++;
			compiler->_colnumber = 0;
		} else {
			compiler->_colnumber++;
		}
		p++;
		compiler->_bytenumber++;
	}
}

static Common::String *cleanupString(const char *s) {
	Common::String *res = new Common::String;

	while (*s) {
		if (*s == '\xC2' && *(s + 1) == '\xAC') { // continuation
			s += 2;
			*res += ' '; // replace with space
			continue;
		}
		*res += *s;
		s++;
	}

	return res;
}

static void skipWhitespace(const char **ptr) {
	while (true) {
		if (**ptr == ' ' || **ptr == '\t') {
			*ptr += 1;
		} else if (**ptr == '\xC2' && *(*ptr + 1) == '\xAC') { // continuation
			*ptr += 2;
		} else {
			break;
		}
	}
}

static Common::String *readUntilWhitespace(const char **ptr) {
	Common::String *res = new Common::String;

	while (true) {
		if (**ptr == ' ' || **ptr == '\t') {
			break;
		}
		if (**ptr == '\xC2' && *(*ptr + 1) == '\xAC') { // continuation
			break;
		}
		*res += **ptr;
		*ptr += 1;
	}

	return res;
}

static Common::String *readUntilNewline(const char **ptr) {
	Common::String *res = new Common::String;

	while ((**ptr != '\n') && (**ptr != '\r') && (**ptr != '\0')) {
		if (**ptr == '\xC2' && *(*ptr + 1) == '\xAC') { // continuation
			*ptr += 2;
			*res += ' '; // replace with space
			continue;
		}
		*res += **ptr;
		*ptr += 1;
	}

	return res;
}

#line 908 "engines/director/lingo/lingo-lex.cpp"
#line 909 "engines/director/lingo/lingo-lex.cpp"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 169 "engines/director/lingo/lingo-lex.l"


#line 1130 "engines/director/lingo/lingo-lex.cpp"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 368 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 367 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 171 "engines/director/lingo/lingo-lex.l"
{ count(); }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 173 "engines/director/lingo/lingo-lex.l"
{ count(); yylval.s = new Common::String(yytext + 1); return tSYMBOL; }	// D3, skip '#'
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 175 "engines/director/lingo/lingo-lex.l"
{ count(); return tABBREVIATED; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 176 "engines/director/lingo/lingo-lex.l"
{ count(); return tABBREV; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 177 "engines/director/lingo/lingo-lex.l"
{ count(); return tABBR; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 178 "engines/director/lingo/lingo-lex.l"
{ count(); return tAFTER; }		// D3
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 179 "engines/director/lingo/lingo-lex.l"
{ count(); return tAND; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 180 "engines/director/lingo/lingo-lex.l"
{ count(); return tBEFORE; }	// D3
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 181 "engines/director/lingo/lingo-lex.l"
{ count(); return tCAST; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 182 "engines/director/lingo/lingo-lex.l"
{ count(); return tCASTLIB; }	// D5
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 183 "engines/director/lingo/lingo-lex.l"
{ count(); return tCASTLIBS; }	// D5
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 184 "engines/director/lingo/lingo-lex.l"
{ count(); return tCHAR; }		// D3
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 185 "engines/director/lingo/lingo-lex.l"
{ count(); return tCHARS; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 186 "engines/director/lingo/lingo-lex.l"
{ count(); return tCONTAINS; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 187 "engines/director/lingo/lingo-lex.l"
{ count(); return tDATE; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 188 "engines/director/lingo/lingo-lex.l"
{ count(); return tDELETE; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 189 "engines/director/lingo/lingo-lex.l"
{ count(); return tDOWN; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 190 "engines/director/lingo/lingo-lex.l"
{ count(); return tELSE; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 191 "engines/director/lingo/lingo-lex.l"
{
		count();

		const char *ptr = &yytext[3]; // Skip 'end '
		skipWhitespace(&ptr);

		if (!scumm_stricmp(ptr, "if"))
			return tENDIF;
		else if (!scumm_stricmp(ptr, "repeat"))
			return tENDREPEAT;
		else if (!scumm_stricmp(ptr, "tell"))
			return tENDTELL;

		yylval.s = new Common::String(ptr);

		return tENDCLAUSE;
	}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 208 "engines/director/lingo/lingo-lex.l"
{ count(); return tEXIT; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 209 "engines/director/lingo/lingo-lex.l"
{ count(); return tFACTORY; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 210 "engines/director/lingo/lingo-lex.l"
{ count(); return tFIELD; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 211 "engines/director/lingo/lingo-lex.l"
{ count(); return tFRAME; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 212 "engines/director/lingo/lingo-lex.l"
{ count(); return tGLOBAL; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 213 "engines/director/lingo/lingo-lex.l"
{ count(); return tGO; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 214 "engines/director/lingo/lingo-lex.l"
{ count(); return tHILITE; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 215 "engines/director/lingo/lingo-lex.l"
{ count(); return tIF; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 216 "engines/director/lingo/lingo-lex.l"
{ count(); return tINSTANCE; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 217 "engines/director/lingo/lingo-lex.l"
{ count(); return tINTERSECTS;}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 218 "engines/director/lingo/lingo-lex.l"
{ count(); return tINTO; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 219 "engines/director/lingo/lingo-lex.l"
{ count(); return tIN; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 220 "engines/director/lingo/lingo-lex.l"
{ count(); return tITEM; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 221 "engines/director/lingo/lingo-lex.l"
{ count(); return tITEMS; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 222 "engines/director/lingo/lingo-lex.l"
{ count(); return tLAST; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 223 "engines/director/lingo/lingo-lex.l"
{ count(); return tLINE; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 224 "engines/director/lingo/lingo-lex.l"
{ count(); return tLINES; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 225 "engines/director/lingo/lingo-lex.l"
{ count(); return tLONG; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 226 "engines/director/lingo/lingo-lex.l"
{ count(); return tMACRO; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 227 "engines/director/lingo/lingo-lex.l"
{ count(); return tMEMBER; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 228 "engines/director/lingo/lingo-lex.l"
{ count(); return tMENU; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 229 "engines/director/lingo/lingo-lex.l"
{ count(); return tMENUS; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 230 "engines/director/lingo/lingo-lex.l"
{ count(); return tMENUITEM;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 231 "engines/director/lingo/lingo-lex.l"
{ count(); return tMENUITEMS; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 232 "engines/director/lingo/lingo-lex.l"
{ count(); return tMETHOD; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 233 "engines/director/lingo/lingo-lex.l"
{ count(); return tMOD;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 234 "engines/director/lingo/lingo-lex.l"
{ count(); return tMOVIE; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 235 "engines/director/lingo/lingo-lex.l"
{ count(); return tNEXT; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 236 "engines/director/lingo/lingo-lex.l"
{ count(); return tNOT; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 237 "engines/director/lingo/lingo-lex.l"
{ count(); return tNUMBER; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 238 "engines/director/lingo/lingo-lex.l"
{ count(); return tOF; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 239 "engines/director/lingo/lingo-lex.l"
{ count(); return tON; }		// D3
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 240 "engines/director/lingo/lingo-lex.l"
{ count(); return tOPEN; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 241 "engines/director/lingo/lingo-lex.l"
{ count(); return tOR; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 242 "engines/director/lingo/lingo-lex.l"
{ count(); return tPLAY; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 243 "engines/director/lingo/lingo-lex.l"
{ count(); return tPREVIOUS; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 244 "engines/director/lingo/lingo-lex.l"
{ count(); return tPROPERTY; }	// D4
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 245 "engines/director/lingo/lingo-lex.l"
{ count(); return tPUT; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 246 "engines/director/lingo/lingo-lex.l"
{ count(); return tREPEAT; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 247 "engines/director/lingo/lingo-lex.l"
{ count(); return tRETURN; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 248 "engines/director/lingo/lingo-lex.l"
{ count(); return tSCRIPT; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 249 "engines/director/lingo/lingo-lex.l"
{ count(); return tASSERTERROR; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 250 "engines/director/lingo/lingo-lex.l"
{ count(); return tSET; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 251 "engines/director/lingo/lingo-lex.l"
{ count(); return tSHORT; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 252 "engines/director/lingo/lingo-lex.l"
{ count(); return tSOUND; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 253 "engines/director/lingo/lingo-lex.l"
{ count(); return tSPRITE; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 254 "engines/director/lingo/lingo-lex.l"
{ count(); return tSTARTS; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 255 "engines/director/lingo/lingo-lex.l"
{ count(); return tTELL; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 256 "engines/director/lingo/lingo-lex.l"
{ count(); return tTHE; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 257 "engines/director/lingo/lingo-lex.l"
{ count(); return tTHEN; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 258 "engines/director/lingo/lingo-lex.l"
{ count(); return tTIME; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 259 "engines/director/lingo/lingo-lex.l"
{ count(); return tTO; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 260 "engines/director/lingo/lingo-lex.l"
{
		count();

		const char *ptr =  &yytext[5]; // Skip 'when '
		skipWhitespace(&ptr);

		Common::String *eventName = readUntilWhitespace(&ptr);

		skipWhitespace(&ptr);
		ptr += 4; // Skip 'then'
		skipWhitespace(&ptr);

		Common::String *stmt = readUntilNewline(&ptr);

		yylval.w.eventName = eventName;
		yylval.w.stmt = stmt;
		return tWHEN;
	}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 278 "engines/director/lingo/lingo-lex.l"
{ count(); return tWHILE; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 279 "engines/director/lingo/lingo-lex.l"
{ count(); return tWINDOW; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 280 "engines/director/lingo/lingo-lex.l"
{ count(); return tWITH; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 281 "engines/director/lingo/lingo-lex.l"
{ count(); return tWITHIN; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 282 "engines/director/lingo/lingo-lex.l"
{ count(); return tWORD; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 283 "engines/director/lingo/lingo-lex.l"
{ count(); return tWORDS; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 284 "engines/director/lingo/lingo-lex.l"
{ count(); return tXTRAS; } // D5
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 286 "engines/director/lingo/lingo-lex.l"
{ count(); return tNEQ; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 287 "engines/director/lingo/lingo-lex.l"
{ count(); return tGE; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 288 "engines/director/lingo/lingo-lex.l"
{ count(); return tLE; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 289 "engines/director/lingo/lingo-lex.l"
{ count(); return tCONCAT; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 290 "engines/director/lingo/lingo-lex.l"
{ count(); return tEQ; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 292 "engines/director/lingo/lingo-lex.l"
{
		count();
		yylval.s = new Common::String(yytext);

		return tVARID;
	}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 298 "engines/director/lingo/lingo-lex.l"
{ count(); yylval.f = atof(yytext); return tFLOAT; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 299 "engines/director/lingo/lingo-lex.l"
{ count(); yylval.i = strtol(yytext, NULL, 10); return tINT; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 300 "engines/director/lingo/lingo-lex.l"
{ count(); return *yytext; }
	YY_BREAK
case 89:
/* rule 89 can match eol */
YY_RULE_SETUP
#line 301 "engines/director/lingo/lingo-lex.l"
{ count(); return '\n'; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 302 "engines/director/lingo/lingo-lex.l"
{ count(); yylval.s = cleanupString(&yytext[1]); yylval.s->deleteLastChar(); return tSTRING; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 303 "engines/director/lingo/lingo-lex.l"
{ count(); }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 305 "engines/director/lingo/lingo-lex.l"
ECHO;
	YY_BREAK
#line 1683 "engines/director/lingo/lingo-lex.cpp"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 368 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 368 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 367);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 305 "engines/director/lingo/lingo-lex.l"


extern int yydebug;

namespace Director {

int LingoCompiler::parse(const char *code) {
	inputbuffer = code;
	_bytenumber = 0;
	inputlen = strlen(code);

	_lines[0] = _lines[1] = _lines[2] = code;

	YY_BUFFER_STATE bp;

	if (debugChannelSet(-1, kDebugParse))
		yydebug = 1;
	else
		yydebug = 0;

	yy_delete_buffer(YY_CURRENT_BUFFER);

	bp = yy_scan_string(code);
	yy_switch_to_buffer(bp);
	yyparse();
	yy_delete_buffer(bp);

	return 0;
}

} // End of namespace Director

